/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.reversed;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.reversed.PSequenceReverseIterator;
import com.oracle.graal.python.builtins.objects.reversed.PStringReverseIterator;
import com.oracle.graal.python.builtins.objects.reversed.ReversedBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PReverseIterator})
public final class ReversedBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ReversedBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static Object setState(VirtualFrame frame, PBuiltinIterator self, Object index, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int idx = asSizeNode.executeExact((Frame)frame, inliningTarget, index);
            if (idx < -1) {
                idx = -1;
            }
            self.index = idx;
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object reduce(PStringReverseIterator self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode) {
            if (self.isExhausted()) {
                return this.reduceInternal(inliningTarget, self, "", null, getClassNode);
            }
            return this.reduceInternal(inliningTarget, self, self.value, self.index, getClassNode);
        }

        @Specialization(guards={"self.isPSequence()"})
        public Object reduce(PSequenceReverseIterator self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode) {
            if (self.isExhausted()) {
                return this.reduceInternal(inliningTarget, self, this.factory().createList(), null, getClassNode);
            }
            return this.reduceInternal(inliningTarget, self, self.getPSequence(), self.index, getClassNode);
        }

        @Specialization(guards={"!self.isPSequence()"})
        public Object reduce(VirtualFrame frame, PSequenceReverseIterator self, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___REDUCE__)") LookupAndCallUnaryNode callReduce, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode) {
            Object content = callReduce.executeObject(frame, self.getPSequence());
            return this.reduceInternal(inliningTarget, self, content, self.index, getClassNode);
        }

        private PTuple reduceInternal(Node inliningTarget, Object self, Object arg, Object state, GetClassNode getClassNode) {
            Object revIter = getClassNode.execute(inliningTarget, self);
            PTuple args = this.factory().createTuple(new Object[]{arg});
            if (state != null) {
                return this.factory().createTuple(new Object[]{revIter, args, state});
            }
            return this.factory().createTuple(new Object[]{revIter, args});
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isExhausted()"})
        public int exhausted(PBuiltinIterator self) {
            return 0;
        }

        @Specialization(guards={"!self.isExhausted()"})
        public int lengthHint(PStringReverseIterator self) {
            return self.index + 1;
        }

        @Specialization(guards={"!self.isExhausted()", "self.isPSequence()"})
        public int lengthHint(PSequenceReverseIterator self, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.LenNode lenNode) {
            int len = lenNode.execute(inliningTarget, self.getPSequence());
            if (len == -1) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_HAS_NO_LEN, self);
            }
            if (len < self.index) {
                return 0;
            }
            return self.index + 1;
        }

        @Specialization(guards={"!self.isExhausted()", "!self.isPSequence()"})
        public static int lengthHint(VirtualFrame frame, PSequenceReverseIterator self, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            int len = sizeNode.execute((Frame)frame, inliningTarget, self.getObject());
            if (len < self.index) {
                return 0;
            }
            return self.index + 1;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(Object self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isExhausted()"})
        public Object exhausted(PBuiltinIterator self) {
            throw this.raiseStopIteration();
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(VirtualFrame frame, PSequenceReverseIterator self, @Bind(value="this") Node inliningTarget, @Cached(value="create(GetItem)") LookupAndCallBinaryNode callGetItem, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
            if (self.index >= 0) {
                try {
                    return callGetItem.executeObject(frame, self.getObject(), self.index--);
                }
                catch (PException e) {
                    e.expectIndexError(inliningTarget, profile);
                }
            }
            self.setExhausted();
            throw this.raiseStopIteration();
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PStringReverseIterator self, @Cached TruffleString.SubstringNode substringNode) {
            if (self.index >= 0) {
                return substringNode.execute((AbstractTruffleString)self.value, self.index--, 1, PythonUtils.TS_ENCODING, false);
            }
            self.setExhausted();
            throw this.raiseStopIteration();
        }
    }
}

