/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.SlotMethodDef;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.type.MroShape;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupNativeSlotNodeGen;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={LookupAttributeInMRONode.class})
public abstract class LookupNativeSlotNode
extends PNodeWithContext {
    protected final SlotMethodDef slot;
    private static final LookupNativeSlotNode[] UNCACHED = new LookupNativeSlotNode[SlotMethodDef.values().length];

    public LookupNativeSlotNode(SlotMethodDef slot) {
        this.slot = slot;
    }

    public abstract Object execute(PythonManagedClass var1);

    public static LookupNativeSlotNode getUncached(SlotMethodDef slot) {
        return UNCACHED[slot.ordinal()];
    }

    @CompilerDirectives.TruffleBoundary
    public static Object executeUncached(PythonManagedClass type, SlotMethodDef slot) {
        return LookupNativeSlotNode.getUncached(slot).execute(type);
    }

    protected LookupAttributeInMRONode.AttributeAssumptionPair findAttrAndAssumptionInMRO(Object klass) {
        PDict dict;
        CompilerAsserts.neverPartOfCompilation();
        if (klass instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeKlass = (PythonAbstractNativeObject)klass;
            Object nativedict = CStructAccess.ReadObjectNode.getUncached().readFromObj(nativeKlass, CFields.PyTypeObject__tp_dict);
            dict = nativedict == PNone.NO_VALUE ? null : (PDict)nativedict;
        } else {
            dict = GetDictIfExistsNode.getUncached().execute(klass);
        }
        if (dict != null && HashingStorageNodes.HashingStorageGuards.mayHaveSideEffects(dict)) {
            return null;
        }
        MroSequenceStorage mro = TypeNodes.GetMroStorageNode.executeUncached(klass);
        Assumption attrAssumption = mro.createAttributeInMROFinalAssumption(this.slot.methodName);
        for (int i = 0; i < mro.length(); ++i) {
            Object value;
            PythonAbstractClass clsObj = mro.getItemNormalized(i);
            if (i > 0) {
                assert (clsObj != klass) : "MRO chain is incorrect: '" + klass + "' was found at position " + i;
                TypeNodes.GetMroStorageNode.executeUncached(clsObj).addAttributeInMROFinalAssumption(this.slot.methodName, attrAssumption);
            }
            if ((value = this.readSlot(clsObj, ReadAttributeFromObjectNode.getUncachedForceType(), CStructAccess.ReadPointerNode.getUncached(), InteropLibrary.getUncached())) == null) continue;
            return new LookupAttributeInMRONode.AttributeAssumptionPair(attrAssumption, value);
        }
        return new LookupAttributeInMRONode.AttributeAssumptionPair(attrAssumption, this.getNULL());
    }

    @Specialization(guards={"isSingleContext()", "isSameTypeNode.execute(inliningTarget, cachedKlass, klass)", "cachedAttrInMROInfo != null"}, limit="getAttributeAccessInlineCacheMaxDepth()", assumptions={"cachedAttrInMROInfo.assumption"})
    protected static Object lookupConstantMROCached(PythonManagedClass klass, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached(value="klass") Object cachedKlass, @Cached(value="findAttrAndAssumptionInMRO(cachedKlass)") LookupAttributeInMRONode.AttributeAssumptionPair cachedAttrInMROInfo) {
        return cachedAttrInMROInfo.value;
    }

    @Specialization(guards={"!isSingleContext()", "cachedMroShape != null", "klass.getMroShape() == cachedMroShape"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    protected Object lookupConstantMROShape(PythonClass klass, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.GetMroStorageNode getMroStorageNode, @Cached(value="klass.getMroShape()") MroShape cachedMroShape, @Cached(value="lookupInMroShape(cachedMroShape, klass)") MroShape.MroShapeLookupResult lookupResult) {
        return this.wrapManagedMethod(klass, lookupResult.getFromMro(getMroStorageNode.execute(inliningTarget, klass), this.slot.methodName));
    }

    protected static MroSequenceStorage getMroStorageUncached(Object object) {
        return TypeNodes.GetMroStorageNode.executeUncached(object);
    }

    @Specialization(guards={"isSingleContext()", "isSameTypeNode.execute(inliningTarget, cachedKlass, klass)", "mroLength < 32"}, limit="getAttributeAccessInlineCacheMaxDepth()", replaces={"lookupConstantMROShape"}, assumptions={"lookupStable"})
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    protected Object lookupConstantMRO(PythonManagedClass klass, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached(value="klass") Object cachedKlass, @Cached(value="getMroStorageUncached(cachedKlass)") MroSequenceStorage mro, @Cached(value="mro.getLookupStableAssumption()") Assumption lookupStable, @Cached(value="mro.length()") int mroLength, @Cached(value="create(mroLength)") ReadAttributeFromObjectNode[] readAttrNodes, @Cached.Shared @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
        for (int i = 0; i < mroLength; ++i) {
            PythonAbstractClass kls = mro.getItemNormalized(i);
            Object value = this.readSlot(kls, readAttrNodes[i], readPointerNode, interopLibrary);
            if (value == null) continue;
            return value;
        }
        return this.getNULL();
    }

    @Specialization(guards={"mroLength == cachedMroLength", "cachedMroLength < 32"}, replaces={"lookupConstantMROCached", "lookupConstantMRO"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    protected Object lookupCachedLen(PythonManagedClass klass, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.GetMroStorageNode getMroStorageNode, @Bind(value="getMroStorageNode.execute(inliningTarget, klass)") MroSequenceStorage mro, @Bind(value="mro.length()") int mroLength, @Cached(value="mro.length()") int cachedMroLength, @Cached(value="create(cachedMroLength)") ReadAttributeFromObjectNode[] readAttrNodes, @Cached.Shared @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
        for (int i = 0; i < cachedMroLength; ++i) {
            PythonAbstractClass kls = mro.getItemNormalized(i);
            Object value = this.readSlot(kls, readAttrNodes[i], readPointerNode, interopLibrary);
            if (value == null) continue;
            return value;
        }
        return this.getNULL();
    }

    @Specialization(replaces={"lookupConstantMROCached", "lookupConstantMRO", "lookupCachedLen"})
    @ReportPolymorphism.Megamorphic
    protected Object lookupGeneric(PythonManagedClass klass, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.GetMroStorageNode getMroStorageNode, @Cached.Exclusive @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttrNode, @Cached.Shared @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
        MroSequenceStorage mro = getMroStorageNode.execute(inliningTarget, klass);
        for (int i = 0; i < mro.length(); ++i) {
            PythonAbstractClass kls = mro.getItemNormalized(i);
            Object value = this.readSlot(kls, readAttrNode, readPointerNode, interopLibrary);
            if (value == null) continue;
            return value;
        }
        return this.getNULL();
    }

    public MroShape.MroShapeLookupResult lookupInMroShape(MroShape shape, Object klass) {
        assert (MroShape.validate(klass, PythonLanguage.get(this)));
        return shape.lookup(this.slot.methodName);
    }

    private Object getNULL() {
        return this.getContext().getNativeNull().getPtr();
    }

    private Object readSlot(PythonAbstractClass currentType, ReadAttributeFromObjectNode readNode, CStructAccess.ReadPointerNode readPointerNode, InteropLibrary interopLibrary) {
        if (currentType instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)currentType;
            Object value = readPointerNode.readFromObj(nativeObject, this.slot.typeField);
            if (!PGuards.isNullOrZero(value, interopLibrary)) {
                if (this.slot.methodsField == null) {
                    return value;
                }
                if (!PGuards.isNullOrZero(value = readPointerNode.read(value, this.slot.methodsField), interopLibrary)) {
                    return value;
                }
            }
        } else {
            PythonBuiltinClass builtinClass;
            assert (currentType instanceof PythonManagedClass);
            if (this.slot.methodFlag != 0L && currentType instanceof PythonBuiltinClass && ((builtinClass = (PythonBuiltinClass)currentType).getType().getMethodsFlags() & this.slot.methodFlag) == 0L) {
                return null;
            }
            Object value = readNode.execute(currentType, this.slot.methodName);
            if (value != PNone.NO_VALUE) {
                return this.wrapManagedMethod((PythonManagedClass)currentType, value);
            }
        }
        return null;
    }

    private Object wrapManagedMethod(PythonManagedClass owner, Object value) {
        if (value instanceof PNone) {
            return this.getNULL();
        }
        return this.getContext().getCApiContext().getOrCreateProcWrapper(owner, this.slot, () -> (PyProcsWrapper)this.slot.wrapperFactory.apply(value));
    }

    static {
        for (int i = 0; i < SlotMethodDef.values().length; ++i) {
            SlotMethodDef slot = SlotMethodDef.values()[i];
            LookupNativeSlotNode.UNCACHED[i] = new Uncached(slot);
        }
    }

    @GenerateCached(value=false)
    private static final class Uncached
    extends LookupNativeSlotNode {
        Uncached(SlotMethodDef slot) {
            super(slot);
        }

        public boolean isAdoptable() {
            return false;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(PythonManagedClass type) {
            return this.lookupGeneric(type, null, TypeNodes.GetMroStorageNode.getUncached(), ReadAttributeFromObjectNode.getUncachedForceType(), CStructAccess.ReadPointerNode.getUncached(), InteropLibrary.getUncached());
        }
    }

    @GenerateUncached
    @ImportStatic(value={SpecialMethodSlot.class, SlotMethodDef.class})
    @GenerateInline(value=false)
    public static abstract class LookupNativeGetattroSlotNode
    extends Node {
        public abstract Object execute(PythonManagedClass var1);

        public static Object executeUncached(PythonManagedClass type) {
            return LookupNativeSlotNodeGen.LookupNativeGetattroSlotNodeGen.getUncached().execute(type);
        }

        @Specialization
        Object get(PythonManagedClass type, @Cached(parameters={"GetAttr"}) LookupCallableSlotInMRONode lookupGetattr, @Cached(parameters={"GetAttribute"}) LookupCallableSlotInMRONode lookupGetattribute, @Cached(parameters={"TP_GETATTRO"}) LookupNativeSlotNode lookupNativeGetattro) {
            Object getattr = lookupGetattr.execute(type);
            if (getattr == PNone.NO_VALUE) {
                return lookupNativeGetattro.execute(type);
            }
            Object getattribute = lookupGetattribute.execute(type);
            return PythonContext.get(this).getCApiContext().getOrCreateProcWrapper(type, SlotMethodDef.TP_GETATTRO, () -> new PyProcsWrapper.GetAttrCombinedWrapper(getattribute, getattr));
        }
    }
}

