/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.frame.WriteGlobalNodeGen;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
public abstract class WriteGlobalNode
extends PNodeWithContext {
    public static WriteGlobalNode getUncached() {
        return WriteGlobalNodeGen.getUncached();
    }

    @NeverDefault
    public static WriteGlobalNode create() {
        return WriteGlobalNodeGen.create();
    }

    public final void executeObject(VirtualFrame frame, TruffleString name, Object value) {
        CompilerAsserts.partialEvaluationConstant((Object)name);
        this.executeObjectWithGlobals(frame, PArguments.getGlobals((Frame)frame), name, value);
    }

    public final void write(Frame frame, Object globals, TruffleString name, Object value) {
        CompilerAsserts.partialEvaluationConstant((Object)name);
        this.executeObjectWithGlobals((VirtualFrame)frame, globals, name, value);
    }

    public abstract void executeObjectWithGlobals(VirtualFrame var1, Object var2, TruffleString var3, Object var4);

    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals", "isBuiltinDict(cachedGlobals)"}, limit="1")
    void writeDictObjectCached(VirtualFrame frame, PDict globals, TruffleString attributeId, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="globals", weak=true) PDict cachedGlobals, @Cached.Shared(value="setItemDict") @Cached HashingCollectionNodes.SetItemNode storeNode) {
        storeNode.execute((Frame)frame, inliningTarget, cachedGlobals, attributeId, value);
    }

    @Specialization(replaces={"writeDictObjectCached"}, guards={"isBuiltinDict(globals)"})
    void writeDictObject(VirtualFrame frame, PDict globals, TruffleString attributeId, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="setItemDict") @Cached HashingCollectionNodes.SetItemNode storeNode) {
        storeNode.execute((Frame)frame, inliningTarget, globals, attributeId, value);
    }

    @Specialization(replaces={"writeDictObject", "writeDictObjectCached"})
    void writeGenericDict(VirtualFrame frame, PDict globals, TruffleString attributeId, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetItem storeNode) {
        storeNode.execute((Frame)frame, inliningTarget, globals, attributeId, value);
    }

    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals"}, limit="1")
    void writeModuleCached(PythonModule globals, TruffleString attributeId, Object value, @Cached(value="globals", weak=true) PythonModule cachedGlobals, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write) {
        write.execute((Object)cachedGlobals, attributeId, value);
    }

    @Specialization(replaces={"writeModuleCached"})
    void writeModule(PythonModule globals, TruffleString attributeId, Object value, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write) {
        write.execute((Object)globals, attributeId, value);
    }
}

