/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser;

import com.oracle.graal.python.pegparser.tokenizer.SourceRange;

public interface ErrorCallback {
    public void reportIncompleteSource(int var1);

    public void onError(ErrorType var1, SourceRange var2, String var3);

    public void onWarning(WarningType var1, SourceRange var2, String var3);

    default public void onError(ErrorType errorType, SourceRange sourceRange, String message, Object ... arguments) {
        this.onError(errorType, sourceRange, String.format(message, arguments));
    }

    default public void onError(SourceRange sourceRange, String message, Object ... arguments) {
        this.onError(ErrorType.Generic, sourceRange, String.format(message, arguments));
    }

    default public void onWarning(WarningType warningType, SourceRange sourceRange, String message, Object ... arguments) {
        this.onWarning(warningType, sourceRange, String.format(message, arguments));
    }

    public static enum ErrorType {
        Generic,
        Indentation,
        Tab,
        Encoding,
        Value,
        Syntax,
        System;

    }

    public static enum WarningType {
        Deprecation,
        Syntax;

    }
}

