/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=PythonBufferAccessLibrary.class)
public final class NativeByteSequenceStorage
extends NativeSequenceStorage {
    private NativeByteSequenceStorage(Object ptr, int length, int capacity) {
        super(ptr, length, capacity);
    }

    public static NativeByteSequenceStorage create(Object ptr, int length, int capacity, boolean ownsMemory) {
        NativeByteSequenceStorage storage = new NativeByteSequenceStorage(ptr, length, capacity);
        if (ownsMemory) {
            CApiTransitions.registerNativeSequenceStorage(storage);
        }
        return storage;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Byte;
    }

    @Override
    public String toString(boolean isList) {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("%sNativeByteSequenceStorage(len=%d, cap=%d) at %s%s", isList ? "[" : "(", this.length, this.capacity, this.getPtr(), isList ? "]" : ")");
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    int getBufferLength() {
        return this.length;
    }

    @ExportMessage
    byte readByte(int byteOffset, @Cached CStructAccess.ReadByteNode readNode) {
        return readNode.readArrayElement(this.getPtr(), byteOffset);
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value, @Cached CStructAccess.WriteByteNode writeNode) {
        writeNode.writeArrayElement(this.getPtr(), byteOffset, value);
    }
}

