/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;

public final class NativeObjectSequenceStorage
extends NativeSequenceStorage {
    private NativeObjectSequenceStorage(Object ptr, int length, int capacity) {
        super(ptr, length, capacity);
    }

    public static NativeObjectSequenceStorage create(Object ptr, int length, int capacity, boolean ownsMemory) {
        NativeObjectSequenceStorage storage = new NativeObjectSequenceStorage(ptr, length, capacity);
        if (ownsMemory) {
            CApiTransitions.registerNativeSequenceStorage(storage);
        }
        return storage;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Generic;
    }

    @Override
    public String toString(boolean isList) {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("%sNativeObjectSequenceStorage(len=%d, cap=%d) at %s%s", isList ? "[" : "(", this.length, this.capacity, this.getPtr(), isList ? "]" : ")");
    }
}

