/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BooleanSupplier;

public interface InternalResource {
    public void unpackFiles(Env var1, Path var2) throws IOException;

    public String versionHash(Env var1);

    public static enum CPUArchitecture {
        AARCH64("aarch64"),
        AMD64("amd64");

        private final String id;

        private CPUArchitecture(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static CPUArchitecture getCurrent() {
            String arch = System.getProperty("os.arch");
            if (arch == null) {
                throw CompilerDirectives.shouldNotReachHere("The 'os.arch' system property is not set.");
            }
            return switch (arch) {
                case "amd64", "x86_64" -> AMD64;
                case "aarch64", "arm64" -> AARCH64;
                default -> throw CompilerDirectives.shouldNotReachHere("Unsupported CPU architecture " + arch);
            };
        }
    }

    public static enum OS {
        DARWIN("darwin"),
        LINUX("linux"),
        WINDOWS("windows");

        private final String id;

        private OS(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static OS getCurrent() {
            String os = System.getProperty("os.name");
            if (os == null) {
                throw CompilerDirectives.shouldNotReachHere("The 'os.name' system property is not set.");
            }
            if (os.equalsIgnoreCase("linux")) {
                return LINUX;
            }
            if (os.equalsIgnoreCase("mac os x") || os.equalsIgnoreCase("darwin")) {
                return DARWIN;
            }
            if (os.toLowerCase().startsWith("windows")) {
                return WINDOWS;
            }
            throw CompilerDirectives.shouldNotReachHere("Unsupported OS name " + os);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Id {
        public String value();

        public String componentId() default "";

        public boolean optional() default false;
    }

    public static final class Env {
        private final Class<? extends InternalResource> resourceClass;
        private final Module owner;
        private final BooleanSupplier contextPreinitializationCheck;

        Env(InternalResource resource, BooleanSupplier contextPreinitializationCheck) {
            this.resourceClass = resource.getClass();
            this.owner = this.resourceClass.getModule();
            this.contextPreinitializationCheck = Objects.requireNonNull(contextPreinitializationCheck, "ContextPreinitializationCheck  must be non-null.");
        }

        public boolean inContextPreinitialization() {
            return this.contextPreinitializationCheck.getAsBoolean();
        }

        public boolean inNativeImageBuild() {
            return TruffleOptions.AOT;
        }

        public CPUArchitecture getCPUArchitecture() {
            return CPUArchitecture.getCurrent();
        }

        public OS getOS() {
            return OS.getCurrent();
        }

        public List<String> readResourceLines(Path location) throws IOException {
            if (location.isAbsolute()) {
                throw new IllegalArgumentException("Location must be a relative path, but the absolute path " + location + " was given.");
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.findResource(location), StandardCharsets.UTF_8));){
                ArrayList<String> content = new ArrayList<String>();
                String line = in.readLine();
                while (line != null) {
                    content.add(line);
                    line = in.readLine();
                }
                ArrayList<String> arrayList = content;
                return arrayList;
            }
        }

        public void unpackResourceFiles(Path source, Path target, Path relativizeTo) throws IOException {
            if (source.isAbsolute()) {
                throw new IllegalArgumentException("Source must be a relative path, but the absolute path " + source + " was given.");
            }
            if (relativizeTo.isAbsolute()) {
                throw new IllegalArgumentException("RelativizeTo must be a relative path, but the absolute path " + relativizeTo + " was given.");
            }
            Properties fileList = this.loadFileList(source);
            for (Map.Entry<Object, Object> e : fileList.entrySet()) {
                Path resource = Path.of((String)e.getKey(), new String[0]);
                Set<PosixFilePermission> attrs = Env.parseAttrs((String)e.getValue());
                if (resource.isAbsolute()) {
                    throw new IllegalArgumentException("The file list must contain only relative paths, but the absolute path " + resource + " was given.");
                }
                Path relativizedPath = resource.startsWith(relativizeTo) ? relativizeTo.relativize(resource) : relativizeTo;
                this.copyResource(resource, target.resolve(relativizedPath), attrs);
            }
        }

        private Properties loadFileList(Path source) throws IOException {
            Properties props = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(this.findResource(source));){
                props.load(in);
            }
            return props;
        }

        private static Set<PosixFilePermission> parseAttrs(String rawValue) {
            String[] attrComponents = rawValue.split(",");
            if (attrComponents.length != 1) {
                throw new IllegalArgumentException("Invalid attributes format " + rawValue + ". Attribute value can have only a single component");
            }
            return PosixFilePermissions.fromString(attrComponents[0].trim());
        }

        private InputStream findResource(Path path) throws IOException {
            InputStream stream;
            String resourceName = path.toString().replace(File.separatorChar, '/');
            if (this.owner.isNamed()) {
                stream = this.owner.getResourceAsStream(resourceName);
            } else {
                Enumeration<URL> resources = this.resourceClass.getClassLoader().getResources(resourceName);
                URL resource = this.preferredResource(resources);
                InputStream inputStream = stream = resource != null ? resource.openStream() : null;
            }
            if (stream == null) {
                throw new NoSuchFileException(resourceName);
            }
            return stream;
        }

        private URL preferredResource(Enumeration<URL> candidates) {
            URL location;
            if (!candidates.hasMoreElements()) {
                return null;
            }
            URL preferred = candidates.nextElement();
            if (!candidates.hasMoreElements()) {
                return preferred;
            }
            CodeSource codeSource = this.resourceClass.getProtectionDomain().getCodeSource();
            URL uRL = location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return preferred;
            }
            Path classOwner = Env.fileURL(location);
            if (classOwner == null) {
                return preferred;
            }
            if (!Env.isInClassSourceLocation(preferred, classOwner)) {
                while (candidates.hasMoreElements()) {
                    URL candidate = candidates.nextElement();
                    if (!Env.isInClassSourceLocation(candidate, classOwner)) continue;
                    preferred = candidate;
                    break;
                }
            }
            return preferred;
        }

        private static boolean isInClassSourceLocation(URL resource, Path classSourceLocation) {
            Path resourceOwner = Env.fileURL(resource);
            return resourceOwner != null && resourceOwner.startsWith(classSourceLocation);
        }

        private static Path fileURL(URL url) {
            try {
                URI useURI = url.toURI();
                if ("jar".equals(url.getProtocol())) {
                    String path = useURI.getRawSchemeSpecificPart();
                    int index = path.indexOf("!/");
                    String jarPath = index >= 0 ? path.substring(0, index) : null;
                    URI uRI = useURI = jarPath != null ? new URI(jarPath) : null;
                }
                if (useURI != null && "file".equals(useURI.getScheme())) {
                    return Paths.get(useURI);
                }
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        private void copyResource(Path source, Path target, Set<PosixFilePermission> attrs) throws IOException {
            Path parent = target.getParent();
            if (parent == null) {
                throw CompilerDirectives.shouldNotReachHere("RelativeResourcePath must be non-empty.");
            }
            Files.createDirectories(parent, new FileAttribute[0]);
            try (BufferedInputStream in = new BufferedInputStream(this.findResource(source));){
                Files.copy(in, target, new CopyOption[0]);
            }
            if (this.getOS() != OS.WINDOWS) {
                Files.setPosixFilePermissions(target, attrs);
            }
        }
    }
}

