/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeOptionDescriptorIterator;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.Iterator;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.word.WordFactory;

final class NativeOptionDescriptorIteratorGen {
    NativeOptionDescriptorIteratorGen() {
    }

    static NativeOptionDescriptorIterator createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionDescriptorIterator createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionDescriptorIterator create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeOptionDescriptorIteratorGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeOptionDescriptorIteratorGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeOptionDescriptorIterator {
        private static final BinaryMarshaller<OptionDescriptor> optionDescriptorMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        @Override
        public boolean hasNext() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                boolean bl = StartPoint.hasNext0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public OptionDescriptor next() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.next0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                OptionDescriptor optionDescriptor = (OptionDescriptor)optionDescriptorMarshaller.read(binaryInput);
                return optionDescriptor;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native boolean hasNext0(long var0, long var2);

        private static native byte[] next0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            optionDescriptorMarshaller = jNIConfig.lookupMarshaller(OptionDescriptor.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<OptionDescriptor> optionDescriptorMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOptionDescriptorIteratorGen_00024StartPoint_hasNext0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean hasNext(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeOptionDescriptorIteratorGen::hasNext", jNIEnv);
            try {
                boolean bl2;
                Iterator iterator = (Iterator)NativeObjectHandles.resolve((long)l3, Iterator.class);
                bl = bl2 = iterator.hasNext();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
            jNIMethodScope.close();
            return bl;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOptionDescriptorIteratorGen_00024StartPoint_next0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray next(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeOptionDescriptorIteratorGen::next", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Iterator iterator = (Iterator)NativeObjectHandles.resolve((long)l3, Iterator.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                OptionDescriptor optionDescriptor = (OptionDescriptor)iterator.next();
                int n2 = optionDescriptorMarshaller.inferSize((Object)optionDescriptor);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    optionDescriptorMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)optionDescriptor);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            optionDescriptorMarshaller = jNIConfig.lookupMarshaller(OptionDescriptor.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

