/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.jboss.netty.buffer.ChannelBuffer;

final class CompareAndSetRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue,
HBaseRpc.IsEdit {
    private static final byte[] CHECKANDPUT = new byte[]{99, 104, 101, 99, 107, 65, 110, 100, 80, 117, 116};
    private final PutRequest put;
    private final byte[] expected;

    public CompareAndSetRequest(PutRequest put, byte[] expected) {
        super(CHECKANDPUT, put.table(), put.key());
        KeyValue.checkValue(expected);
        this.put = put;
        this.expected = expected;
    }

    public byte[] table() {
        return this.put.table();
    }

    public byte[] key() {
        return this.put.key();
    }

    public byte[] family() {
        return this.put.family();
    }

    public byte[] qualifier() {
        return this.put.qualifier();
    }

    public byte[] expectedValue() {
        return this.expected;
    }

    public byte[] value() {
        return this.put.value();
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        size += 3;
        size += this.key.length;
        ++size;
        size += 3;
        size += this.put.family().length;
        ++size;
        size += 3;
        size += this.put.qualifier().length;
        ++size;
        size += 4;
        size += this.expected.length;
        return size += this.put.predictPutSize();
    }

    ChannelBuffer serialize(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(6);
        CompareAndSetRequest.writeHBaseByteArray(buf, this.region.name());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.put.key());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.put.family());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.put.qualifier());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.expected);
        this.put.serializeInto(buf);
        return buf;
    }
}

