/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.cache.LoadingCache;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.BrokenMetaException;
import org.hbase.async.BufferedIncrement;
import org.hbase.async.Bytes;
import org.hbase.async.ClientStats;
import org.hbase.async.CompareAndSetRequest;
import org.hbase.async.Counter;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PleaseThrottleException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionClient;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.hbase.async.RowLockRequest;
import org.hbase.async.Scanner;
import org.hbase.async.TableNotFoundException;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HBaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseClient.class);
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static final byte[] ROOT = new byte[]{45, 82, 79, 79, 84, 45};
    private static final byte[] ROOT_REGION = new byte[]{45, 82, 79, 79, 84, 45, 44, 44, 48};
    private static final byte[] META = new byte[]{46, 77, 69, 84, 65, 46};
    private static final byte[] INFO = new byte[]{105, 110, 102, 111};
    private static final byte[] REGIONINFO = new byte[]{114, 101, 103, 105, 111, 110, 105, 110, 102, 111};
    private static final byte[] SERVER = new byte[]{115, 101, 114, 118, 101, 114};
    private final HashedWheelTimer timer = new HashedWheelTimer(20L, TimeUnit.MILLISECONDS);
    private volatile short flush_interval = (short)1000;
    private volatile int increment_buffer_size = 65535;
    private final ClientSocketChannelFactory channel_factory;
    private final ZKClient zkclient;
    private volatile RegionClient rootregion;
    private final ConcurrentSkipListMap<byte[], RegionInfo> regions_cache = new ConcurrentSkipListMap(RegionInfo.REGION_NAME_CMP);
    private final ConcurrentHashMap<RegionInfo, RegionClient> region2client = new ConcurrentHashMap();
    private final ConcurrentHashMap<RegionClient, ArrayList<RegionInfo>> client2regions = new ConcurrentHashMap();
    private final HashMap<String, RegionClient> ip2client = new HashMap();
    private final ConcurrentSkipListMap<byte[], ArrayList<HBaseRpc>> got_nsre = new ConcurrentSkipListMap(RegionInfo.REGION_NAME_CMP);
    private volatile LoadingCache<BufferedIncrement, BufferedIncrement.Amount> increment_buffer;
    private final Counter num_connections_created = new Counter();
    private final Counter root_lookups = new Counter();
    private final Counter meta_lookups_with_permit = new Counter();
    private final Counter meta_lookups_wo_permit = new Counter();
    private final Counter num_flushes = new Counter();
    private final Counter num_nsres = new Counter();
    private final Counter num_nsre_rpcs = new Counter();
    final Counter num_multi_rpcs = new Counter();
    private final Counter num_gets = new Counter();
    private final Counter num_scanners_opened = new Counter();
    private final Counter num_scans = new Counter();
    private final Counter num_puts = new Counter();
    private final Counter num_row_locks = new Counter();
    private final Counter num_deletes = new Counter();
    private final Counter num_atomic_increments = new Counter();
    private static final Callback<ArrayList<KeyValue>, Object> got = new Callback<ArrayList<KeyValue>, Object>(){

        public ArrayList<KeyValue> call(Object response) {
            if (response instanceof ArrayList) {
                ArrayList row = (ArrayList)response;
                return row;
            }
            throw new InvalidResponseException(ArrayList.class, response);
        }

        public String toString() {
            return "type get response";
        }
    };
    private static final Callback<Long, Object> scanner_opened = new Callback<Long, Object>(){

        public Long call(Object response) {
            if (response instanceof Long) {
                return (Long)response;
            }
            throw new InvalidResponseException(Long.class, response);
        }

        public String toString() {
            return "type openScanner response";
        }
    };
    private static final Callback<Long, Object> icv_done = new Callback<Long, Object>(){

        public Long call(Object response) {
            if (response instanceof Long) {
                return (Long)response;
            }
            throw new InvalidResponseException(Long.class, response);
        }

        public String toString() {
            return "type incrementColumnValue response";
        }
    };
    private static final CompareAndSetCB CAS_CB = new CompareAndSetCB();
    private final MetaCB meta_lookup_done = new MetaCB();
    private final RootCB root_lookup_done = new RootCB();
    private static final short NSRE_LOW_WATERMARK = 1000;
    private static final short NSRE_HIGH_WATERMARK = 10000;
    private static final short NSRE_LOG_EVERY = 500;

    public HBaseClient(String quorum_spec) {
        this(quorum_spec, "/hbase");
    }

    public HBaseClient(String quorum_spec, String base_path) {
        this(quorum_spec, base_path, (ClientSocketChannelFactory)HBaseClient.defaultChannelFactory());
    }

    private static NioClientSocketChannelFactory defaultChannelFactory() {
        ExecutorService executor = Executors.newCachedThreadPool();
        return new NioClientSocketChannelFactory((Executor)executor, (Executor)executor);
    }

    public HBaseClient(String quorum_spec, String base_path, Executor executor) {
        this(quorum_spec, base_path, (ClientSocketChannelFactory)new CustomChannelFactory(executor));
    }

    public HBaseClient(String quorum_spec, String base_path, ClientSocketChannelFactory channel_factory) {
        this.channel_factory = channel_factory;
        this.zkclient = new ZKClient(quorum_spec, base_path);
    }

    public ClientStats stats() {
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> cache = this.increment_buffer;
        return new ClientStats(this.num_connections_created.get(), this.root_lookups.get(), this.meta_lookups_with_permit.get(), this.meta_lookups_wo_permit.get(), this.num_flushes.get(), this.num_nsres.get(), this.num_nsre_rpcs.get(), this.num_multi_rpcs.get(), this.num_gets.get(), this.num_scanners_opened.get(), this.num_scans.get(), this.num_puts.get(), this.num_row_locks.get(), this.num_deletes.get(), this.num_atomic_increments.get(), cache != null ? cache.stats() : BufferedIncrement.ZERO_STATS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> flush() {
        boolean need_sync;
        Deferred<Object> d = this.zkclient.getDeferredRootIfBeingLookedUp();
        if (d != null) {
            LOG.debug("Flush needs to wait on -ROOT- to come back");
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class RetryFlush
            implements Callback<Object, Object> {
                RetryFlush() {
                }

                public Object call(Object arg) {
                    LOG.debug("Flush retrying after -ROOT- came back");
                    return HBaseClient.this.flush();
                }

                public String toString() {
                    return "retry flush";
                }
            }
            return d.addBoth((Callback)new RetryFlush());
        }
        this.num_flushes.increment();
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> buf = this.increment_buffer;
        if (buf != null && !buf.asMap().isEmpty()) {
            HBaseClient.flushBufferedIncrements(buf);
            need_sync = true;
        } else {
            need_sync = false;
        }
        ArrayList<Deferred<Object>> d2 = new ArrayList<Deferred<Object>>(this.client2regions.size() + this.got_nsre.size() * 8);
        for (RegionClient client : this.client2regions.keySet()) {
            d2.add(need_sync ? client.sync() : client.flush());
        }
        Iterator<Object> i$ = this.got_nsre.values().iterator();
        while (i$.hasNext()) {
            ArrayList nsred;
            ArrayList arrayList = nsred = (ArrayList)i$.next();
            synchronized (arrayList) {
                for (HBaseRpc rpc : nsred) {
                    if (!(rpc instanceof HBaseRpc.IsEdit)) continue;
                    d2.add(rpc.getDeferred());
                }
            }
        }
        Deferred flushed = Deferred.group(d2);
        return flushed;
    }

    public short setFlushInterval(short flush_interval) {
        if (flush_interval < 0) {
            throw new IllegalArgumentException("Negative: " + flush_interval);
        }
        short prev = this.flush_interval;
        this.flush_interval = flush_interval;
        return prev;
    }

    public int setIncrementBufferSize(int increment_buffer_size) {
        if (increment_buffer_size < 0) {
            throw new IllegalArgumentException("Negative: " + increment_buffer_size);
        }
        int current = this.increment_buffer_size;
        if (current == increment_buffer_size) {
            return current;
        }
        this.increment_buffer_size = increment_buffer_size;
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> prev = this.increment_buffer;
        if (prev != null) {
            this.makeIncrementBuffer();
            HBaseClient.flushBufferedIncrements(prev);
        }
        return current;
    }

    public Timer getTimer() {
        return this.timer;
    }

    void newTimeout(TimerTask task, long timeout_ms) {
        try {
            this.timer.newTimeout(task, timeout_ms, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException e) {
            LOG.warn("Failed to schedule timer.  Ignore this if we're shutting down.", (Throwable)e);
        }
    }

    public short getFlushInterval() {
        return this.flush_interval;
    }

    public int getIncrementBufferSize() {
        return this.increment_buffer_size;
    }

    public Deferred<Object> shutdown() {
        Deferred<Object> d = this.zkclient.getDeferredRootIfBeingLookedUp();
        if (d != null) {
            LOG.debug("Shutdown needs to wait on -ROOT- to come back");
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class RetryShutdown
            implements Callback<Object, Object> {
                RetryShutdown() {
                }

                public Object call(Object arg) {
                    LOG.debug("Shutdown retrying after -ROOT- came back");
                    return HBaseClient.this.shutdown();
                }

                public String toString() {
                    return "retry shutdown";
                }
            }
            return d.addBoth((Callback)new RetryShutdown());
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DisconnectCB
        implements Callback<Object, Object> {
            DisconnectCB() {
            }

            public Object call(Object arg) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class ReleaseResourcesCB
                implements Callback<Object, Object> {
                    ReleaseResourcesCB() {
                    }

                    public Object call(Object arg) {
                        LOG.debug("Releasing all remaining resources");
                        HBaseClient.this.timer.stop();
                        final class ShutdownThread
                        extends Thread {
                            ShutdownThread() {
                                super("HBaseClient@" + HBaseClient.super.hashCode() + " shutdown");
                            }

                            public void run() {
                                HBaseClient.this.channel_factory.releaseExternalResources();
                            }
                        }
                        new ShutdownThread().start();
                        return arg;
                    }

                    public String toString() {
                        return "release resources callback";
                    }
                }
                return HBaseClient.this.disconnectEverything().addCallback((Callback)new ReleaseResourcesCB());
            }

            public String toString() {
                return "disconnect callback";
            }
        }
        return this.flush().addCallback((Callback)new DisconnectCB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<Object> disconnectEverything() {
        HashMap<String, RegionClient> ip2client_copy;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            ip2client_copy = new HashMap<String, RegionClient>(this.ip2client);
        }
        ArrayList<Deferred<Object>> d = new ArrayList<Deferred<Object>>(ip2client_copy.values().size() + 1);
        for (RegionClient client : ip2client_copy.values()) {
            d.add(client.shutdown());
        }
        if (this.rootregion != null && this.rootregion.isAlive()) {
            d.add(this.rootregion.shutdown());
        }
        ip2client_copy = null;
        final int size = d.size();
        return Deferred.group(d).addCallback((Callback)new Callback<Object, ArrayList<Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(ArrayList<Object> arg) {
                HashMap logme = null;
                HashMap hashMap = HBaseClient.this.ip2client;
                synchronized (hashMap) {
                    if (!HBaseClient.this.ip2client.isEmpty()) {
                        logme = new HashMap(HBaseClient.this.ip2client);
                    }
                }
                if (logme != null) {
                    LOG.error("Some clients are left in the client cache and haven't been cleaned up: " + logme);
                    logme = null;
                    return HBaseClient.this.disconnectEverything();
                }
                HBaseClient.this.zkclient.disconnectZK();
                return arg;
            }

            public String toString() {
                return "wait " + size + " RegionClient.shutdown()";
            }
        });
    }

    public Deferred<Object> ensureTableFamilyExists(String table, String family) {
        return this.ensureTableFamilyExists(table.getBytes(), family.getBytes());
    }

    public Deferred<Object> ensureTableFamilyExists(byte[] table, byte[] family) {
        HBaseRpc dummy = family == EMPTY_ARRAY ? GetRequest.exists(table, EMPTY_ARRAY) : GetRequest.exists(table, EMPTY_ARRAY, family);
        Deferred<Object> d = this.sendRpcToRegion(dummy);
        return d;
    }

    public Deferred<Object> ensureTableExists(String table) {
        return this.ensureTableFamilyExists(table.getBytes(), EMPTY_ARRAY);
    }

    public Deferred<Object> ensureTableExists(byte[] table) {
        return this.ensureTableFamilyExists(table, EMPTY_ARRAY);
    }

    public Deferred<ArrayList<KeyValue>> get(GetRequest request) {
        this.num_gets.increment();
        return this.sendRpcToRegion(request).addCallbacks(got, Callback.PASSTHROUGH);
    }

    public Scanner newScanner(byte[] table) {
        return new Scanner(this, table);
    }

    public Scanner newScanner(String table) {
        return new Scanner(this, table.getBytes());
    }

    Deferred<Long> openScanner(final Scanner scanner) {
        this.num_scanners_opened.increment();
        return this.sendRpcToRegion(scanner.getOpenRequest()).addCallbacks(scanner_opened, (Callback)new Callback<Object, Object>(){

            public Object call(Object error) {
                scanner.invalidate();
                return error;
            }

            public String toString() {
                return "openScanner errback";
            }
        });
    }

    Deferred<Object> scanNextRows(Scanner scanner) {
        RegionClient client;
        RegionInfo region = scanner.currentRegion();
        RegionClient regionClient = client = region == null ? null : this.region2client.get(region);
        if (client == null) {
            scanner.invalidate();
            Deferred<ArrayList<ArrayList<KeyValue>>> d = scanner.nextRows();
            return d;
        }
        this.num_scans.increment();
        HBaseRpc next_request = scanner.getNextRowsRequest();
        Deferred<Object> d = next_request.getDeferred();
        client.sendRpc(next_request);
        return d;
    }

    Deferred<Object> closeScanner(Scanner scanner) {
        RegionClient client;
        RegionInfo region = scanner.currentRegion();
        RegionClient regionClient = client = region == null ? null : this.region2client.get(region);
        if (client == null) {
            LOG.warn("Cannot close " + scanner + " properly, no connection open for " + Bytes.pretty(region == null ? null : region.name()));
            return Deferred.fromResult(null);
        }
        HBaseRpc close_request = scanner.getCloseRequest();
        Deferred<Object> d = close_request.getDeferred();
        client.sendRpc(close_request);
        return d;
    }

    public Deferred<Long> atomicIncrement(AtomicIncrementRequest request) {
        this.num_atomic_increments.increment();
        return this.sendRpcToRegion(request).addCallbacks(icv_done, Callback.PASSTHROUGH);
    }

    public Deferred<Long> bufferAtomicIncrement(AtomicIncrementRequest request) {
        long value = request.getAmount();
        if (!BufferedIncrement.Amount.checkOverflow(value) || this.flush_interval == 0) {
            return this.atomicIncrement(request);
        }
        BufferedIncrement incr = new BufferedIncrement(request.table(), request.key(), request.family(), request.qualifier());
        while (true) {
            BufferedIncrement.Amount amount;
            try {
                amount = (BufferedIncrement.Amount)this.increment_buffer.getUnchecked((Object)incr);
            }
            catch (NullPointerException e) {
                this.setupIncrementCoalescing();
                amount = (BufferedIncrement.Amount)this.increment_buffer.getUnchecked((Object)incr);
            }
            if (amount.update(value)) {
                Deferred deferred = new Deferred();
                amount.deferred.chain(deferred);
                return deferred;
            }
            this.increment_buffer.refresh((Object)incr);
        }
    }

    private synchronized void setupIncrementCoalescing() {
        if (this.increment_buffer != null) {
            return;
        }
        this.makeIncrementBuffer();
        short interval = this.flush_interval;
        final class FlushBufferedIncrementsTimer
        implements TimerTask {
            FlushBufferedIncrementsTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout timeout) {
                try {
                    HBaseClient.flushBufferedIncrements((LoadingCache<BufferedIncrement, BufferedIncrement.Amount>)HBaseClient.this.increment_buffer);
                }
                catch (Throwable throwable) {
                    short interval = HBaseClient.this.flush_interval;
                    HBaseClient.this.newTimeout(this, interval > 0 ? (long)interval : 100L);
                    throw throwable;
                }
                short interval = HBaseClient.this.flush_interval;
                HBaseClient.this.newTimeout(this, interval > 0 ? (long)interval : 100L);
            }
        }
        this.timer.newTimeout((TimerTask)new FlushBufferedIncrementsTimer(), interval > 0 ? (long)interval : 1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushBufferedIncrements(LoadingCache<BufferedIncrement, BufferedIncrement.Amount> increment_buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing " + increment_buffer.size() + " buffered increments");
        }
        LoadingCache<BufferedIncrement, BufferedIncrement.Amount> loadingCache = increment_buffer;
        synchronized (loadingCache) {
            increment_buffer.invalidateAll();
        }
    }

    private void makeIncrementBuffer() {
        int size = this.increment_buffer_size;
        this.increment_buffer = BufferedIncrement.newCache(this, size);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created increment buffer of " + size + " entries");
        }
    }

    public Deferred<Long> atomicIncrement(AtomicIncrementRequest request, boolean durable) {
        request.setDurable(durable);
        return this.atomicIncrement(request);
    }

    public Deferred<Object> put(PutRequest request) {
        this.num_puts.increment();
        return this.sendRpcToRegion(request);
    }

    public Deferred<Boolean> compareAndSet(PutRequest edit, byte[] expected) {
        return this.sendRpcToRegion(new CompareAndSetRequest(edit, expected)).addCallback((Callback)CAS_CB);
    }

    public Deferred<Boolean> compareAndSet(PutRequest edit, String expected) {
        return this.compareAndSet(edit, expected.getBytes());
    }

    public Deferred<Boolean> atomicCreate(PutRequest edit) {
        return this.compareAndSet(edit, EMPTY_ARRAY);
    }

    public Deferred<RowLock> lockRow(final RowLockRequest request) {
        this.num_row_locks.increment();
        return this.sendRpcToRegion(request).addCallbacks((Callback)new Callback<RowLock, Object>(){

            public RowLock call(Object response) {
                if (response instanceof Long) {
                    return new RowLock(request.getRegion().name(), (Long)response);
                }
                throw new InvalidResponseException(Long.class, response);
            }

            public String toString() {
                return "type lockRow response";
            }
        }, Callback.PASSTHROUGH);
    }

    public Deferred<Object> unlockRow(RowLock lock) {
        RegionClient client;
        byte[] region_name = lock.region();
        RegionInfo region = this.regions_cache.get(region_name);
        if (HBaseClient.knownToBeNSREd(region)) {
            return Deferred.fromResult(null);
        }
        RegionClient regionClient = client = region == null ? null : this.region2client.get(region);
        if (client == null) {
            LOG.warn("Cannot release " + lock + ", no connection open for " + Bytes.pretty(region_name));
            return Deferred.fromResult(null);
        }
        RowLockRequest.ReleaseRequest release = new RowLockRequest.ReleaseRequest(lock, region);
        release.setRegion(region);
        Deferred<Object> d = release.getDeferred();
        client.sendRpc(release);
        return d;
    }

    public Deferred<Object> delete(DeleteRequest request) {
        this.num_deletes.increment();
        return this.sendRpcToRegion(request);
    }

    Deferred<Object> sendRpcToRegion(final HBaseRpc request) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class RetryRpc
        implements Callback<Deferred<Object>, Object> {
            RetryRpc() {
            }

            public Deferred<Object> call(Object arg) {
                if (arg instanceof NonRecoverableException) {
                    return Deferred.fromError((Exception)((NonRecoverableException)arg));
                }
                return HBaseClient.this.sendRpcToRegion(request);
            }

            public String toString() {
                return "retry RPC";
            }
        }
        if (HBaseClient.cannotRetryRequest(request)) {
            return HBaseClient.tooManyAttempts(request, null);
        }
        request.attempt = (byte)(request.attempt + 1);
        byte[] table = request.table;
        byte[] key = request.key;
        RegionInfo region = this.getRegion(table, key);
        if (region != null) {
            RegionClient client;
            if (HBaseClient.knownToBeNSREd(region)) {
                NotServingRegionException nsre = new NotServingRegionException("Region known to be unavailable", request);
                Deferred d = request.getDeferred().addBothDeferring((Callback)new RetryRpc());
                this.handleNSRE(request, region.name(), nsre);
                return d;
            }
            RegionClient regionClient = client = Bytes.equals(region.table(), ROOT) ? this.rootregion : this.region2client.get(region);
            if (client != null && client.isAlive()) {
                request.setRegion(region);
                Deferred<Object> d = request.getDeferred();
                client.sendRpc(request);
                return d;
            }
        }
        return this.locateRegion(table, key).addBothDeferring((Callback)new RetryRpc());
    }

    @Deprecated
    public long rootLookupCount() {
        return this.root_lookups.get();
    }

    @Deprecated
    public long uncontendedMetaLookupCount() {
        return this.meta_lookups_with_permit.get();
    }

    @Deprecated
    public long contendedMetaLookupCount() {
        return this.meta_lookups_wo_permit.get();
    }

    static boolean cannotRetryRequest(HBaseRpc rpc) {
        return rpc.attempt > 10;
    }

    static Deferred<Object> tooManyAttempts(HBaseRpc request, HBaseException cause) {
        NonRecoverableException e = new NonRecoverableException("Too many attempts: " + request, cause);
        request.callback(e);
        return Deferred.fromError((Exception)e);
    }

    private Deferred<Object> locateRegion(byte[] table, byte[] key) {
        RegionClient client;
        RegionInfo meta_region;
        boolean is_meta = Bytes.equals(table, META);
        boolean is_root = !is_meta && Bytes.equals(table, ROOT);
        byte[] meta_key = is_root ? null : HBaseClient.createRegionSearchKey(table, key);
        RegionInfo regionInfo = meta_region = is_meta || is_root ? null : this.getRegion(META, meta_key);
        if (meta_region != null && (client = this.region2client.get(meta_region)) != null && client.isAlive()) {
            boolean has_permit = client.acquireMetaLookupPermit();
            if (!has_permit && this.getRegion(table, key) != null) {
                return Deferred.fromResult(null);
            }
            Deferred d = client.getClosestRowBefore(meta_region, META, meta_key, INFO).addCallback((Callback)this.meta_lookup_done);
            if (has_permit) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class ReleaseMetaLookupPermit
                implements Callback<Object, Object> {
                    ReleaseMetaLookupPermit() {
                    }

                    public Object call(Object arg) {
                        client.releaseMetaLookupPermit();
                        return arg;
                    }

                    public String toString() {
                        return "release .META. lookup permit";
                    }
                }
                d.addBoth((Callback)new ReleaseMetaLookupPermit());
                this.meta_lookups_with_permit.increment();
            } else {
                this.meta_lookups_wo_permit.increment();
            }
            return d.addErrback(this.newLocateRegionErrback(table, key));
        }
        RegionClient rootregion = this.rootregion;
        if (rootregion == null || !rootregion.isAlive()) {
            return this.zkclient.getDeferredRoot();
        }
        if (is_root) {
            return Deferred.fromResult(null);
        }
        byte[] root_key = HBaseClient.createRegionSearchKey(META, meta_key);
        RegionInfo root_region = new RegionInfo(ROOT, ROOT_REGION, EMPTY_ARRAY);
        this.root_lookups.increment();
        return rootregion.getClosestRowBefore(root_region, ROOT, root_key, INFO).addCallback((Callback)this.root_lookup_done).addErrback(this.newLocateRegionErrback(table, key));
    }

    private Callback<Object, Exception> newLocateRegionErrback(final byte[] table, final byte[] key) {
        return new Callback<Object, Exception>(){

            public Object call(Exception e) {
                if (e instanceof TableNotFoundException) {
                    return new TableNotFoundException(table);
                }
                if (e instanceof RecoverableException) {
                    return HBaseClient.this.locateRegion(table, key);
                }
                return e;
            }

            public String toString() {
                return "locateRegion errback";
            }
        };
    }

    private static byte[] createRegionSearchKey(byte[] table, byte[] key) {
        byte[] meta_key = new byte[table.length + key.length + 3];
        System.arraycopy(table, 0, meta_key, 0, table.length);
        meta_key[table.length] = 44;
        System.arraycopy(key, 0, meta_key, table.length + 1, key.length);
        meta_key[meta_key.length - 2] = 44;
        meta_key[meta_key.length - 1] = 58;
        return meta_key;
    }

    private RegionInfo getRegion(byte[] table, byte[] key) {
        if (Bytes.equals(table, ROOT)) {
            return new RegionInfo(ROOT, ROOT_REGION, EMPTY_ARRAY);
        }
        byte[] region_name = HBaseClient.createRegionSearchKey(table, key);
        Map.Entry<byte[], RegionInfo> entry = this.regions_cache.floorEntry(region_name);
        if (entry == null) {
            return null;
        }
        if (!HBaseClient.isCacheKeyForTable(table, entry.getKey())) {
            return null;
        }
        region_name = null;
        RegionInfo region = entry.getValue();
        entry = null;
        byte[] stop_key = region.stopKey();
        if (stop_key != EMPTY_ARRAY && Bytes.memcmp(key, stop_key) >= 0) {
            return null;
        }
        return region;
    }

    private static boolean isCacheKeyForTable(byte[] table, byte[] cache_key) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == cache_key[i]) continue;
            return false;
        }
        return cache_key[table.length] == 44;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionClient discoverRegion(ArrayList<KeyValue> meta_row) {
        int nregions;
        RegionInfo oldregion;
        RegionClient oldclient;
        if (meta_row.isEmpty()) {
            throw new TableNotFoundException();
        }
        String host = null;
        int port = -42;
        RegionInfo region = null;
        byte[] start_key = null;
        for (KeyValue kv : meta_row) {
            int colon;
            byte[] qualifier = kv.qualifier();
            if (Arrays.equals(REGIONINFO, qualifier)) {
                byte[][] tmp = new byte[1][];
                region = RegionInfo.fromKeyValue(kv, tmp);
                if (HBaseClient.knownToBeNSREd(region)) {
                    this.invalidateRegionCache(region.name(), true, "has marked it as split.");
                    return null;
                }
                start_key = tmp[0];
                continue;
            }
            if (!Arrays.equals(SERVER, qualifier) || kv.value() == EMPTY_ARRAY) continue;
            byte[] hostport = kv.value();
            for (colon = hostport.length - 1; colon > 0 && hostport[colon] != 58; --colon) {
            }
            if (colon == 0) {
                throw BrokenMetaException.badKV(region, "an `info:server' cell doesn't contain `:' to separate the `host:port'" + Bytes.pretty(hostport), kv);
            }
            host = HBaseClient.getIP(new String(hostport, 0, colon));
            try {
                port = HBaseClient.parsePortNumber(new String(hostport, colon + 1, hostport.length - colon - 1));
            }
            catch (NumberFormatException e) {
                throw BrokenMetaException.badKV(region, "an `info:server' cell contains an invalid port: " + e.getMessage() + " in " + Bytes.pretty(hostport), kv);
            }
        }
        if (start_key == null) {
            throw new BrokenMetaException(null, "It didn't contain any `info:regioninfo' cell:  " + meta_row);
        }
        byte[] region_name = region.name();
        if (host == null) {
            this.invalidateRegionCache(region_name, true, "no longer has it assigned.");
            return null;
        }
        RegionClient client = this.newClient(host, port);
        if (client == (oldclient = this.region2client.put(region, client))) {
            return client;
        }
        RegionClient regionClient = client;
        synchronized (regionClient) {
            ArrayList<RegionInfo> regions;
            oldregion = this.regions_cache.put(region_name, region);
            ArrayList<RegionInfo> arrayList = regions = this.client2regions.get((Object)client);
            synchronized (arrayList) {
                regions.add(region);
                nregions = regions.size();
            }
        }
        LOG.info((oldclient == null ? "Added" : "Replaced") + " client for" + " region " + region + ", which was " + (oldregion == null ? "added to" : "updated in") + " the" + " regions cache.  Now we know that " + (Object)((Object)client) + " is hosting " + nregions + " region" + (nregions > 1 ? Character.valueOf('s') : "") + '.');
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateRegionCache(byte[] region_name, boolean mark_as_nsred, String reason) {
        if (region_name == ROOT_REGION) {
            if (reason != null) {
                LOG.info("Invalidated cache for -ROOT- as " + (Object)((Object)this.rootregion) + ' ' + reason);
            }
            this.rootregion = null;
            return;
        }
        RegionInfo oldregion = mark_as_nsred ? this.regions_cache.put(region_name, new RegionInfo(EMPTY_ARRAY, region_name, EMPTY_ARRAY)) : this.regions_cache.remove(region_name);
        RegionInfo region = oldregion != null ? oldregion : new RegionInfo(EMPTY_ARRAY, region_name, EMPTY_ARRAY);
        RegionClient client = this.region2client.remove(region);
        if (oldregion != null && !Bytes.equals(oldregion.name(), region_name)) {
            LOG.warn("Oops, invalidated the wrong regions cache entry.  Meant to remove " + Bytes.pretty(region_name) + " but instead removed " + oldregion);
        }
        if (client == null) {
            return;
        }
        ArrayList<RegionInfo> regions = this.client2regions.get((Object)client);
        if (regions != null) {
            ArrayList<RegionInfo> arrayList = regions;
            synchronized (arrayList) {
                regions.remove(region);
            }
        }
        if (reason != null) {
            LOG.info("Invalidated cache for " + region + " as " + (Object)((Object)client) + ' ' + reason);
        }
    }

    private static boolean knownToBeNSREd(RegionInfo region) {
        return region.table() == EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNSRE(HBaseRpc rpc, final byte[] region_name, NotServingRegionException e) {
        this.num_nsre_rpcs.increment();
        boolean can_retry_rpc = !HBaseClient.cannotRetryRequest(rpc);
        boolean known_nsre = true;
        ArrayList<HBaseRpc> nsred_rpcs = this.got_nsre.get(region_name);
        HBaseRpc exists_rpc = null;
        if (nsred_rpcs == null) {
            ArrayList<HBaseRpc> newlist = new ArrayList<HBaseRpc>(64);
            exists_rpc = GetRequest.exists(rpc.table, rpc.key);
            newlist.add(exists_rpc);
            if (can_retry_rpc) {
                newlist.add(rpc);
            }
            if ((nsred_rpcs = this.got_nsre.putIfAbsent(region_name, newlist)) == null) {
                nsred_rpcs = newlist;
                known_nsre = false;
            }
        }
        if (known_nsre) {
            int size;
            boolean reject = true;
            ArrayList<HBaseRpc> arrayList = nsred_rpcs;
            synchronized (arrayList) {
                size = nsred_rpcs.size();
                if (size == 0) {
                    ArrayList<HBaseRpc> added = this.got_nsre.putIfAbsent(region_name, nsred_rpcs);
                    if (added == null) {
                        exists_rpc = GetRequest.exists(rpc.table, rpc.key);
                        nsred_rpcs.add(exists_rpc);
                        if (can_retry_rpc) {
                            nsred_rpcs.add(rpc);
                        }
                        known_nsre = false;
                    } else {
                        if (can_retry_rpc) {
                            ArrayList<HBaseRpc> arrayList2 = added;
                            synchronized (arrayList2) {
                                if (added.isEmpty()) {
                                    LOG.error("WTF?  Shouldn't happen!  Lost 2 races and found an empty list of NSRE'd RPCs (" + added + ") for " + Bytes.pretty(region_name));
                                    exists_rpc = GetRequest.exists(rpc.table, rpc.key);
                                    added.add(exists_rpc);
                                } else {
                                    exists_rpc = added.get(0);
                                }
                                if (can_retry_rpc) {
                                    added.add(rpc);
                                }
                            }
                        }
                        nsred_rpcs = added;
                    }
                } else {
                    exists_rpc = nsred_rpcs.get(0);
                    if (exists_rpc != rpc) {
                        if (size < 10000) {
                            if (size == 1000) {
                                nsred_rpcs.add(null);
                            } else if (can_retry_rpc) {
                                reject = false;
                                if (nsred_rpcs.contains(rpc)) {
                                    LOG.error("WTF?  Trying to add " + rpc + " twice to NSREd RPC" + " on " + Bytes.pretty(region_name));
                                } else {
                                    nsred_rpcs.add(rpc);
                                }
                            }
                        }
                    } else {
                        reject = false;
                    }
                }
            }
            if (known_nsre && exists_rpc != rpc) {
                if (size != 10000 && size % 500 == 0) {
                    String msg = "There are now " + size + " RPCs pending due to NSRE on " + Bytes.pretty(region_name);
                    if (size + 500 < 10000) {
                        LOG.info(msg);
                    } else {
                        LOG.warn(msg);
                    }
                }
                if (reject) {
                    rpc.callback(new PleaseThrottleException(size + " RPCs waiting on " + Bytes.pretty(region_name) + " to come back online", e, rpc, exists_rpc.getDeferred()));
                }
                return;
            }
        }
        this.num_nsres.increment();
        this.invalidateRegionCache(region_name, true, (known_nsre ? "still " : "") + "seems to be splitting or closing it.");
        final ArrayList<HBaseRpc> rpcs = nsred_rpcs;
        final HBaseRpc probe = exists_rpc;
        nsred_rpcs = null;
        exists_rpc = null;
        if (known_nsre && probe.attempt > 1) {
            probe.attempt = (byte)(probe.attempt - 1);
        } else if (!can_retry_rpc) {
            rpc.callback(HBaseClient.tooManyAttempts(rpc, e));
        }
        rpc = null;
        int wait_ms = probe.attempt < 4 ? 200 * (probe.attempt + 2) : 1000 + (1 << probe.attempt);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class NSRETimer
        implements TimerTask {
            NSRETimer() {
            }

            public void run(Timeout timeout) {
                if (probe.attempt == 0) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    final class RetryNSREd
                    implements Callback<Object, Object> {
                        final /* synthetic */ HBaseRpc val$probe;
                        final /* synthetic */ byte[] val$region_name;
                        final /* synthetic */ ArrayList val$rpcs;

                        RetryNSREd() {
                            this.val$probe = hBaseRpc;
                            this.val$region_name = byArray;
                            this.val$rpcs = arrayList;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object call(Object arg) {
                            ArrayList arrayList;
                            ArrayList removed;
                            if (arg instanceof Exception) {
                                LOG.warn("Probe " + this.val$probe + " failed", (Throwable)((Exception)arg));
                            }
                            if ((removed = (ArrayList)HBaseClient.this.got_nsre.remove(this.val$region_name)) != this.val$rpcs && removed != null) {
                                arrayList = removed;
                                synchronized (arrayList) {
                                    ArrayList arrayList2 = this.val$rpcs;
                                    synchronized (arrayList2) {
                                        LOG.error("WTF?  Impossible!  Removed the wrong list of RPCs from got_nsre.  Was expecting list@" + System.identityHashCode(this.val$rpcs) + " (size=" + this.val$rpcs.size() + "), got list@" + System.identityHashCode(removed) + " (size=" + removed.size() + ')');
                                    }
                                    for (HBaseRpc r : removed) {
                                        if (r == null || r == this.val$probe) continue;
                                        HBaseClient.this.sendRpcToRegion(r);
                                    }
                                    removed.clear();
                                }
                            }
                            removed = null;
                            arrayList = this.val$rpcs;
                            synchronized (arrayList) {
                                Iterator i;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Retrying " + this.val$rpcs.size() + " RPCs now that the NSRE on " + Bytes.pretty(this.val$region_name) + " seems to have cleared");
                                }
                                if ((i = this.val$rpcs.iterator()).hasNext()) {
                                    HBaseRpc r;
                                    r = (HBaseRpc)i.next();
                                    if (r != this.val$probe) {
                                        LOG.error("WTF?  Impossible!  Expected first == probe but first=" + r + " and probe=" + this.val$probe);
                                        HBaseClient.this.sendRpcToRegion(r);
                                    }
                                    while (i.hasNext()) {
                                        r = (HBaseRpc)i.next();
                                        if (r == null) continue;
                                        HBaseClient.this.sendRpcToRegion(r);
                                    }
                                } else {
                                    LOG.error("WTF?  Impossible!  Empty rpcs array=" + this.val$rpcs + " found by " + this);
                                }
                                this.val$rpcs.clear();
                            }
                            return arg;
                        }

                        public String toString() {
                            return "retry other RPCs NSRE'd on " + Bytes.pretty(this.val$region_name);
                        }
                    }
                    probe.getDeferred().addBoth((Callback)new RetryNSREd(HBaseClient.this, probe, region_name, rpcs));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Done waiting after NSRE on " + Bytes.pretty(region_name) + ", retrying " + probe);
                }
                HBaseClient.this.invalidateRegionCache(region_name, false, null);
                HBaseClient.this.sendRpcToRegion(probe);
            }

            public String toString() {
                return "probe NSRE " + probe;
            }
        }
        this.newTimeout(new NSRETimer(), wait_ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionClient newClient(String host, int port) {
        RegionClient client;
        String hostport = host + ':' + port;
        SocketChannel chan = null;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            client = this.ip2client.get(hostport);
            if (client != null && client.isAlive()) {
                return client;
            }
            RegionClientPipeline pipeline = new RegionClientPipeline();
            client = pipeline.init();
            chan = this.channel_factory.newChannel((ChannelPipeline)pipeline);
            this.ip2client.put(hostport, client);
        }
        this.client2regions.put(client, new ArrayList());
        this.num_connections_created.increment();
        SocketChannelConfig config = chan.getConfig();
        config.setConnectTimeoutMillis(5000);
        config.setTcpNoDelay(true);
        config.setKeepAlive(true);
        chan.connect((SocketAddress)new InetSocketAddress(host, port));
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress slowSearchClientIP(RegionClient client) {
        int port;
        String hostport = null;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            for (Map.Entry<String, RegionClient> e : this.ip2client.entrySet()) {
                if (e.getValue() != client) continue;
                hostport = e.getKey();
                break;
            }
        }
        if (hostport == null) {
            HashMap<String, RegionClient> copy;
            HashMap<String, RegionClient> i$ = this.ip2client;
            synchronized (i$) {
                copy = new HashMap<String, RegionClient>(this.ip2client);
            }
            LOG.error("WTF?  Should never happen!  Couldn't find " + (Object)((Object)client) + " in " + copy);
            return null;
        }
        LOG.warn("Couldn't connect to the RegionServer @ " + hostport);
        int colon = hostport.indexOf(58, 1);
        if (colon < 1) {
            LOG.error("WTF?  Should never happen!  No `:' found in " + hostport);
            return null;
        }
        String host = HBaseClient.getIP(hostport.substring(0, colon));
        try {
            port = HBaseClient.parsePortNumber(hostport.substring(colon + 1, hostport.length()));
        }
        catch (NumberFormatException e) {
            LOG.error("WTF?  Should never happen!  Bad port in " + hostport, (Throwable)e);
            return null;
        }
        return new InetSocketAddress(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientFromCache(RegionClient client, SocketAddress remote) {
        RegionClient old;
        InetAddress addr;
        InetSocketAddress sock;
        ArrayList<RegionInfo> regions;
        if (client == this.rootregion) {
            LOG.info("Lost connection with the -ROOT- region");
            this.rootregion = null;
        }
        if ((regions = this.client2regions.remove((Object)client)) != null) {
            RegionInfo[] regions_copy;
            ArrayList<RegionInfo> arrayList = regions;
            synchronized (arrayList) {
                regions_copy = regions.toArray(new RegionInfo[regions.size()]);
                regions = null;
            }
            for (RegionInfo region : regions_copy) {
                RegionClient oldclient;
                byte[] table = region.table();
                byte[] stop_key = region.stopKey();
                byte[] search_key = HBaseClient.createRegionSearchKey(stop_key.length == 0 ? Arrays.copyOf(table, table.length + 1) : table, stop_key);
                Map.Entry<byte[], RegionInfo> entry = this.regions_cache.lowerEntry(search_key);
                if (entry != null && entry.getValue() == region) {
                    this.regions_cache.remove(entry.getKey());
                    LOG.debug("Removed from regions cache: {}", (Object)region);
                }
                if (client == (oldclient = this.region2client.remove(region))) {
                    LOG.debug("Association removed: {} -> {}", (Object)region, (Object)client);
                    continue;
                }
                if (oldclient == null) continue;
                LOG.warn("When handling disconnection of " + (Object)((Object)client) + " and removing " + region + " from region2client" + ", it was found that " + (Object)((Object)oldclient) + " was in fact" + " serving this region");
            }
        }
        if (remote == null) {
            return;
        }
        String hostport = null;
        if (remote instanceof InetSocketAddress) {
            sock = (InetSocketAddress)remote;
            addr = sock.getAddress();
            if (addr == null) {
                LOG.error("WTF?  Unresolved IP for " + remote + ".  This shouldn't happen.");
                return;
            }
        } else {
            LOG.error("WTF?  Found a non-InetSocketAddress remote: " + remote + ".  This shouldn't happen.");
            return;
        }
        hostport = addr.getHostAddress() + ':' + sock.getPort();
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            old = this.ip2client.remove(hostport);
        }
        LOG.debug("Removed from IP cache: {} -> {}", (Object)hostport, (Object)client);
        if (old == null) {
            LOG.warn("When expiring " + (Object)((Object)client) + " from the client cache (host:port=" + hostport + "), it was found that there was no entry" + " corresponding to " + remote + ".  This shouldn't happen.");
        }
    }

    private static String getIP(String host) {
        long start = System.nanoTime();
        try {
            String ip = InetAddress.getByName(host).getHostAddress();
            long latency = System.nanoTime() - start;
            if (latency > 500000L && LOG.isDebugEnabled()) {
                LOG.debug("Resolved IP of `" + host + "' to " + ip + " in " + latency + "ns");
            } else if (latency >= 3000000L) {
                LOG.warn("Slow DNS lookup!  Resolved IP of `" + host + "' to " + ip + " in " + latency + "ns");
            }
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve the IP of `" + host + "' in " + (System.nanoTime() - start) + "ns");
            return null;
        }
    }

    private static int parsePortNumber(String portnum) throws NumberFormatException {
        int port = Integer.parseInt(portnum);
        if (port <= 0 || port > 65535) {
            throw new NumberFormatException(port == 0 ? "port is zero" : (port < 0 ? "port is negative: " : "port is too large: ") + port);
        }
        return port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ZKClient
    implements Watcher {
        private static final byte MAGIC = -1;
        private final String quorum_spec;
        private final String base_path;
        private ZooKeeper zk;
        private ArrayList<Deferred<Object>> deferred_rootregion;

        public ZKClient(String quorum_spec, String base_path) {
            this.quorum_spec = quorum_spec;
            this.base_path = base_path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Deferred<Object> getDeferredRoot() {
            Deferred d = new Deferred();
            ZKClient zKClient = this;
            synchronized (zKClient) {
                try {
                    this.connectZK();
                    if (this.deferred_rootregion == null) {
                        LOG.info("Need to find the -ROOT- region");
                        this.deferred_rootregion = new ArrayList();
                    }
                    this.deferred_rootregion.add((Deferred<Object>)d);
                }
                catch (NonRecoverableException e) {
                    LOG.error(e.getMessage(), e.getCause());
                    d.callback((Object)e);
                }
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Deferred<Object> getDeferredRootIfBeingLookedUp() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.deferred_rootregion == null) {
                    return null;
                }
                Deferred d = new Deferred();
                this.deferred_rootregion.add((Deferred<Object>)d);
                return d;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<Deferred<Object>> atomicGetAndRemoveWaiters() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                ArrayList<Deferred<Object>> arrayList;
                try {
                    arrayList = this.deferred_rootregion;
                    this.deferred_rootregion = null;
                }
                catch (Throwable throwable) {
                    this.deferred_rootregion = null;
                    throw throwable;
                }
                return arrayList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            LOG.debug("Got ZooKeeper event: {}", (Object)event);
            try {
                switch (event.getState()) {
                    case SyncConnected: {
                        this.getRootRegion();
                        break;
                    }
                    default: {
                        this.disconnectZK();
                        ZKClient zKClient = this;
                        synchronized (zKClient) {
                            if (this.deferred_rootregion != null) {
                                LOG.warn("No longer connected to ZooKeeper, event=" + event);
                                this.connectZK();
                            }
                        }
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Uncaught exception when handling event " + event, (Throwable)e);
                return;
            }
            LOG.debug("Done handling ZooKeeper event: {}", (Object)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectZK() {
            try {
                ZKClient zKClient = this;
                synchronized (zKClient) {
                    if (this.zk != null) {
                        return;
                    }
                    this.zk = new ZooKeeper(this.quorum_spec, 5000, (Watcher)this);
                }
            }
            catch (UnknownHostException e) {
                throw new NonRecoverableException("Cannot connect to ZooKeeper, is the quorum specification valid? " + this.quorum_spec, e);
            }
            catch (IOException e) {
                LOG.error("Failed to connect to ZooKeeper", (Throwable)e);
                this.connectZK();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnectZK() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.zk == null) {
                    return;
                }
                try {
                    LOG.debug("Ignore any DEBUG exception from ZooKeeper");
                    long start = System.nanoTime();
                    this.zk.close();
                    LOG.debug("ZooKeeper#close completed in {}ns", (Object)(System.nanoTime() - start));
                }
                catch (InterruptedException e) {
                    LOG.error("Should never happen", (Throwable)e);
                }
                this.zk = null;
            }
        }

        private void retryGetRootRegionLater(final AsyncCallback.DataCallback cb) {
            HBaseClient.this.newTimeout(new TimerTask(){

                public void run(Timeout timeout) {
                    if (ZKClient.this.zk != null) {
                        LOG.debug("Retrying to find the -ROOT- region in ZooKeeper");
                        ZKClient.this.zk.getData(ZKClient.this.base_path + "/root-region-server", (Watcher)ZKClient.this, cb, null);
                    } else {
                        ZKClient.this.connectZK();
                    }
                }
            }, 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getRootRegion() {
            AsyncCallback.DataCallback cb = new AsyncCallback.DataCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    short portend;
                    String host;
                    int offset;
                    boolean newstyle;
                    if (rc == KeeperException.Code.NONODE.intValue()) {
                        LOG.error("The znode for the -ROOT- region doesn't exist!");
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    if (rc != KeeperException.Code.OK.intValue()) {
                        LOG.error("Looks like our ZK session expired or is broken, rc=" + rc + ": " + KeeperException.Code.get((int)rc));
                        ZKClient.this.disconnectZK();
                        ZKClient.this.connectZK();
                        return;
                    }
                    if (data == null || data.length == 0 || data.length > Short.MAX_VALUE) {
                        LOG.error("The location of the -ROOT- region in ZooKeeper is " + (data == null || data.length == 0 ? "empty" : "too large (" + data.length + " bytes!)"));
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    int firstsep = -1;
                    if (data[0] == -1) {
                        newstyle = true;
                        int metadata_length = Bytes.getInt(data, 1);
                        if (metadata_length < 1 || metadata_length > 65000) {
                            LOG.error("Malformed meta-data in " + Bytes.pretty(data) + ", invalid metadata length=" + metadata_length);
                            ZKClient.this.retryGetRootRegionLater(this);
                            return;
                        }
                        offset = (short)(5 + metadata_length);
                    } else {
                        newstyle = false;
                        offset = 0;
                    }
                    short n = (short)data.length;
                    block7: for (short i = (short)(offset + 1); i < n; i = (short)(i + 1)) {
                        switch (data[i]) {
                            case 44: {
                                newstyle = true;
                            }
                            case 58: {
                                firstsep = i;
                                break block7;
                            }
                            default: {
                                continue block7;
                            }
                        }
                    }
                    if (firstsep == -1) {
                        LOG.error("-ROOT- location doesn't contain a separator (':' or ','): " + Bytes.pretty(data));
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    if (newstyle) {
                        short i;
                        host = new String(data, offset, firstsep - offset);
                        for (i = (short)(firstsep + 2); i < n && data[i] != 44; i = (short)(i + 1)) {
                        }
                        portend = i;
                    } else {
                        host = new String(data, 0, firstsep);
                        portend = n;
                    }
                    int port = HBaseClient.parsePortNumber(new String(data, firstsep + 1, portend - firstsep - 1));
                    String ip = HBaseClient.getIP(host);
                    if (ip == null) {
                        LOG.error("Couldn't resolve the IP of the -ROOT- region from " + host + " in \"" + Bytes.pretty(data) + '\"');
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    LOG.info("Connecting to -ROOT- region @ " + ip + ':' + port);
                    RegionClient client = HBaseClient.this.rootregion = HBaseClient.this.newClient(ip, port);
                    ArrayList ds = ZKClient.this.atomicGetAndRemoveWaiters();
                    if (ds != null) {
                        for (Deferred d : ds) {
                            d.callback((Object)client);
                        }
                    }
                    ZKClient.this.disconnectZK();
                    ZKClient zKClient = ZKClient.this;
                    synchronized (zKClient) {
                        if (ZKClient.this.deferred_rootregion != null) {
                            ZKClient.this.connectZK();
                        }
                    }
                }
            };
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.zk != null) {
                    LOG.debug("Finding the -ROOT- region in ZooKeeper");
                    this.zk.getData(this.base_path + "/root-region-server", (Watcher)this, cb, null);
                }
            }
        }
    }

    private final class RegionClientPipeline
    extends DefaultChannelPipeline {
        private boolean disconnected = false;

        RegionClientPipeline() {
        }

        RegionClient init() {
            RegionClient client = new RegionClient(HBaseClient.this);
            super.addLast("handler", (ChannelHandler)client);
            return client;
        }

        public void sendDownstream(ChannelEvent event) {
            if (event instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)event);
            }
            super.sendDownstream(event);
        }

        public void sendUpstream(ChannelEvent event) {
            if (event instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)event);
            }
            super.sendUpstream(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDisconnect(ChannelStateEvent state_event) {
            if (this.disconnected) {
                return;
            }
            switch (state_event.getState()) {
                case OPEN: {
                    if (state_event.getValue() == Boolean.FALSE) break;
                    return;
                }
                case CONNECTED: {
                    if (state_event.getValue() == null) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.disconnected = true;
            try {
                RegionClient client = (RegionClient)super.get(RegionClient.class);
                SocketAddress remote = super.getChannel().getRemoteAddress();
                if (remote == null) {
                    remote = HBaseClient.this.slowSearchClientIP(client);
                }
                RegionClient regionClient = client;
                synchronized (regionClient) {
                    HBaseClient.this.removeClientFromCache(client, remote);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(RegionClientPipeline.class).error("Uncaught exception when handling a disconnection of " + this.getChannel(), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RootCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private RootCB() {
        }

        public Object call(ArrayList<KeyValue> arg) {
            return HBaseClient.this.discoverRegion(arg);
        }

        public String toString() {
            return "locateRegion in ROOT";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MetaCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private MetaCB() {
        }

        public Object call(ArrayList<KeyValue> arg) {
            return HBaseClient.this.discoverRegion(arg);
        }

        public String toString() {
            return "locateRegion in META";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompareAndSetCB
    implements Callback<Boolean, Object> {
        private CompareAndSetCB() {
        }

        public Boolean call(Object response) {
            if (response instanceof Boolean) {
                return (Boolean)response;
            }
            throw new InvalidResponseException(Boolean.class, response);
        }

        public String toString() {
            return "type compareAndSet response";
        }
    }

    private static final class CustomChannelFactory
    extends NioClientSocketChannelFactory {
        CustomChannelFactory(Executor executor) {
            super(executor, executor);
        }

        public void releaseExternalResources() {
        }
    }
}

