/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.ConnectionResetException;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.MultiAction;
import org.hbase.async.NoSuchColumnFamilyException;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionInfo;
import org.hbase.async.RemoteException;
import org.hbase.async.UnknownRowLockException;
import org.hbase.async.UnknownScannerException;
import org.hbase.async.VersionMismatchException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegionClient
extends ReplayingDecoder<VoidEnum> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionClient.class);
    private static final HashMap<String, HBaseException> REMOTE_EXCEPTION_TYPES = new HashMap();
    private static final byte SERVER_VERSION_UNKNWON = 0;
    static final byte SERVER_VERSION_090_AND_BEFORE = 24;
    static final byte SERVER_VERSION_092_OR_ABOVE = 29;
    private final HBaseClient hbase_client;
    private volatile Channel chan;
    private boolean dead = false;
    private byte server_version = 0;
    private MultiAction batched_rpcs;
    private ArrayList<HBaseRpc> pending_rpcs;
    private final ConcurrentHashMap<Integer, HBaseRpc> rpcs_inflight = new ConcurrentHashMap();
    private final AtomicInteger rpcid = new AtomicInteger(-1);
    private final TimerTask flush_timer = new TimerTask(){

        public void run(Timeout timeout) {
            RegionClient.this.periodicFlush();
        }

        public String toString() {
            return "flush commits of " + (Object)((Object)RegionClient.this);
        }
    };
    private final Semaphore meta_lookups = new Semaphore(100);
    private static final byte[] GET_PROTOCOL_VERSION;
    private static final byte[] GET_CLOSEST_ROW_BEFORE;
    private static final Callback<ArrayList<KeyValue>, Object> got_closest_row_before;
    private static final byte[] HRPC3;

    public RegionClient(HBaseClient hbase_client) {
        this.hbase_client = hbase_client;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicFlush() {
        if (this.chan != null || this.dead) {
            MultiAction batched_rpcs;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Periodic flush timer: flushing RPCs for " + (Object)((Object)this));
            }
            RegionClient regionClient = this;
            synchronized (regionClient) {
                batched_rpcs = this.batched_rpcs;
                this.batched_rpcs = null;
            }
            if (batched_rpcs != null && batched_rpcs.size() != 0) {
                Deferred<Object> d = batched_rpcs.getDeferred();
                this.sendRpc(batched_rpcs);
            }
        }
    }

    private void scheduleNextPeriodicFlush() {
        short interval = this.hbase_client.getFlushInterval();
        if (interval > 0) {
            short adj = (short)(System.nanoTime() & 0xF0L);
            if (interval < 3 * adj) {
                adj = (short)(adj >>> 2);
            }
            if ((adj & 0x10) == 16) {
                adj = -adj;
            }
            this.hbase_client.newTimeout(this.flush_timer, interval + adj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Deferred<Object> flush() {
        ArrayList<Deferred<Object>> pending;
        MultiAction batched_rpcs;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            batched_rpcs = this.batched_rpcs;
            this.batched_rpcs = null;
            pending = this.getPendingRpcs();
        }
        if (pending != null && !pending.isEmpty()) {
            Deferred wait = Deferred.group(pending);
            return wait;
        }
        if (batched_rpcs == null || batched_rpcs.size() == 0) {
            return Deferred.fromResult(null);
        }
        Deferred<Object> d = batched_rpcs.getDeferred();
        this.sendRpc(batched_rpcs);
        return d;
    }

    Deferred<Object> sync() {
        this.flush();
        ArrayList<Deferred<Object>> rpcs = this.getInflightRpcs();
        if (rpcs.isEmpty()) {
            rpcs = this.getPendingRpcs();
        }
        if (rpcs == null) {
            return Deferred.fromResult(null);
        }
        Deferred sync = Deferred.group(rpcs);
        return sync;
    }

    private ArrayList<Deferred<Object>> getInflightRpcs() {
        ArrayList<Deferred<Object>> inflight = new ArrayList<Deferred<Object>>();
        for (HBaseRpc rpc : this.rpcs_inflight.values()) {
            inflight.add(rpc.getDeferred());
        }
        return inflight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Deferred<Object>> getPendingRpcs() {
        RegionClient regionClient = this;
        synchronized (regionClient) {
            if (this.pending_rpcs != null) {
                ArrayList<Deferred<Object>> pending = new ArrayList<Deferred<Object>>(this.pending_rpcs.size());
                for (HBaseRpc rpc : this.pending_rpcs) {
                    pending.add(rpc.getDeferred());
                }
                return pending;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> shutdown() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class RetryShutdown<T>
        implements Callback<Deferred<Object>, T> {
            private final int nrpcs;

            RetryShutdown(int nrpcs) {
                this.nrpcs = nrpcs;
            }

            public Deferred<Object> call(T ignored) {
                return RegionClient.this.shutdown();
            }

            public String toString() {
                return "wait until " + this.nrpcs + " RPCs complete";
            }
        }
        MultiAction batched_rpcs;
        ArrayList<Deferred<Object>> inflight = this.getInflightRpcs();
        int size = inflight.size();
        if (size > 0) {
            return Deferred.group(inflight).addCallbackDeferring(new RetryShutdown(size));
        }
        RegionClient regionClient = this;
        synchronized (regionClient) {
            batched_rpcs = this.batched_rpcs;
            this.batched_rpcs = null;
        }
        if (batched_rpcs != null && batched_rpcs.size() != 0) {
            Deferred<Object> d = batched_rpcs.getDeferred();
            this.sendRpc(batched_rpcs);
            return d.addCallbackDeferring(new RetryShutdown(1));
        }
        ArrayList<Deferred<Object>> pending = this.getPendingRpcs();
        if (pending != null) {
            return Deferred.group(pending).addCallbackDeferring(new RetryShutdown(pending.size()));
        }
        Channel chancopy = this.chan;
        if (chancopy == null) {
            return Deferred.fromResult(null);
        }
        LOG.debug("Shutdown requested, chan={}", (Object)chancopy);
        if (chancopy.isConnected()) {
            Channels.disconnect((Channel)chancopy);
        }
        if (chancopy.isBound()) {
            Channels.unbind((Channel)chancopy);
        }
        ChannelFuture future = Channels.close((Channel)chancopy);
        final Deferred d = new Deferred();
        if (future.isSuccess()) {
            d.callback(null);
        } else {
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        d.callback(null);
                        return;
                    }
                    Throwable t = future.getCause();
                    if (t instanceof Exception) {
                        d.callback((Object)t);
                    } else {
                        d.callback((Object)new NonRecoverableException("Failed to shutdown: " + (Object)((Object)RegionClient.this), t));
                    }
                }
            });
        }
        return d;
    }

    boolean acquireMetaLookupPermit() {
        try {
            return this.meta_lookups.tryAcquire(5L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void releaseMetaLookupPermit() {
        this.meta_lookups.release();
    }

    public Deferred<ArrayList<KeyValue>> getClosestRowBefore(RegionInfo region, final byte[] tabl, final byte[] row, final byte[] family) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class GetClosestRowBefore
        extends HBaseRpc {
            GetClosestRowBefore() {
                super(GET_CLOSEST_ROW_BEFORE, byArray, byArray2);
            }

            @Override
            ChannelBuffer serialize(byte server_version) {
                byte[] region_name = this.region.name();
                ChannelBuffer buf = this.newBuffer(server_version, 7 + region_name.length + 1 + 4 + row.length + 1 + 1 + family.length);
                buf.writeInt(3);
                GetClosestRowBefore.writeHBaseByteArray(buf, region_name);
                GetClosestRowBefore.writeHBaseByteArray(buf, row);
                GetClosestRowBefore.writeHBaseByteArray(buf, family);
                return buf;
            }
        }
        GetClosestRowBefore rpc = new GetClosestRowBefore();
        rpc.setRegion(region);
        Deferred d = rpc.getDeferred().addCallback(got_closest_row_before);
        this.sendRpc(rpc);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferEdit(BatchableRpc request) {
        MultiAction batch;
        boolean schedule_flush = false;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            if (this.batched_rpcs == null) {
                this.batched_rpcs = new MultiAction(this.server_version);
                this.addMultiActionCallbacks(this.batched_rpcs);
                schedule_flush = true;
            }
            batch = this.batched_rpcs;
            batch.add(request);
            if (batch.size() < 1024) {
                batch = null;
            } else {
                this.batched_rpcs = new MultiAction(this.server_version);
                this.addMultiActionCallbacks(this.batched_rpcs);
            }
        }
        if (schedule_flush) {
            this.scheduleNextPeriodicFlush();
        } else if (batch != null) {
            this.sendRpc(batch);
        }
    }

    private void addMultiActionCallbacks(final MultiAction request) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class MultiActionCallback
        implements Callback<Object, Object> {
            MultiActionCallback() {
            }

            public Object call(Object resp) {
                if (!(resp instanceof MultiAction.Response)) {
                    if (resp instanceof BatchableRpc) {
                        return null;
                    }
                    if (resp instanceof Exception) {
                        return this.handleException((Exception)resp);
                    }
                    throw new InvalidResponseException(MultiAction.Response.class, resp);
                }
                MultiAction.Response response = (MultiAction.Response)resp;
                ArrayList<BatchableRpc> batch = request.batch();
                int n = batch.size();
                for (int i = 0; i < n; ++i) {
                    BatchableRpc rpc = batch.get(i);
                    Object r = response.result(i);
                    if (r instanceof RecoverableException) {
                        if (r instanceof NotServingRegionException) {
                            RegionClient.this.hbase_client.handleNSRE(rpc, rpc.getRegion().name(), (NotServingRegionException)r);
                            continue;
                        }
                        RegionClient.this.retryEdit(rpc, (RecoverableException)r);
                        continue;
                    }
                    rpc.callback(r);
                }
                return null;
            }

            private Object handleException(Exception e) {
                if (!(e instanceof RecoverableException)) {
                    for (BatchableRpc rpc : request.batch()) {
                        rpc.callback(e);
                    }
                    return e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Multi-action request failed, retrying each of the " + request.size() + " RPCs individually.", (Throwable)e);
                }
                for (BatchableRpc rpc : request.batch()) {
                    RegionClient.this.retryEdit(rpc, (RecoverableException)e);
                }
                return null;
            }

            public String toString() {
                return "multi-action response";
            }
        }
        request.getDeferred().addBoth((Callback)new MultiActionCallback());
    }

    private Deferred<Object> retryEdit(BatchableRpc rpc, RecoverableException e) {
        if (HBaseClient.cannotRetryRequest(rpc)) {
            return HBaseClient.tooManyAttempts(rpc, e);
        }
        rpc.setBufferable(false);
        return this.hbase_client.sendRpcToRegion(rpc);
    }

    private void addSingleEditCallbacks(final BatchableRpc edit) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SingleEditErrback
        implements Callback<Object, Exception> {
            SingleEditErrback() {
            }

            public Object call(Exception e) {
                if (!(e instanceof RecoverableException)) {
                    return e;
                }
                return RegionClient.this.retryEdit(edit, (RecoverableException)e);
            }

            public String toString() {
                return "single-edit errback";
            }
        }
        edit.getDeferred().addErrback((Callback)new SingleEditErrback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRpc(HBaseRpc rpc) {
        boolean dead;
        if (this.chan != null) {
            if (rpc instanceof BatchableRpc && (this.server_version >= 29 || rpc instanceof PutRequest)) {
                BatchableRpc edit = (BatchableRpc)rpc;
                if (edit.canBuffer() && this.hbase_client.getFlushInterval() > 0) {
                    this.bufferEdit(edit);
                    return;
                }
                this.addSingleEditCallbacks(edit);
            } else if (rpc instanceof MultiAction) {
                MultiAction batch = (MultiAction)rpc;
                if (batch.size() == 1) {
                    rpc = this.multiActionToSingleAction(batch);
                } else {
                    this.hbase_client.num_multi_rpcs.increment();
                }
            }
            ChannelBuffer serialized = this.encode(rpc);
            if (serialized == null) {
                return;
            }
            Channel chan = this.chan;
            if (chan != null) {
                Channels.write((Channel)chan, (Object)serialized);
                return;
            }
        }
        boolean tryagain = false;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            dead = this.dead;
            if (this.chan != null) {
                tryagain = true;
            } else if (!dead) {
                if (this.pending_rpcs == null) {
                    this.pending_rpcs = new ArrayList();
                }
                this.pending_rpcs.add(rpc);
            }
        }
        if (dead) {
            if (rpc.getRegion() == null) {
                rpc.callback(new ConnectionResetException(null));
            } else {
                this.hbase_client.sendRpcToRegion(rpc);
            }
            return;
        }
        if (tryagain) {
            this.sendRpc(rpc);
            return;
        }
        LOG.debug("RPC queued: {}", (Object)rpc);
    }

    private BatchableRpc multiActionToSingleAction(final MultiAction batch) {
        final BatchableRpc rpc = batch.batch().get(0);
        this.addSingleEditCallbacks(rpc);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Multi2SingleCB
        implements Callback<Object, Object> {
            Multi2SingleCB() {
            }

            public Object call(Object arg) {
                batch.callback(arg instanceof Exception ? arg : rpc);
                return arg;
            }
        }
        rpc.getDeferred().addBoth((Callback)new Multi2SingleCB());
        return rpc;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel chan = e.getChannel();
        ChannelBuffer header = System.getProperty("org.hbase.async.cdh3b3") != null ? this.headerCDH3b3() : this.header090();
        this.helloRpc(chan, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedRpcs() {
        ArrayList<HBaseRpc> rpcs;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            rpcs = this.pending_rpcs;
            this.pending_rpcs = null;
        }
        if (rpcs != null) {
            for (HBaseRpc rpc : rpcs) {
                if (this.chan == null) continue;
                LOG.debug("Executing RPC queued: {}", (Object)rpc);
                ChannelBuffer serialized = this.encode(rpc);
                if (serialized == null) continue;
                Channels.write((Channel)this.chan, (Object)serialized);
            }
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.chan = null;
        super.channelDisconnected(ctx, e);
        this.cleanup(e.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.chan = null;
        this.cleanup(e.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Channel chan) {
        MultiAction batch;
        ArrayList<HBaseRpc> rpcs;
        ConnectionResetException exception = new ConnectionResetException(chan);
        this.failOrRetryRpcs(this.rpcs_inflight.values(), exception);
        this.rpcs_inflight.clear();
        RegionClient regionClient = this;
        synchronized (regionClient) {
            this.dead = true;
            rpcs = this.pending_rpcs;
            this.pending_rpcs = null;
            batch = this.batched_rpcs;
            this.batched_rpcs = null;
        }
        if (rpcs != null) {
            this.failOrRetryRpcs(rpcs, exception);
        }
        if (batch != null) {
            batch.callback(exception);
        }
    }

    private void failOrRetryRpcs(Collection<HBaseRpc> rpcs, ConnectionResetException exception) {
        for (HBaseRpc rpc : rpcs) {
            RegionInfo region = rpc.getRegion();
            if (region == null) {
                rpc.callback(exception);
                continue;
            }
            NotServingRegionException nsre = new NotServingRegionException("Connection reset: " + exception.getMessage(), rpc);
            this.hbase_client.handleNSRE(rpc, region.name(), nsre);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable e = event.getCause();
        Channel c = event.getChannel();
        if (e instanceof RejectedExecutionException) {
            LOG.warn("RPC rejected by the executor, ignore this if we're shutting down", e);
        } else {
            LOG.error("Unexpected exception from downstream on " + c, e);
        }
        if (c.isOpen()) {
            Channels.close((Channel)c);
        }
    }

    private ChannelBuffer encode(HBaseRpc rpc) {
        HBaseRpc oldrpc;
        ChannelBuffer payload;
        if (!rpc.hasDeferred()) {
            throw new AssertionError((Object)("Should never happen!  rpc=" + rpc));
        }
        int rpcid = this.rpcid.incrementAndGet();
        try {
            payload = rpc.serialize(this.server_version);
            byte[] method = rpc.method();
            if (this.server_version >= 29) {
                payload.setInt(0, payload.readableBytes() - 4);
                payload.setInt(4, rpcid);
                payload.setByte(8, 1);
                payload.setShort(9, method.length);
                payload.setBytes(11, method);
                payload.setLong(11 + method.length, (long)this.server_version);
            } else {
                payload.setInt(0, payload.readableBytes() - 4);
                payload.setInt(4, rpcid);
                payload.setShort(8, method.length);
                payload.setBytes(10, method);
            }
        }
        catch (Exception e) {
            LOG.error("Uncaught exception while serializing RPC: " + rpc, (Throwable)e);
            rpc.callback(e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending RPC #" + rpcid + ", payload=" + payload + ' ' + Bytes.pretty(payload));
        }
        if ((oldrpc = this.rpcs_inflight.put(rpcid, rpc)) != null) {
            String wtf = "WTF?  There was already an RPC in flight with rpcid=" + rpcid + ": " + oldrpc + ".  This happened when sending out: " + rpc;
            LOG.error(wtf);
            oldrpc.callback(new NonRecoverableException(wtf));
        }
        return payload;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum unused) {
        int rdx = buf.readerIndex();
        long start = System.nanoTime();
        LOG.debug("------------------>> ENTERING DECODE >>------------------");
        int rpcid = buf.readInt();
        Object decoded = this.deserialize(buf, rpcid);
        HBaseRpc rpc = this.rpcs_inflight.remove(rpcid);
        if (LOG.isDebugEnabled()) {
            LOG.debug("rpcid=" + rpcid + ", response size=" + (buf.readerIndex() - rdx) + " bytes" + ", " + this.actualReadableBytes() + " readable bytes left" + ", rpc=" + rpc);
        }
        if (rpc == null) {
            String msg = "Invalid rpcid: " + rpcid + " found in " + buf + '=' + Bytes.pretty(buf);
            LOG.error(msg);
            throw new NonRecoverableException(msg);
        }
        if (decoded instanceof NotServingRegionException && rpc.getRegion() != null) {
            this.hbase_client.handleNSRE(rpc, rpc.getRegion().name(), (NotServingRegionException)decoded);
            return null;
        }
        try {
            rpc.callback(decoded);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while handling RPC #" + rpcid + ", rpc=" + rpc + ", buf=" + Bytes.pretty(buf), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------------<< LEAVING  DECODE <<------------------ time elapsed: " + (System.nanoTime() - start) / 1000L + "us");
        }
        return null;
    }

    private Object deserialize(ChannelBuffer buf, int rpcid) {
        byte flags = buf.readByte();
        if ((flags & 2) != 0) {
            int length = buf.readInt() - 4 - 1 - 4 - 4;
            int status = buf.readInt();
            try {
                HBaseRpc.checkArrayLength(buf, length);
                buf.markReaderIndex();
                buf.skipBytes(length);
                buf.resetReaderIndex();
            }
            catch (IllegalArgumentException e) {
                LOG.error("WTF?  RPC #" + rpcid + ": ", (Throwable)e);
            }
        }
        HBaseRpc rpc = this.rpcs_inflight.get(rpcid);
        if ((flags & 1) != 0) {
            return RegionClient.deserializeException(buf, rpc);
        }
        try {
            return RegionClient.deserializeObject(buf, rpc);
        }
        catch (IllegalArgumentException e) {
            return new InvalidResponseException(e.getMessage(), (Object)e);
        }
    }

    static HBaseException deserializeException(ChannelBuffer buf, HBaseRpc request) {
        String type = HBaseRpc.readHadoopString(buf);
        String msg = HBaseRpc.readHadoopString(buf);
        HBaseException exc = REMOTE_EXCEPTION_TYPES.get(type);
        if (exc != null) {
            return exc.make(msg, request);
        }
        return new RemoteException(type, msg);
    }

    static Object deserializeObject(ChannelBuffer buf, HBaseRpc request) {
        switch (buf.readByte()) {
            case 1: {
                return buf.readByte() != 0;
            }
            case 6: {
                return buf.readLong();
            }
            case 14: {
                return RegionClient.deserializeObject(buf, request);
            }
            case 17: {
                buf.readByte();
                return null;
            }
            case 37: {
                buf.readByte();
                return RegionClient.parseResult(buf);
            }
            case 38: {
                return RegionClient.parseResults(buf);
            }
            case 58: 
            case 67: {
                return ((MultiAction)request).responseFromBuffer(buf);
            }
        }
        throw new NonRecoverableException("Couldn't de-serialize " + Bytes.pretty(buf));
    }

    private static ArrayList<KeyValue> parseResult(ChannelBuffer buf) {
        int kv_length;
        int length = buf.readInt();
        HBaseRpc.checkArrayLength(buf, length);
        buf.markReaderIndex();
        buf.skipBytes(length);
        buf.resetReaderIndex();
        int num_kv = 0;
        for (int bytes_read = 0; bytes_read < length; bytes_read += kv_length + 4) {
            kv_length = buf.readInt();
            HBaseRpc.checkArrayLength(buf, kv_length);
            ++num_kv;
            buf.skipBytes(kv_length);
        }
        buf.resetReaderIndex();
        ArrayList<KeyValue> results = new ArrayList<KeyValue>(num_kv);
        KeyValue kv = null;
        for (int i = 0; i < num_kv; ++i) {
            int kv_length2 = buf.readInt();
            int key_length = 2 + (kv = KeyValue.fromBuffer(buf, kv)).key().length + 1 + kv.family().length + kv.qualifier().length + 8 + 1;
            if (key_length + kv.value().length + 4 + 4 != kv_length2) {
                RegionClient.badResponse("kv_length=" + kv_length2 + " doesn't match key_length + value_length (" + key_length + " + " + kv.value().length + ") in " + buf + '=' + Bytes.pretty(buf));
            }
            results.add(kv);
        }
        return results;
    }

    private static ArrayList<ArrayList<KeyValue>> parseResults(ChannelBuffer buf) {
        int nresults;
        byte version = buf.readByte();
        if (version != 1) {
            LOG.warn("Received unsupported Result[] version: " + version);
        }
        if ((nresults = buf.readInt()) < 0) {
            RegionClient.badResponse("Negative number of results=" + nresults + " found in " + buf + '=' + Bytes.pretty(buf));
        } else if (nresults == 0) {
            return null;
        }
        int length = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, length);
        buf.markReaderIndex();
        buf.skipBytes(length);
        buf.resetReaderIndex();
        ArrayList<ArrayList<KeyValue>> results = new ArrayList<ArrayList<KeyValue>>(nresults);
        int bytes_read = 0;
        for (int i = 0; i < nresults; ++i) {
            int num_kv = buf.readInt();
            bytes_read += 4;
            if (num_kv < 0) {
                RegionClient.badResponse("Negative number of KeyValues=" + num_kv + " for Result[" + i + "] found in " + buf + '=' + Bytes.pretty(buf));
            } else if (nresults == 0) continue;
            ArrayList<KeyValue> result = new ArrayList<KeyValue>(num_kv);
            KeyValue kv = null;
            for (int j = 0; j < num_kv; ++j) {
                int kv_length = buf.readInt();
                HBaseRpc.checkNonEmptyArrayLength(buf, kv_length);
                kv = KeyValue.fromBuffer(buf, kv);
                result.add(kv);
                bytes_read += 4 + kv_length;
            }
            results.add(result);
        }
        if (length != bytes_read) {
            RegionClient.badResponse("Result[" + nresults + "] was supposed to be " + length + " bytes, but we only read " + bytes_read + " bytes from " + buf + '=' + Bytes.pretty(buf));
        }
        return results;
    }

    private static void badResponse(String errmsg) {
        LOG.error(errmsg);
        throw new InvalidResponseException(errmsg, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decodeLast(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum unused) {
        if (buf.readable()) {
            try {
                Object object = this.decode(ctx, chan, buf, unused);
                return object;
            }
            finally {
                if (buf.readable()) {
                    LOG.error("After decoding the last message on " + chan + ", there was still some undecoded bytes in the channel's" + " buffer (which are going to be lost): " + buf + '=' + Bytes.pretty(buf));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int nedits;
        int npending_rpcs;
        StringBuilder buf = new StringBuilder(141);
        buf.append("RegionClient@").append(((Object)((Object)this)).hashCode()).append("(chan=").append(this.chan).append(", #pending_rpcs=");
        RegionClient regionClient = this;
        synchronized (regionClient) {
            npending_rpcs = this.pending_rpcs == null ? 0 : this.pending_rpcs.size();
            nedits = this.batched_rpcs == null ? 0 : this.batched_rpcs.size();
        }
        buf.append(npending_rpcs).append(", #batched=").append(nedits);
        buf.append(", #rpcs_inflight=").append(this.rpcs_inflight.size()).append(')');
        return buf.toString();
    }

    private ChannelBuffer commonHeader(byte[] buf, byte[] hrpc) {
        ChannelBuffer header = ChannelBuffers.wrappedBuffer((byte[])buf);
        header.clear();
        header.writeBytes(hrpc);
        return header;
    }

    private ChannelBuffer header092() {
        byte[] buf = new byte[54];
        ChannelBuffer header = this.commonHeader(buf, HRPC3);
        header.writerIndex(header.writerIndex() + 4);
        String klass = "org.apache.hadoop.hbase.ipc.HRegionInterface";
        header.writeByte("org.apache.hadoop.hbase.ipc.HRegionInterface".length());
        header.writeBytes(Bytes.ISO88591("org.apache.hadoop.hbase.ipc.HRegionInterface"));
        header.setInt(5, header.writerIndex() - 4 - 5);
        return header;
    }

    private ChannelBuffer header090() {
        byte[] buf = new byte[139];
        ChannelBuffer header = this.commonHeader(buf, HRPC3);
        header.writerIndex(header.writerIndex() + 4);
        String klass = "org.apache.hadoop.io.Writable";
        header.writeShort(klass.length());
        header.writeBytes(Bytes.ISO88591(klass));
        klass = "org.apache.hadoop.io.ObjectWritable$NullInstance";
        header.writeShort(klass.length());
        header.writeBytes(Bytes.ISO88591(klass));
        klass = "org.apache.hadoop.security.UserGroupInformation";
        header.writeShort(klass.length());
        header.writeBytes(Bytes.ISO88591(klass));
        header.setInt(5, header.writerIndex() - 4 - 5);
        return header;
    }

    private ChannelBuffer headerCDH3b3() {
        byte[] user = Bytes.UTF8(System.getProperty("user.name", "asynchbase"));
        byte[] buf = new byte[13 + user.length];
        ChannelBuffer header = this.commonHeader(buf, HRPC3);
        header.writeInt(4 + user.length);
        header.writeInt(user.length);
        header.writeBytes(user);
        return header;
    }

    private void helloRpc(Channel chan, ChannelBuffer header) {
        GetProtocolVersionRequest rpc = new GetProtocolVersionRequest();
        rpc.getDeferred().addBoth((Callback)new ProtocolVersionCB(chan));
        Channels.write((Channel)chan, (Object)ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, this.encode(rpc)}));
    }

    static {
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException", new NoSuchColumnFamilyException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.NotServingRegionException", new NotServingRegionException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.UnknownScannerException", new UnknownScannerException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.UnknownRowLockException", new UnknownRowLockException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.io.VersionMismatchException", new VersionMismatchException(null, null));
        GET_PROTOCOL_VERSION = new byte[]{103, 101, 116, 80, 114, 111, 116, 111, 99, 111, 108, 86, 101, 114, 115, 105, 111, 110};
        GET_CLOSEST_ROW_BEFORE = new byte[]{103, 101, 116, 67, 108, 111, 115, 101, 115, 116, 82, 111, 119, 66, 101, 102, 111, 114, 101};
        got_closest_row_before = new Callback<ArrayList<KeyValue>, Object>(){

            public ArrayList<KeyValue> call(Object response) {
                if (response == null) {
                    return new ArrayList<KeyValue>(0);
                }
                if (response instanceof ArrayList) {
                    ArrayList row = (ArrayList)response;
                    return row;
                }
                throw new InvalidResponseException(ArrayList.class, response);
            }

            public String toString() {
                return "type getClosestRowBefore response";
            }
        };
        HRPC3 = new byte[]{104, 114, 112, 99, 3};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class RetryRpc<T>
    implements Callback<T, T> {
        private final HBaseRpc rpc;

        RetryRpc(HBaseRpc rpc) {
            this.rpc = rpc;
        }

        public T call(T arg) {
            RegionClient.this.sendRpc(this.rpc);
            return arg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProtocolVersionCB
    implements Callback<Long, Object> {
        private final Channel chan;

        public ProtocolVersionCB(Channel chan) {
            this.chan = chan;
        }

        public Long call(Object response) throws Exception {
            if (response instanceof VersionMismatchException) {
                if (RegionClient.this.server_version != 0) {
                    throw (VersionMismatchException)response;
                }
                RegionClient.this.server_version = (byte)29;
                RegionClient.this.helloRpc(this.chan, RegionClient.this.header092());
                return null;
            }
            if (!(response instanceof Long)) {
                if (response instanceof Exception) {
                    throw (Exception)response;
                }
                throw new InvalidResponseException(Long.class, response);
            }
            Long version = (Long)response;
            long v = version;
            if (v <= 0L || v > 127L) {
                throw new InvalidResponseException("getProtocolVersion returned a " + (v <= 0L ? "negative" : "too large") + " value", (Object)version);
            }
            RegionClient.this.server_version = (byte)v;
            RegionClient.this.chan = this.chan;
            RegionClient.this.sendQueuedRpcs();
            return version;
        }

        public String toString() {
            return "handle getProtocolVersion response on " + this.chan;
        }
    }

    private static final class GetProtocolVersionRequest
    extends HBaseRpc {
        GetProtocolVersionRequest() {
            super(GET_PROTOCOL_VERSION);
        }

        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 59);
            buf.writeInt(2);
            GetProtocolVersionRequest.writeHBaseString(buf, "org.apache.hadoop.hbase.ipc.HRegionInterface");
            GetProtocolVersionRequest.writeHBaseLong(buf, server_version == 0 ? 24L : (long)server_version);
            return buf;
        }
    }
}

