/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Arrays;
import java.util.Comparator;
import org.hbase.async.BrokenMetaException;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionOfflineException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegionInfo
implements Comparable<RegionInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionInfo.class);
    private final byte[] table;
    private final byte[] region_name;
    private final byte[] stop_key;
    static final RegionNameCmp REGION_NAME_CMP = new RegionNameCmp();

    public RegionInfo(byte[] table, byte[] region_name, byte[] stop_key) {
        this.table = table;
        this.region_name = region_name;
        this.stop_key = stop_key.length == 0 ? HBaseClient.EMPTY_ARRAY : stop_key;
    }

    public byte[] table() {
        return this.table;
    }

    public byte[] name() {
        return this.region_name;
    }

    public byte[] stopKey() {
        return this.stop_key;
    }

    static RegionInfo fromKeyValue(KeyValue kv, byte[][] out_start_key) {
        byte[] table;
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((byte[])kv.value());
        byte version = buf.readByte();
        if (version != 1 && version != 0) {
            LOG.warn("Unsupported region info version: " + version + " in .META.  entry: " + kv);
        }
        byte[] stop_key = HBaseRpc.readByteArray(buf);
        boolean offline = buf.readByte() != 0;
        long region_id = buf.readLong();
        byte[] region_name = HBaseRpc.readByteArray(buf);
        try {
            table = RegionInfo.tableFromRegionName(region_name);
        }
        catch (IllegalArgumentException e) {
            throw BrokenMetaException.badKV(null, "an `info:regioninfo' cell has a " + e.getMessage(), kv);
        }
        boolean split = buf.readByte() != 0;
        byte[] start_key = HBaseRpc.readByteArray(buf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got " + Bytes.pretty(table) + "'s region [" + Bytes.pretty(start_key) + '-' + Bytes.pretty(stop_key) + ") offline=" + offline + ", region_id=" + region_id + ", region_name=" + Bytes.pretty(region_name) + ", split=" + split);
        }
        if (offline && !split) {
            throw new RegionOfflineException(region_name);
        }
        RegionInfo region = new RegionInfo(split ? HBaseClient.EMPTY_ARRAY : table, region_name, stop_key);
        out_start_key[0] = start_key;
        return region;
    }

    static byte[] tableFromRegionName(byte[] region_name) {
        int comma;
        for (comma = 1; comma < region_name.length && region_name[comma] != 44; ++comma) {
        }
        if (comma == region_name.length) {
            throw new IllegalArgumentException("Malformed region name, contains no comma: " + Bytes.pretty(region_name));
        }
        return Arrays.copyOf(region_name, comma);
    }

    @Override
    public int compareTo(RegionInfo other) {
        return Bytes.memcmp(this.region_name, other.region_name);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RegionInfo)) {
            return false;
        }
        return this.compareTo((RegionInfo)other) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.table) ^ Arrays.hashCode(this.region_name) ^ Arrays.hashCode(this.stop_key);
    }

    int stringSizeHint() {
        return 48 + this.table.length + 2 + this.region_name.length * 2 + this.stop_key.length * 2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.stringSizeHint());
        this.toStringbuf(buf);
        return buf.toString();
    }

    void toStringbuf(StringBuilder buf) {
        buf.append("RegionInfo(table=");
        if (this.table == HBaseClient.EMPTY_ARRAY) {
            buf.append("<NSRE marker>");
        } else {
            Bytes.pretty(buf, this.table);
        }
        buf.append(", region_name=");
        Bytes.pretty(buf, this.region_name);
        buf.append(", stop_key=");
        Bytes.pretty(buf, this.stop_key);
        buf.append(')');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegionNameCmp
    implements Comparator<byte[]> {
        private RegionNameCmp() {
        }

        @Override
        public int compare(byte[] a, byte[] b) {
            byte bi;
            byte ai;
            int i;
            int length = Math.min(a.length, b.length);
            if (a == b) {
                return 0;
            }
            for (i = 0; i < length; ++i) {
                byte ai2 = a[i];
                byte bi2 = b[i];
                if (ai2 != bi2) {
                    if (ai2 == 44) {
                        return -1001;
                    }
                    if (bi2 == 44) {
                        return 1001;
                    }
                    return (ai2 & 0xFF) - (bi2 & 0xFF);
                }
                if (ai2 == 44) break;
            }
            int a_comma = RegionNameCmp.findCommaFromEnd(a, i);
            int b_comma = RegionNameCmp.findCommaFromEnd(b, i);
            ++i;
            int first_comma = Math.min(a_comma, b_comma);
            while (i < first_comma) {
                ai = a[i];
                bi = b[i];
                if (ai != bi) {
                    return (ai & 0xFF) - (bi & 0xFF);
                }
                ++i;
            }
            if (a_comma < b_comma) {
                return -1002;
            }
            if (b_comma < a_comma) {
                return 1002;
            }
            while (i < length) {
                ai = a[i];
                bi = b[i];
                if (ai != bi) {
                    return (ai & 0xFF) - (bi & 0xFF);
                }
                ++i;
            }
            return a.length - b.length;
        }

        private static int findCommaFromEnd(byte[] b, int offset) {
            for (int i = b.length - 1; i > offset; --i) {
                if (b[i] != 44) continue;
                return i;
            }
            throw new IllegalArgumentException("No comma found in " + Bytes.pretty(b) + " after offset " + offset);
        }
    }
}

