
package org.hibernate.processor.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         This element contains the entity field or property mappings.
 *         It may be sparsely populated to include only a subset of the
 *         fields or properties. If metadata-complete for the entity is true
 *         then the remainder of the attributes will be defaulted according
 *         to the default rules.
 * 
 *       
 * 
 * <p>Java class for attributes complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="attributes">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <choice>
 *           <element name="id" type="{https://jakarta.ee/xml/ns/persistence/orm}id" maxOccurs="unbounded" minOccurs="0"/>
 *           <element name="embedded-id" type="{https://jakarta.ee/xml/ns/persistence/orm}embedded-id" minOccurs="0"/>
 *         </choice>
 *         <element name="basic" type="{https://jakarta.ee/xml/ns/persistence/orm}basic" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="version" type="{https://jakarta.ee/xml/ns/persistence/orm}version" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="many-to-one" type="{https://jakarta.ee/xml/ns/persistence/orm}many-to-one" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="one-to-many" type="{https://jakarta.ee/xml/ns/persistence/orm}one-to-many" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="one-to-one" type="{https://jakarta.ee/xml/ns/persistence/orm}one-to-one" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="many-to-many" type="{https://jakarta.ee/xml/ns/persistence/orm}many-to-many" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="element-collection" type="{https://jakarta.ee/xml/ns/persistence/orm}element-collection" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="embedded" type="{https://jakarta.ee/xml/ns/persistence/orm}embedded" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="transient" type="{https://jakarta.ee/xml/ns/persistence/orm}transient" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "attributes", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "description",
    "id",
    "embeddedId",
    "basic",
    "version",
    "manyToOne",
    "oneToMany",
    "oneToOne",
    "manyToMany",
    "elementCollection",
    "embedded",
    "_transient"
})
public class Attributes {

    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String description;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Id> id;
    @XmlElement(name = "embedded-id", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected EmbeddedId embeddedId;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Basic> basic;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Version> version;
    @XmlElement(name = "many-to-one", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<ManyToOne> manyToOne;
    @XmlElement(name = "one-to-many", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<OneToMany> oneToMany;
    @XmlElement(name = "one-to-one", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<OneToOne> oneToOne;
    @XmlElement(name = "many-to-many", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<ManyToMany> manyToMany;
    @XmlElement(name = "element-collection", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<ElementCollection> elementCollection;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Embedded> embedded;
    @XmlElement(name = "transient", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Transient> _transient;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the id property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getId().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Id }
     * 
     * 
     * @return
     *     The value of the id property.
     */
    public List<Id> getId() {
        if (id == null) {
            id = new ArrayList<>();
        }
        return this.id;
    }

    /**
     * Gets the value of the embeddedId property.
     * 
     * @return
     *     possible object is
     *     {@link EmbeddedId }
     *     
     */
    public EmbeddedId getEmbeddedId() {
        return embeddedId;
    }

    /**
     * Sets the value of the embeddedId property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmbeddedId }
     *     
     */
    public void setEmbeddedId(EmbeddedId value) {
        this.embeddedId = value;
    }

    /**
     * Gets the value of the basic property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the basic property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBasic().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Basic }
     * 
     * 
     * @return
     *     The value of the basic property.
     */
    public List<Basic> getBasic() {
        if (basic == null) {
            basic = new ArrayList<>();
        }
        return this.basic;
    }

    /**
     * Gets the value of the version property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the version property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVersion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Version }
     * 
     * 
     * @return
     *     The value of the version property.
     */
    public List<Version> getVersion() {
        if (version == null) {
            version = new ArrayList<>();
        }
        return this.version;
    }

    /**
     * Gets the value of the manyToOne property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the manyToOne property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getManyToOne().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ManyToOne }
     * 
     * 
     * @return
     *     The value of the manyToOne property.
     */
    public List<ManyToOne> getManyToOne() {
        if (manyToOne == null) {
            manyToOne = new ArrayList<>();
        }
        return this.manyToOne;
    }

    /**
     * Gets the value of the oneToMany property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the oneToMany property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOneToMany().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OneToMany }
     * 
     * 
     * @return
     *     The value of the oneToMany property.
     */
    public List<OneToMany> getOneToMany() {
        if (oneToMany == null) {
            oneToMany = new ArrayList<>();
        }
        return this.oneToMany;
    }

    /**
     * Gets the value of the oneToOne property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the oneToOne property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOneToOne().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OneToOne }
     * 
     * 
     * @return
     *     The value of the oneToOne property.
     */
    public List<OneToOne> getOneToOne() {
        if (oneToOne == null) {
            oneToOne = new ArrayList<>();
        }
        return this.oneToOne;
    }

    /**
     * Gets the value of the manyToMany property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the manyToMany property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getManyToMany().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ManyToMany }
     * 
     * 
     * @return
     *     The value of the manyToMany property.
     */
    public List<ManyToMany> getManyToMany() {
        if (manyToMany == null) {
            manyToMany = new ArrayList<>();
        }
        return this.manyToMany;
    }

    /**
     * Gets the value of the elementCollection property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the elementCollection property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getElementCollection().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ElementCollection }
     * 
     * 
     * @return
     *     The value of the elementCollection property.
     */
    public List<ElementCollection> getElementCollection() {
        if (elementCollection == null) {
            elementCollection = new ArrayList<>();
        }
        return this.elementCollection;
    }

    /**
     * Gets the value of the embedded property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the embedded property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmbedded().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Embedded }
     * 
     * 
     * @return
     *     The value of the embedded property.
     */
    public List<Embedded> getEmbedded() {
        if (embedded == null) {
            embedded = new ArrayList<>();
        }
        return this.embedded;
    }

    /**
     * Gets the value of the transient property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the transient property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTransient().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Transient }
     * 
     * 
     * @return
     *     The value of the transient property.
     */
    public List<Transient> getTransient() {
        if (_transient == null) {
            _transient = new ArrayList<>();
        }
        return this._transient;
    }

}
