/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.integration.bootstrap.HornetQBootstrapLogger;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.deployment.KernelDeployment;

public class HornetQBootstrapServer
extends BasicBootstrap {
    protected BeanXMLDeployer deployer;
    protected List<KernelDeployment> deployments = new CopyOnWriteArrayList<KernelDeployment>();
    private final String[] args;
    private Properties properties;

    public static void main(String[] args) throws Exception {
        HornetQBootstrapLogger.LOGGER.serverStarting();
        HornetQBootstrapServer bootstrap = new HornetQBootstrapServer(args);
        bootstrap.run();
        bootstrap.addShutdownHook();
    }

    private void addShutdownHook() {
        String dirName = System.getProperty("hornetq.config.dir", ".");
        final File file = new File(dirName + "/STOP_ME");
        if (file.exists() && !file.delete()) {
            HornetQBootstrapLogger.LOGGER.errorDeletingFile(file.getAbsolutePath());
        }
        final Timer timer = new Timer("HornetQ Server Shutdown Timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (file.exists()) {
                    try {
                        HornetQBootstrapServer.this.shutDown();
                        timer.cancel();
                    }
                    finally {
                        Runtime.getRuntime().exit(0);
                    }
                }
            }
        }, 500L, 500L);
    }

    public void run() {
        try {
            super.run();
        }
        catch (RuntimeException e) {
            HornetQBootstrapLogger.LOGGER.errorStartingServer(e);
            throw e;
        }
    }

    public HornetQBootstrapServer(String ... args) throws Exception {
        this.args = args;
    }

    public HornetQBootstrapServer(KernelConfig kernelConfig, String ... args) throws Exception {
        super(kernelConfig);
        this.args = args;
    }

    public void bootstrap() throws Throwable {
        super.bootstrap();
        this.deployer = new BeanXMLDeployer(this.getKernel());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        for (String arg : this.args) {
            this.deploy(arg);
        }
        this.deployer.validate();
    }

    public void undeploy(KernelDeployment deployment) throws Throwable {
        HornetQBootstrapLogger.LOGGER.debug("Undeploying " + deployment.getName());
        this.deployments.remove(deployment);
        try {
            this.deployer.undeploy(deployment);
            HornetQBootstrapLogger.LOGGER.debug("Undeployed " + deployment.getName());
        }
        catch (Throwable t) {
            HornetQBootstrapLogger.LOGGER.errorDuringUndeployment(t, deployment.getName());
            HornetQBootstrapLogger.LOGGER.warn("Error during undeployment: " + deployment.getName(), t);
        }
    }

    public KernelDeployment deploy(String arg) throws Throwable {
        File file;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(arg);
        if (url == null) {
            url = cl.getResource("META-INF/" + arg);
        }
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getClassLoader().getResource(arg);
        }
        if (url == null && (file = new File(arg)).exists()) {
            url = file.toURI().toURL();
        }
        if (url == null) {
            throw new RuntimeException("Unable to find resource:" + arg);
        }
        return this.deploy(url);
    }

    public KernelDeployment deploy(String name, String xml) throws Throwable {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintStream printOut = new PrintStream(byteOut);
        printOut.print(xml);
        printOut.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(byteOut.toByteArray());
        KernelDeployment deployment = this.deployer.deploy(name, (InputStream)is);
        this.deployments.add(deployment);
        return deployment;
    }

    private KernelDeployment deploy(URL url) throws Throwable {
        HornetQBootstrapLogger.LOGGER.debug("Deploying " + url);
        KernelDeployment deployment = this.deployer.deploy(url);
        this.deployments.add(deployment);
        HornetQBootstrapLogger.LOGGER.debug("Deployed " + url);
        return deployment;
    }

    public void shutDown() {
        HornetQBootstrapLogger.LOGGER.serverStopping();
        ListIterator<KernelDeployment> iterator = this.deployments.listIterator(this.deployments.size());
        while (iterator.hasPrevious()) {
            KernelDeployment deployment = iterator.previous();
            try {
                this.undeploy(deployment);
            }
            catch (Throwable t) {
                HornetQBootstrapLogger.LOGGER.errorDuringUndeployment(t, deployment.getName());
            }
        }
    }

    protected Properties getConfigProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    private final class Shutdown
    extends Thread {
        public Shutdown() {
            super("hornetq-shutdown-thread");
        }

        @Override
        public void run() {
            HornetQBootstrapServer.this.shutDown();
        }
    }
}

