/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationDeleteTXMessage
extends PacketImpl {
    private long txId;
    private long id;
    private byte journalID;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationDeleteTXMessage() {
        super((byte)94);
    }

    public ReplicationDeleteTXMessage(byte journalID, long txId, long id, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.txId = txId;
        this.id = id;
        this.encodingData = encodingData;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.txId);
        buffer.writeLong(this.id);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.txId = buffer.readLong();
        this.id = buffer.readLong();
        int size1 = buffer.readInt();
        this.recordData = new byte[size1];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encodingData == null ? 0 : this.encodingData.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.journalID;
        result = 31 * result + Arrays.hashCode(this.recordData);
        result = 31 * result + (int)(this.txId ^ this.txId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationDeleteTXMessage other = (ReplicationDeleteTXMessage)((Object)obj);
        if (this.encodingData == null ? other.encodingData != null : !this.encodingData.equals(other.encodingData)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.journalID != other.journalID) {
            return false;
        }
        if (!Arrays.equals(this.recordData, other.recordData)) {
            return false;
        }
        return this.txId == other.txId;
    }
}

