/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import io.netty.channel.ChannelFutureListener;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.UUIDGenerator;

public class InVMConnection
implements Connection {
    private static final boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final String id;
    private boolean closed;
    private static boolean flushEnabled = true;
    private final int serverID;
    private final Executor executor;
    private volatile boolean closing;
    private final HornetQPrincipal defaultHornetQPrincipal;
    private RemotingConnection protocolConnection;

    public InVMConnection(int serverID, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, UUIDGenerator.getInstance().generateSimpleStringUUID().toString(), handler, listener, executor);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, id, handler, listener, executor, null);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor, HornetQPrincipal defaultHornetQPrincipal) {
        this.serverID = serverID;
        this.handler = handler;
        this.listener = listener;
        this.id = id;
        this.executor = executor;
        this.defaultHornetQPrincipal = defaultHornetQPrincipal;
    }

    public void forceClose() {
    }

    public RemotingConnection getProtocolConnection() {
        return this.protocolConnection;
    }

    public void setProtocolConnection(RemotingConnection connection) {
        this.protocolConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        InVMConnection inVMConnection = this;
        synchronized (inVMConnection) {
            if (!this.closed) {
                this.listener.connectionDestroyed((Object)this.id);
                this.closed = true;
            }
        }
    }

    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer((int)size);
    }

    public Object getID() {
        return this.id;
    }

    public void checkFlushBatchBuffer() {
    }

    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false, null);
    }

    public void write(HornetQBuffer buffer, boolean flush, boolean batch) {
        this.write(buffer, flush, batch, null);
    }

    public void write(HornetQBuffer buffer, boolean flush, boolean batch, final ChannelFutureListener futureListener) {
        block5: {
            final HornetQBuffer copied = buffer.copy(0, buffer.capacity());
            copied.setIndex(buffer.readerIndex(), buffer.writerIndex());
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!InVMConnection.this.closed) {
                                copied.readInt();
                                if (isTrace) {
                                    HornetQServerLogger.LOGGER.trace(InVMConnection.this + "::Sending inVM packet");
                                }
                                InVMConnection.this.handler.bufferReceived((Object)InVMConnection.this.id, copied);
                                if (futureListener != null) {
                                    futureListener.operationComplete(null);
                                }
                            }
                        }
                        catch (Exception e) {
                            String msg = "Failed to write to handler on connector " + this;
                            HornetQServerLogger.LOGGER.errorWritingToInvmConnector(e, this);
                            throw new IllegalStateException(msg, e);
                        }
                        finally {
                            if (isTrace) {
                                HornetQServerLogger.LOGGER.trace(InVMConnection.this + "::packet sent done");
                            }
                        }
                    }
                });
                if (!flush || !flushEnabled) break block5;
                final CountDownLatch latch = new CountDownLatch(1);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
                try {
                    if (!latch.await(10L, TimeUnit.SECONDS)) {
                        HornetQServerLogger.LOGGER.timedOutFlushingInvmChannel();
                    }
                }
                catch (InterruptedException e) {
                    throw new HornetQInterruptedException((Throwable)e);
                }
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
    }

    public String getRemoteAddress() {
        return "invm:" + this.serverID;
    }

    public int getBatchingBufferSize() {
        return -1;
    }

    public void addReadyListener(ReadyListener listener) {
    }

    public void removeReadyListener(ReadyListener listener) {
    }

    public boolean isUsingProtocolHandling() {
        return false;
    }

    public HornetQPrincipal getDefaultHornetQPrincipal() {
        return this.defaultHornetQPrincipal;
    }

    public static void setFlushEnabled(boolean enable) {
        flushEnabled = enable;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public TransportConfiguration getConnectorConfig() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("server-id", this.serverID);
        return new TransportConfiguration(InVMConnectorFactory.class.getName(), params);
    }

    public String toString() {
        return "InVMConnection [serverID=" + this.serverID + ", id=" + this.id + "]";
    }
}

