/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.server.cluster.qourum.SharedNothingBackupQuorum;

public abstract class LiveNodeLocator
implements ClusterTopologyListener {
    private SharedNothingBackupQuorum backupQuorum;

    public LiveNodeLocator(SharedNothingBackupQuorum backupQuorum) {
        this.backupQuorum = backupQuorum;
    }

    public LiveNodeLocator() {
    }

    public abstract void locateNode(long var1) throws HornetQException;

    public abstract void locateNode() throws HornetQException;

    public abstract Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration();

    public abstract String getNodeID();

    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        if (this.backupQuorum != null) {
            if (alreadyReplicating) {
                this.backupQuorum.notifyAlreadyReplicating();
            } else {
                this.backupQuorum.notifyRegistrationFailed();
            }
        }
    }

    public void connectToCluster(ServerLocatorInternal serverLocator) throws HornetQException {
        serverLocator.connect();
    }
}

