/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorImpl;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterControl;
import org.hornetq.core.server.cluster.HornetQServerSideProtocolManagerFactory;
import org.hornetq.core.server.cluster.qourum.QuorumManager;
import org.hornetq.core.server.cluster.qourum.QuorumVoteHandler;
import org.hornetq.core.server.cluster.qourum.Vote;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.ClientProtocolManagerFactory;

public class ClusterController
implements HornetQComponent {
    private static final boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final QuorumManager quorumManager;
    private final HornetQServer server;
    private Map<SimpleString, ServerLocatorInternal> locators = new HashMap<SimpleString, ServerLocatorInternal>();
    private SimpleString defaultClusterConnectionName;
    private ServerLocator defaultLocator;
    private ServerLocator replicationLocator;
    private final Executor executor;
    private CountDownLatch replicationClusterConnectedLatch;
    private boolean started;
    private SimpleString replicatedClusterName;

    public ClusterController(HornetQServer server, ScheduledExecutorService scheduledExecutor) {
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        this.quorumManager = new QuorumManager(scheduledExecutor, this);
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.defaultLocator = (ServerLocator)this.locators.get(this.defaultClusterConnectionName);
        if (this.replicatedClusterName != null && !this.replicatedClusterName.equals((Object)this.defaultClusterConnectionName)) {
            this.replicationLocator = (ServerLocator)this.locators.get(this.replicatedClusterName);
            if (this.replicationLocator == null) {
                HornetQServerLogger.LOGGER.noClusterConnectionForReplicationCluster();
                this.replicationLocator = this.defaultLocator;
            }
        } else {
            this.replicationLocator = this.defaultLocator;
        }
        this.replicationClusterConnectedLatch = new CountDownLatch(1);
        this.defaultLocator.addClusterTopologyListener((ClusterTopologyListener)this.quorumManager);
        this.quorumManager.start();
        this.started = true;
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            if (!serverLocatorInternal.isConnectable()) continue;
            this.executor.execute(new ConnectRunnable(serverLocatorInternal));
        }
    }

    public void stop() throws Exception {
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            serverLocatorInternal.close();
        }
        this.quorumManager.stop();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public QuorumManager getQuorumManager() {
        return this.quorumManager;
    }

    public void setDefaultClusterConnectionName(SimpleString defaultClusterConnection) {
        this.defaultClusterConnectionName = defaultClusterConnection;
    }

    public void addClusterConnection(SimpleString name, DiscoveryGroupConfiguration dg) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)HornetQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        serverLocator.setReconnectAttempts(-1);
        serverLocator.setInitialConnectAttempts(-1);
        serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)HornetQServerSideProtocolManagerFactory.getInstance());
        this.locators.put(name, (ServerLocatorInternal)serverLocator);
    }

    public void addClusterConnection(SimpleString name, TransportConfiguration[] tcConfigs) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)HornetQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        serverLocator.setReconnectAttempts(-1);
        serverLocator.setInitialConnectAttempts(-1);
        serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)HornetQServerSideProtocolManagerFactory.getInstance());
        this.locators.put(name, (ServerLocatorInternal)serverLocator);
    }

    public void addClusterTopologyListenerForReplication(ClusterTopologyListener listener) {
        this.replicationLocator.addClusterTopologyListener(listener);
    }

    public void addIncomingInterceptorForReplication(Interceptor interceptor) {
        this.replicationLocator.addIncomingInterceptor(interceptor);
    }

    public ClusterControl connectToNode(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.defaultLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInReplicatedCluster(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.replicationLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInCluster(ClientSessionFactoryInternal sf) {
        sf.getServerLocator().setProtocolManagerFactory((ClientProtocolManagerFactory)HornetQServerSideProtocolManagerFactory.getInstance());
        return new ClusterControl(sf, this.server);
    }

    public long getRetryIntervalForReplicatedCluster() {
        return this.replicationLocator.getRetryInterval();
    }

    public void awaitConnectionToReplicationCluster() throws InterruptedException {
        this.replicationClusterConnectedLatch.await();
    }

    public void addClusterChannelHandler(Channel channel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, Activation activation) {
        channel.setHandler((ChannelHandler)new ClusterControllerChannelHandler(channel, acceptorUsed, remotingConnection, activation.getActivationChannelHandler(channel, acceptorUsed)));
    }

    public int getDefaultClusterSize() {
        return this.defaultLocator.getTopology().getMembers().size();
    }

    public Topology getDefaultClusterTopology() {
        return this.defaultLocator.getTopology();
    }

    public SimpleString getNodeID() {
        return this.server.getNodeID();
    }

    public String getIdentity() {
        return this.server.getIdentity();
    }

    public void setReplicatedClusterName(String replicatedClusterName) {
        this.replicatedClusterName = new SimpleString(replicatedClusterName);
    }

    private final class ConnectRunnable
    implements Runnable {
        private ServerLocatorInternal serverLocator;

        public ConnectRunnable(ServerLocatorInternal serverLocator) {
            this.serverLocator = serverLocator;
        }

        @Override
        public void run() {
            try {
                this.serverLocator.connect();
                if (this.serverLocator == ClusterController.this.replicationLocator) {
                    ClusterController.this.replicationClusterConnectedLatch.countDown();
                }
            }
            catch (HornetQException e) {
                if (!ClusterController.this.started) {
                    return;
                }
                ClusterController.this.server.getScheduledPool().schedule(this, this.serverLocator.getRetryInterval(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class ClusterControllerChannelHandler
    implements ChannelHandler {
        private final Channel clusterChannel;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection remotingConnection;
        private final ChannelHandler channelHandler;
        boolean authorized = false;

        public ClusterControllerChannelHandler(Channel clusterChannel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, ChannelHandler channelHandler) {
            this.clusterChannel = clusterChannel;
            this.acceptorUsed = acceptorUsed;
            this.remotingConnection = remotingConnection;
            this.channelHandler = channelHandler;
        }

        public void handlePacket(Packet packet) {
            if (!this.authorized) {
                if (packet.getType() == 125) {
                    ClusterConnection clusterConnection = this.acceptorUsed.getClusterConnection();
                    if (clusterConnection == null) {
                        clusterConnection = ClusterController.this.server.getClusterManager().getDefaultConnection(null);
                    }
                    ClusterConnectMessage msg = (ClusterConnectMessage)packet;
                    if (ClusterController.this.server.getConfiguration().isSecurityEnabled() && !clusterConnection.verify(msg.getClusterUser(), msg.getClusterPassword())) {
                        this.clusterChannel.send((Packet)new ClusterConnectReplyMessage(false));
                    } else {
                        this.authorized = true;
                        this.clusterChannel.send((Packet)new ClusterConnectReplyMessage(true));
                    }
                }
            } else if (packet.getType() == 111) {
                NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                Pair pair = msg.isBackup() ? new Pair(null, (Object)msg.getConnector()) : new Pair((Object)msg.getConnector(), (Object)msg.getBackupConnector());
                if (isTrace) {
                    HornetQServerLogger.LOGGER.trace("Server " + ClusterController.this.server + " receiving nodeUp from NodeID=" + msg.getNodeID() + ", pair=" + pair);
                }
                if (this.acceptorUsed != null) {
                    ClusterConnection clusterConn = this.acceptorUsed.getClusterConnection();
                    if (clusterConn != null) {
                        String scaleDownGroupName = msg.getScaleDownGroupName();
                        clusterConn.nodeAnnounced(msg.getCurrentEventID(), msg.getNodeID(), msg.getBackupGroupName(), scaleDownGroupName, (Pair<TransportConfiguration, TransportConfiguration>)pair, msg.isBackup());
                    } else {
                        HornetQServerLogger.LOGGER.debug("Cluster connection is null on acceptor = " + this.acceptorUsed);
                    }
                } else {
                    HornetQServerLogger.LOGGER.debug("there is no acceptor used configured at the CoreProtocolManager " + this);
                }
            } else if (packet.getType() == -2) {
                QuorumVoteMessage quorumVoteMessage = (QuorumVoteMessage)packet;
                QuorumVoteHandler voteHandler = ClusterController.this.quorumManager.getVoteHandler(quorumVoteMessage.getHandler());
                quorumVoteMessage.decode(voteHandler);
                Vote vote = ClusterController.this.quorumManager.vote(quorumVoteMessage.getHandler(), quorumVoteMessage.getVote());
                this.clusterChannel.send((Packet)new QuorumVoteReplyMessage(quorumVoteMessage.getHandler(), vote));
            } else if (packet.getType() == -6) {
                ScaleDownAnnounceMessage message = (ScaleDownAnnounceMessage)packet;
                if (ClusterController.this.server.getNodeID().equals((Object)message.getTargetNodeId())) {
                    ClusterController.this.server.addScaledDownNode(message.getScaledDownNodeId());
                }
            } else if (this.channelHandler != null) {
                this.channelHandler.handlePacket(packet);
            }
        }
    }
}

