/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.ha;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;

public class ScaleDownPolicy {
    private List<String> connectors = new ArrayList<String>();
    private String discoveryGroup = null;
    private String groupName = null;
    private String clusterName;
    private boolean enabled;

    public ScaleDownPolicy() {
    }

    public ScaleDownPolicy(List<String> connectors, String groupName, String clusterName, boolean enabled) {
        this.connectors = connectors;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.enabled = enabled;
    }

    public ScaleDownPolicy(String discoveryGroup, String groupName, String clusterName, boolean enabled) {
        this.discoveryGroup = discoveryGroup;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.enabled = enabled;
    }

    public List<String> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(List<String> connectors) {
        this.connectors = connectors;
    }

    public String getDiscoveryGroup() {
        return this.discoveryGroup;
    }

    public void setDiscoveryGroup(String discoveryGroup) {
        this.discoveryGroup = discoveryGroup;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static ServerLocatorInternal getScaleDownConnector(ScaleDownPolicy scaleDownPolicy, HornetQServer hornetQServer) throws HornetQException {
        if (!scaleDownPolicy.getConnectors().isEmpty()) {
            return (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((TransportConfiguration[])ScaleDownPolicy.connectorNameListToArray(scaleDownPolicy.getConnectors(), hornetQServer));
        }
        if (scaleDownPolicy.getDiscoveryGroup() != null) {
            DiscoveryGroupConfiguration dg = hornetQServer.getConfiguration().getDiscoveryGroupConfigurations().get(scaleDownPolicy.getDiscoveryGroup());
            if (dg == null) {
                throw HornetQMessageBundle.BUNDLE.noDiscoveryGroupFound(dg);
            }
            return (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        }
        Map<String, TransportConfiguration> connectorConfigurations = hornetQServer.getConfiguration().getConnectorConfigurations();
        for (TransportConfiguration transportConfiguration : connectorConfigurations.values()) {
            if (!transportConfiguration.getFactoryClassName().equals(InVMConnectorFactory.class.getName())) continue;
            return (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
        }
        throw HornetQMessageBundle.BUNDLE.noConfigurationFoundForScaleDown();
    }

    private static TransportConfiguration[] connectorNameListToArray(List<String> connectorNames, HornetQServer hornetQServer) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = hornetQServer.getConfiguration().getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                HornetQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }
}

