/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.ha;

import java.util.Map;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.server.cluster.ha.BackupPolicy;
import org.hornetq.core.server.cluster.ha.ScaleDownPolicy;
import org.hornetq.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.SharedStoreBackupActivation;

public class SharedStoreSlavePolicy
extends BackupPolicy {
    private long failbackDelay = HornetQDefaultConfiguration.getDefaultFailbackDelay();
    private boolean failoverOnServerShutdown = HornetQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean allowAutoFailBack = HornetQDefaultConfiguration.isDefaultAllowAutoFailback();
    private SharedStoreMasterPolicy sharedStoreMasterPolicy;

    public SharedStoreSlavePolicy() {
    }

    public SharedStoreSlavePolicy(long failbackDelay, boolean failoverOnServerShutdown, boolean restartBackup, boolean allowAutoFailBack, ScaleDownPolicy scaleDownPolicy) {
        this.failbackDelay = failbackDelay;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.restartBackup = restartBackup;
        this.allowAutoFailBack = allowAutoFailBack;
        this.scaleDownPolicy = scaleDownPolicy;
        this.sharedStoreMasterPolicy = new SharedStoreMasterPolicy(failbackDelay, failoverOnServerShutdown);
    }

    public long getFailbackDelay() {
        return this.failbackDelay;
    }

    public void setFailbackDelay(long failbackDelay) {
        this.failbackDelay = failbackDelay;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public SharedStoreMasterPolicy getSharedStoreMasterPolicy() {
        return this.sharedStoreMasterPolicy;
    }

    public void setSharedStoreMasterPolicy(SharedStoreMasterPolicy sharedStoreMasterPolicy) {
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    @Override
    public Activation createActivation(HornetQServerImpl server, boolean wasLive, Map<String, Object> activationParams, HornetQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) {
        return new SharedStoreBackupActivation(server, this);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }
}

