/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.core.server.impl.HornetQServerImpl;

public class AnyLiveNodeLocatorForScaleDown
extends LiveNodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final HornetQServerImpl server;
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> connectors = new TreeMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    private String nodeID;
    private String myNodeID;

    public AnyLiveNodeLocatorForScaleDown(HornetQServerImpl server) {
        this.server = server;
        this.myNodeID = server.getNodeID().toString();
    }

    @Override
    public void locateNode() throws HornetQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws HornetQException {
        block7: {
            try {
                this.lock.lock();
                if (!this.connectors.isEmpty()) break block7;
                try {
                    if (timeout != -1L) {
                        if (!this.condition.await(timeout, TimeUnit.MILLISECONDS)) {
                            throw new HornetQException("Timeout elapsed while waiting for cluster node");
                        }
                        break block7;
                    }
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            Pair connector = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
            if (topologyMember.getNodeId().equals(this.myNodeID)) {
                if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                    HornetQServerLogger.LOGGER.trace(this + "::informing node about itself, nodeUUID=" + this.server.getNodeID() + ", connectorPair=" + topologyMember + ", this = " + this);
                }
                return;
            }
            if (this.server.checkLiveIsNotColocated(topologyMember.getNodeId())) {
                this.connectors.put(topologyMember.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)connector);
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDown(long eventUID, String nodeID) {
        try {
            this.lock.lock();
            this.connectors.remove(nodeID);
            if (this.connectors.size() > 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration() {
        try {
            this.lock.lock();
            Iterator<String> iterator = this.connectors.keySet().iterator();
            if (iterator.hasNext()) {
                this.nodeID = iterator.next();
            }
            Pair<TransportConfiguration, TransportConfiguration> pair = this.connectors.get(this.nodeID);
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            this.connectors.remove(this.nodeID);
        }
        finally {
            this.lock.unlock();
        }
    }
}

