/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.cluster.ClusterControl;
import org.hornetq.core.server.cluster.ClusterController;
import org.hornetq.core.server.cluster.ha.ReplicaPolicy;
import org.hornetq.core.server.cluster.ha.ScaleDownPolicy;
import org.hornetq.core.server.cluster.qourum.SharedNothingBackupQuorum;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.core.server.impl.AnyLiveNodeLocatorForReplication;
import org.hornetq.core.server.impl.BackupRecoveryJournalLoader;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.JournalLoader;
import org.hornetq.core.server.impl.NamedLiveNodeLocatorForReplication;
import org.hornetq.core.server.impl.NamedNodeIdNodeLocator;
import org.hornetq.core.server.impl.ReplicationError;
import org.hornetq.core.server.impl.SharedNothingLiveActivation;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.utils.ReusableLatch;

public final class SharedNothingBackupActivation
extends Activation {
    private ReplicaPolicy replicaPolicy;
    private ReplicationEndpoint replicationEndpoint;
    private final HornetQServerImpl hornetQServer;
    private SharedNothingBackupQuorum backupQuorum;
    private final boolean attemptFailBack;
    private final Map<String, Object> activationParams;
    private final HornetQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO;
    private String nodeID;
    ClusterControl clusterControl;
    private boolean closed;
    private volatile boolean backupUpToDate = true;
    private final ReusableLatch backupSyncLatch = new ReusableLatch(0);

    public SharedNothingBackupActivation(HornetQServerImpl hornetQServer, boolean attemptFailBack, Map<String, Object> activationParams, HornetQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO, ReplicaPolicy replicaPolicy) {
        this.hornetQServer = hornetQServer;
        this.attemptFailBack = attemptFailBack;
        this.activationParams = activationParams;
        this.shutdownOnCriticalIO = shutdownOnCriticalIO;
        this.replicaPolicy = replicaPolicy;
        this.backupSyncLatch.setCount(1);
    }

    public void init() throws Exception {
        assert (this.replicationEndpoint == null);
        this.hornetQServer.resetNodeManager();
        this.backupUpToDate = false;
        this.replicationEndpoint = new ReplicationEndpoint(this.hornetQServer, this.shutdownOnCriticalIO, this.attemptFailBack, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SharedNothingBackupQuorum.BACKUP_ACTIVATION signal;
            LiveNodeLocator nodeLocator;
            boolean scalingDown;
            Object object = this.hornetQServer;
            synchronized (object) {
                this.hornetQServer.setState(HornetQServerImpl.SERVER_STATE.STARTED);
            }
            this.hornetQServer.getNodeManager().stop();
            this.hornetQServer.moveServerData();
            this.hornetQServer.getNodeManager().start();
            object = this;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
            }
            boolean bl = scalingDown = this.replicaPolicy.getScaleDownPolicy() != null && this.replicaPolicy.getScaleDownPolicy().isEnabled();
            if (!this.hornetQServer.initialisePart1(scalingDown)) {
                return;
            }
            SharedNothingBackupActivation sharedNothingBackupActivation = this;
            synchronized (sharedNothingBackupActivation) {
                if (this.closed) {
                    return;
                }
                this.backupQuorum = new SharedNothingBackupQuorum(this.hornetQServer.getStorageManager(), this.hornetQServer.getNodeManager(), this.hornetQServer.getScheduledPool());
                this.hornetQServer.getClusterManager().getQuorumManager().registerQuorum(this.backupQuorum);
            }
            if (this.activationParams.get("REPLICATION_ENDPOINT") != null) {
                TopologyMember member = (TopologyMember)this.activationParams.get("REPLICATION_ENDPOINT");
                nodeLocator = new NamedNodeIdNodeLocator(member.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)new Pair((Object)member.getLive(), (Object)member.getBackup()));
            } else {
                nodeLocator = this.replicaPolicy.getGroupName() == null ? new AnyLiveNodeLocatorForReplication(this.backupQuorum, this.hornetQServer) : new NamedLiveNodeLocatorForReplication(this.replicaPolicy.getGroupName(), this.backupQuorum);
            }
            ClusterController clusterController = this.hornetQServer.getClusterManager().getClusterController();
            clusterController.addClusterTopologyListenerForReplication(nodeLocator);
            clusterController.awaitConnectionToReplicationCluster();
            clusterController.addIncomingInterceptorForReplication(new ReplicationError(this.hornetQServer, nodeLocator));
            this.hornetQServer.getBackupManager().start();
            this.replicationEndpoint.setBackupQuorum(this.backupQuorum);
            this.replicationEndpoint.setExecutor(this.hornetQServer.getExecutorFactory().getExecutor());
            EndpointConnector endpointConnector = new EndpointConnector();
            HornetQServerLogger.LOGGER.backupServerStarted(this.hornetQServer.getVersion().getFullVersion(), this.hornetQServer.getNodeManager().getNodeId());
            this.hornetQServer.setState(HornetQServerImpl.SERVER_STATE.STARTED);
            do {
                block37: {
                    nodeLocator.locateNode();
                    if (this.closed) {
                        return;
                    }
                    Pair<TransportConfiguration, TransportConfiguration> possibleLive = nodeLocator.getLiveConfiguration();
                    this.nodeID = nodeLocator.getNodeID();
                    if (!this.attemptFailBack) {
                        if (this.nodeID == null) {
                            throw new RuntimeException("Could not establish the connection");
                        }
                        this.hornetQServer.getNodeManager().setNodeID(this.nodeID);
                    }
                    try {
                        this.clusterControl = clusterController.connectToNodeInReplicatedCluster((TransportConfiguration)possibleLive.getA());
                    }
                    catch (Exception e) {
                        if (possibleLive.getB() == null) break block37;
                        try {
                            this.clusterControl = clusterController.connectToNodeInReplicatedCluster((TransportConfiguration)possibleLive.getB());
                        }
                        catch (Exception e1) {
                            this.clusterControl = null;
                        }
                    }
                }
                if (this.clusterControl == null) {
                    Thread.sleep(clusterController.getRetryIntervalForReplicatedCluster());
                    signal = SharedNothingBackupQuorum.BACKUP_ACTIVATION.ALREADY_REPLICATING;
                    continue;
                }
                this.hornetQServer.getThreadPool().execute(endpointConnector);
                signal = this.backupQuorum.waitForStatusChange();
                HornetQServerImpl.stopComponent(this.replicationEndpoint);
                if (!this.hornetQServer.isStarted() || signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.STOP) {
                    return;
                }
                if (signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAIL_OVER) break;
                if (signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_REPLICATING) {
                    Thread startThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SharedNothingBackupActivation.this.hornetQServer.stop();
                            }
                            catch (Exception e) {
                                HornetQServerLogger.LOGGER.errorRestartingBackupServer(e, SharedNothingBackupActivation.this.hornetQServer);
                            }
                        }
                    });
                    startThread.start();
                    return;
                }
                this.clusterControl.close();
                this.backupQuorum.reset();
                if (this.replicationEndpoint.getChannel() == null) continue;
                this.replicationEndpoint.getChannel().close();
                this.replicationEndpoint.setChannel(null);
            } while (signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.ALREADY_REPLICATING);
            this.hornetQServer.getClusterManager().getQuorumManager().unRegisterQuorum(this.backupQuorum);
            if (!this.isRemoteBackupUpToDate()) {
                throw HornetQMessageBundle.BUNDLE.backupServerNotInSync();
            }
            this.replicaPolicy.getReplicatedPolicy().setReplicaPolicy(this.replicaPolicy);
            this.hornetQServer.setHAPolicy(this.replicaPolicy.getReplicatedPolicy());
            HornetQServerImpl hornetQServerImpl = this.hornetQServer;
            synchronized (hornetQServerImpl) {
                if (!this.hornetQServer.isStarted()) {
                    return;
                }
                HornetQServerLogger.LOGGER.becomingLive(this.hornetQServer);
                this.hornetQServer.getNodeManager().stopBackup();
                this.hornetQServer.getStorageManager().start();
                this.hornetQServer.getBackupManager().activated();
                if (scalingDown) {
                    this.hornetQServer.initialisePart2(true);
                } else {
                    this.hornetQServer.setActivation(new SharedNothingLiveActivation(this.hornetQServer, this.replicaPolicy.getReplicatedPolicy()));
                    this.hornetQServer.initialisePart2(false);
                    if (this.hornetQServer.getIdentity() != null) {
                        HornetQServerLogger.LOGGER.serverIsLive(this.hornetQServer.getIdentity());
                    } else {
                        HornetQServerLogger.LOGGER.serverIsLive();
                    }
                }
            }
        }
        catch (Exception e) {
            if ((e instanceof InterruptedException || e instanceof IllegalStateException) && !this.hornetQServer.isStarted()) {
                return;
            }
            HornetQServerLogger.LOGGER.initializationError(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        SharedNothingBackupActivation sharedNothingBackupActivation = this;
        synchronized (sharedNothingBackupActivation) {
            if (this.backupQuorum != null) {
                this.backupQuorum.causeExit(SharedNothingBackupQuorum.BACKUP_ACTIVATION.STOP);
            }
            this.replicationEndpoint = null;
            this.closed = true;
        }
        if (this.hornetQServer.getHAPolicy().isBackup()) {
            NodeManager nodeManagerInUse = this.hornetQServer.getNodeManager();
            this.hornetQServer.interrupBackupThread(nodeManagerInUse);
            if (nodeManagerInUse != null) {
                nodeManagerInUse.stopBackup();
            }
        }
    }

    @Override
    public void preStorageClose() throws Exception {
        if (this.replicationEndpoint != null) {
            this.replicationEndpoint.stop();
        }
    }

    @Override
    public JournalLoader createJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, HornetQServer parentServer) throws HornetQException {
        if (this.replicaPolicy.getScaleDownPolicy() != null) {
            return new BackupRecoveryJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer, ScaleDownPolicy.getScaleDownConnector(this.replicaPolicy.getScaleDownPolicy(), this.hornetQServer), this.hornetQServer.getClusterManager().getClusterController());
        }
        return super.createJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer);
    }

    @Override
    public void haStarted() {
        this.hornetQServer.getClusterManager().getClusterController().setReplicatedClusterName(this.replicaPolicy.getClusterName());
    }

    public boolean waitForBackupSync(long timeout, TimeUnit unit) throws InterruptedException {
        return this.backupSyncLatch.await(timeout, unit);
    }

    public void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        if (finalMessage == null) {
            this.backupQuorum.causeExit(SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_REPLICATING);
        } else {
            this.backupQuorum.failOver(finalMessage);
        }
    }

    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    public boolean isRemoteBackupUpToDate() {
        return this.backupUpToDate;
    }

    public void setRemoteBackupUpToDate() {
        this.hornetQServer.getBackupManager().announceBackup();
        this.backupUpToDate = true;
        this.backupSyncLatch.countDown();
    }

    public void remoteFailOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) throws HornetQException {
        HornetQServerLogger.LOGGER.trace("Remote fail-over, got message=" + (Object)((Object)finalMessage) + ", backupUpToDate=" + this.backupUpToDate);
        if (!this.hornetQServer.getHAPolicy().isBackup() || this.hornetQServer.getHAPolicy().isSharedStore()) {
            throw new HornetQInternalErrorException();
        }
        if (!this.backupUpToDate) {
            this.failOver(null);
        } else {
            this.failOver(finalMessage);
        }
    }

    private class EndpointConnector
    implements Runnable {
        private EndpointConnector() {
        }

        @Override
        public void run() {
            try {
                SharedNothingBackupActivation.this.clusterControl.getSessionFactory().setReconnectAttempts(1);
                SharedNothingBackupActivation.this.backupQuorum.setSessionFactory(SharedNothingBackupActivation.this.clusterControl.getSessionFactory());
                SharedNothingBackupActivation.this.clusterControl.authorize();
                this.connectToReplicationEndpoint(SharedNothingBackupActivation.this.clusterControl);
                SharedNothingBackupActivation.this.replicationEndpoint.start();
                SharedNothingBackupActivation.this.clusterControl.announceReplicatingBackupToLive(SharedNothingBackupActivation.this.attemptFailBack, SharedNothingBackupActivation.this.replicaPolicy.getClusterName());
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.replicationStartProblem(e);
                SharedNothingBackupActivation.this.backupQuorum.causeExit(SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_REPLICATING);
            }
        }

        private synchronized ReplicationEndpoint connectToReplicationEndpoint(ClusterControl control) throws Exception {
            if (!SharedNothingBackupActivation.this.hornetQServer.isStarted()) {
                return null;
            }
            if (!SharedNothingBackupActivation.this.hornetQServer.getHAPolicy().isBackup()) {
                throw HornetQMessageBundle.BUNDLE.serverNotBackupServer();
            }
            Channel replicationChannel = control.createReplicationChannel();
            replicationChannel.setHandler((ChannelHandler)SharedNothingBackupActivation.this.replicationEndpoint);
            if (SharedNothingBackupActivation.this.replicationEndpoint.getChannel() != null) {
                throw HornetQMessageBundle.BUNDLE.alreadyHaveReplicationServer();
            }
            SharedNothingBackupActivation.this.replicationEndpoint.setChannel(replicationChannel);
            return SharedNothingBackupActivation.this.replicationEndpoint;
        }
    }
}

