/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.address.MultipleRecipientInfo;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.util.XmppStringUtils;

public class MultipleRecipientManager {
    public static void send(XMPPConnection connection, Stanza packet, Collection<String> to, Collection<String> cc, Collection<String> bcc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException {
        MultipleRecipientManager.send(connection, packet, to, cc, bcc, null, null, false);
    }

    public static void send(XMPPConnection connection, Stanza packet, Collection<String> to, Collection<String> cc, Collection<String> bcc, String replyTo, String replyRoom, boolean noReply) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException {
        if (to != null && to.size() == 1 && (cc == null || cc.isEmpty()) && (bcc == null || bcc.isEmpty()) && !noReply && StringUtils.isNullOrEmpty((CharSequence)replyTo) && StringUtils.isNullOrEmpty((CharSequence)replyRoom)) {
            String toJid = to.iterator().next();
            packet.setTo(toJid);
            connection.sendPacket(packet);
            return;
        }
        String serviceAddress = MultipleRecipientManager.getMultipleRecipienServiceAddress(connection);
        if (serviceAddress != null) {
            MultipleRecipientManager.sendThroughService(connection, packet, to, cc, bcc, replyTo, replyRoom, noReply, serviceAddress);
        } else {
            if (noReply || replyTo != null && replyTo.trim().length() > 0 || replyRoom != null && replyRoom.trim().length() > 0) {
                throw new SmackException.FeatureNotSupportedException("Extended Stanza Addressing");
            }
            MultipleRecipientManager.sendToIndividualRecipients(connection, packet, to, cc, bcc);
        }
    }

    public static void reply(XMPPConnection connection, Message original, Message reply) throws SmackException, XMPPException.XMPPErrorException {
        MultipleAddresses.Address replyAddress;
        MultipleRecipientInfo info = MultipleRecipientManager.getMultipleRecipientInfo((Stanza)original);
        if (info == null) {
            throw new SmackException("Original message does not contain multiple recipient info");
        }
        if (info.shouldNotReply()) {
            throw new SmackException("Original message should not be replied");
        }
        if (info.getReplyRoom() != null) {
            throw new SmackException("Reply should be sent through a room");
        }
        if (original.getThread() != null) {
            reply.setThread(original.getThread());
        }
        if ((replyAddress = info.getReplyAddress()) != null && replyAddress.getJid() != null) {
            reply.setTo(replyAddress.getJid());
            connection.sendPacket((Stanza)reply);
        } else {
            String from;
            ArrayList<String> to = new ArrayList<String>(info.getTOAddresses().size());
            ArrayList<String> cc = new ArrayList<String>(info.getCCAddresses().size());
            for (MultipleAddresses.Address jid : info.getTOAddresses()) {
                to.add(jid.getJid());
            }
            for (MultipleAddresses.Address jid : info.getCCAddresses()) {
                cc.add(jid.getJid());
            }
            if (!to.contains(original.getFrom()) && !cc.contains(original.getFrom())) {
                to.add(original.getFrom());
            }
            if (!to.remove(from = connection.getUser()) && !cc.remove(from)) {
                String bareJID = XmppStringUtils.parseBareJid((String)from);
                to.remove(bareJID);
                cc.remove(bareJID);
            }
            MultipleRecipientManager.send(connection, (Stanza)reply, to, cc, null, null, null, false);
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Stanza packet) {
        MultipleAddresses extension = (MultipleAddresses)packet.getExtension("addresses", "http://jabber.org/protocol/address");
        return extension == null ? null : new MultipleRecipientInfo(extension);
    }

    private static void sendToIndividualRecipients(XMPPConnection connection, Stanza packet, Collection<String> to, Collection<String> cc, Collection<String> bcc) throws SmackException.NotConnectedException {
        if (to != null) {
            for (String jid : to) {
                packet.setTo(jid);
                connection.sendPacket((Stanza)new PacketCopy(packet.toXML()));
            }
        }
        if (cc != null) {
            for (String jid : cc) {
                packet.setTo(jid);
                connection.sendPacket((Stanza)new PacketCopy(packet.toXML()));
            }
        }
        if (bcc != null) {
            for (String jid : bcc) {
                packet.setTo(jid);
                connection.sendPacket((Stanza)new PacketCopy(packet.toXML()));
            }
        }
    }

    private static void sendThroughService(XMPPConnection connection, Stanza packet, Collection<String> to, Collection<String> cc, Collection<String> bcc, String replyTo, String replyRoom, boolean noReply, String serviceAddress) throws SmackException.NotConnectedException {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (to != null) {
            for (String jid : to) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, jid, null, null, false, null);
            }
        }
        if (cc != null) {
            for (String jid : cc) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, jid, null, null, false, null);
            }
        }
        if (bcc != null) {
            for (String jid : bcc) {
                multipleAddresses.addAddress(MultipleAddresses.Type.bcc, jid, null, null, false, null);
            }
        }
        if (noReply) {
            multipleAddresses.setNoReply();
        } else {
            if (replyTo != null && replyTo.trim().length() > 0) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyto, replyTo, null, null, false, null);
            }
            if (replyRoom != null && replyRoom.trim().length() > 0) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyroom, replyRoom, null, null, false, null);
            }
        }
        packet.setTo(serviceAddress);
        packet.addExtension((PacketExtension)multipleAddresses);
        connection.sendPacket(packet);
    }

    private static String getMultipleRecipienServiceAddress(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        List<String> services = sdm.findServices("http://jabber.org/protocol/address", true, true);
        if (services.size() > 0) {
            return services.get(0);
        }
        return null;
    }

    private static class PacketCopy
    extends Stanza {
        private CharSequence text;

        public PacketCopy(CharSequence text) {
            this.text = text;
        }

        public CharSequence toXML() {
            return this.text;
        }
    }
}

