/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    private XMPPConnection connection;
    private Socks5BytestreamManager manager;

    Socks5TransferNegotiator(XMPPConnection connection) {
        this.connection = connection;
        this.manager = Socks5BytestreamManager.getBytestreamManager(this.connection);
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws SmackException.NoResponseException, SmackException, XMPPException {
        try {
            return this.manager.establishSession(target, streamID).getOutputStream();
        }
        catch (IOException e) {
            throw new SmackException("error establishing SOCKS5 Bytestream", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SmackException("error establishing SOCKS5 Bytestream", (Throwable)e);
        }
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException.XMPPErrorException, InterruptedException, SmackException {
        this.manager.ignoreBytestreamRequestOnce(initiation.getSessionID());
        Stanza streamInitiation = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(streamInitiation);
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        this.manager.ignoreBytestreamRequestOnce(streamID);
        return new AndFilter(new PacketFilter[]{FromMatchesFilter.create((String)from), new BytestreamSIDFilter(streamID)});
    }

    @Override
    public String[] getNamespaces() {
        return new String[]{"http://jabber.org/protocol/bytestreams"};
    }

    @Override
    InputStream negotiateIncomingStream(Stanza streamInitiation) throws InterruptedException, SmackException, XMPPException.XMPPErrorException {
        ByteStreamRequest request = new ByteStreamRequest(this.manager, (Bytestream)streamInitiation);
        Socks5BytestreamSession session = request.accept();
        try {
            PushbackInputStream stream = new PushbackInputStream(session.getInputStream());
            int firstByte = stream.read();
            stream.unread(firstByte);
            return stream;
        }
        catch (IOException e) {
            throw new SmackException("Error establishing input stream", (Throwable)e);
        }
    }

    private static class ByteStreamRequest
    extends Socks5BytestreamRequest {
        private ByteStreamRequest(Socks5BytestreamManager manager, Bytestream byteStreamRequest) {
            super(manager, byteStreamRequest);
        }
    }

    private static class BytestreamSIDFilter
    extends PacketTypeFilter {
        private final String sessionID;

        public BytestreamSIDFilter(String sessionID) {
            super(Bytestream.class);
            this.sessionID = (String)Objects.requireNonNull((Object)sessionID, (String)"SessionID cannot be null");
        }

        public boolean accept(Stanza packet) {
            if (super.accept(packet)) {
                Bytestream bytestream = (Bytestream)packet;
                return this.sessionID.equals(bytestream.getSessionID()) && IQ.Type.set.equals((Object)bytestream.getType());
            }
            return false;
        }
    }
}

