/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqlast;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqlast.packet.LastActivity;

public class LastActivityManager
extends Manager {
    private static final Map<XMPPConnection, LastActivityManager> instances = new WeakHashMap<XMPPConnection, LastActivityManager>();
    private static boolean enabledPerDefault = true;
    private volatile long lastMessageSent;
    private boolean enabled = false;

    public static void setEnabledPerDefault(boolean enabledPerDefault) {
        LastActivityManager.enabledPerDefault = enabledPerDefault;
    }

    public static synchronized LastActivityManager getInstanceFor(XMPPConnection connection) {
        LastActivityManager lastActivityManager = instances.get(connection);
        if (lastActivityManager == null) {
            lastActivityManager = new LastActivityManager(connection);
        }
        return lastActivityManager;
    }

    private LastActivityManager(XMPPConnection connection) {
        super(connection);
        connection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Stanza packet) {
                Presence presence = (Presence)packet;
                Presence.Mode mode = presence.getMode();
                if (mode == null) {
                    return;
                }
                switch (mode) {
                    case available: 
                    case chat: {
                        LastActivityManager.this.resetIdleTime();
                    }
                }
            }
        }, (PacketFilter)PacketTypeFilter.PRESENCE);
        connection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Stanza packet) {
                Message message = (Message)packet;
                if (message.getType() == Message.Type.error) {
                    return;
                }
                LastActivityManager.this.resetIdleTime();
            }
        }, (PacketFilter)PacketTypeFilter.MESSAGE);
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "jabber:iq:last", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                if (!LastActivityManager.this.enabled) {
                    return IQ.createErrorResponse((IQ)iqRequest, (XMPPError)new XMPPError(XMPPError.Condition.not_acceptable));
                }
                LastActivity message = new LastActivity();
                message.setType(IQ.Type.result);
                message.setTo(iqRequest.getFrom());
                message.setFrom(iqRequest.getTo());
                message.setStanzaId(iqRequest.getStanzaId());
                message.setLastActivity(LastActivityManager.this.getIdleTime());
                return message;
            }
        });
        if (enabledPerDefault) {
            this.enable();
        }
        this.resetIdleTime();
        instances.put(connection, this);
    }

    public synchronized void enable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).addFeature("jabber:iq:last");
        this.enabled = true;
    }

    public synchronized void disable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).removeFeature("jabber:iq:last");
        this.enabled = false;
    }

    private void resetIdleTime() {
        this.lastMessageSent = System.currentTimeMillis();
    }

    private long getIdleTime() {
        long lms = this.lastMessageSent;
        long now = System.currentTimeMillis();
        return (now - lms) / 1000L;
    }

    public LastActivity getLastActivity(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        LastActivity activity = new LastActivity(jid);
        return (LastActivity)this.connection().createPacketCollectorAndSend((IQ)activity).nextResultOrThrow();
    }

    public boolean isLastActivitySupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "jabber:iq:last");
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                LastActivityManager.getInstanceFor(connection);
            }
        });
    }
}

