/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.packet.MUCUser;

public class MultiUserChatManager
extends Manager {
    private static final String DISCO_NODE = "http://jabber.org/protocol/muc#rooms";
    private static final Map<XMPPConnection, MultiUserChatManager> INSTANCES;
    private static final PacketFilter INVITATION_FILTER;
    private final Set<InvitationListener> invitationsListeners = new CopyOnWriteArraySet<InvitationListener>();
    private final Set<String> joinedRooms = new HashSet<String>();
    private final Map<String, WeakReference<MultiUserChat>> multiUserChats = new HashMap<String, WeakReference<MultiUserChat>>();

    public static synchronized MultiUserChatManager getInstanceFor(XMPPConnection connection) {
        MultiUserChatManager multiUserChatManager = INSTANCES.get(connection);
        if (multiUserChatManager == null) {
            multiUserChatManager = new MultiUserChatManager(connection);
            INSTANCES.put(connection, multiUserChatManager);
        }
        return multiUserChatManager;
    }

    private MultiUserChatManager(XMPPConnection connection) {
        super(connection);
        PacketListener invitationPacketListener = new PacketListener(){

            public void processPacket(Stanza packet) {
                Message message = (Message)packet;
                MUCUser mucUser = MUCUser.from((Stanza)message);
                if (mucUser.getInvite() != null) {
                    MultiUserChat muc = MultiUserChatManager.this.getMultiUserChat(packet.getFrom());
                    for (InvitationListener listener : MultiUserChatManager.this.invitationsListeners) {
                        listener.invitationReceived(MultiUserChatManager.this.connection(), muc, mucUser.getInvite().getFrom(), mucUser.getInvite().getReason(), mucUser.getPassword(), message);
                    }
                }
            }
        };
        connection.addAsyncPacketListener(invitationPacketListener, INVITATION_FILTER);
    }

    public synchronized MultiUserChat getMultiUserChat(String jid) {
        WeakReference<MultiUserChat> weakRefMultiUserChat = this.multiUserChats.get(jid);
        if (weakRefMultiUserChat == null) {
            return this.createNewMucAndAddToMap(jid);
        }
        MultiUserChat multiUserChat = (MultiUserChat)weakRefMultiUserChat.get();
        if (multiUserChat == null) {
            return this.createNewMucAndAddToMap(jid);
        }
        return multiUserChat;
    }

    private MultiUserChat createNewMucAndAddToMap(String jid) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection(), jid, this);
        this.multiUserChats.put(jid, new WeakReference<MultiUserChat>(multiUserChat));
        return multiUserChat;
    }

    public boolean isServiceEnabled(String user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(user, "http://jabber.org/protocol/muc");
    }

    public Set<String> getJoinedRooms() {
        return Collections.unmodifiableSet(this.joinedRooms);
    }

    public List<String> getJoinedRooms(String user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems result = ServiceDiscoveryManager.getInstanceFor(this.connection()).discoverItems(user, DISCO_NODE);
        List<DiscoverItems.Item> items = result.getItems();
        ArrayList<String> answer = new ArrayList<String>(items.size());
        for (DiscoverItems.Item item : items) {
            answer.add(item.getEntityID());
        }
        return answer;
    }

    public RoomInfo getRoomInfo(String room) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(this.connection()).discoverInfo(room);
        return new RoomInfo(info);
    }

    public List<String> getServiceNames() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return sdm.findServices("http://jabber.org/protocol/muc", false, false);
    }

    public List<HostedRoom> getHostedRooms(String serviceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        DiscoverItems discoverItems = discoManager.discoverItems(serviceName);
        List<DiscoverItems.Item> items = discoverItems.getItems();
        ArrayList<HostedRoom> answer = new ArrayList<HostedRoom>(items.size());
        for (DiscoverItems.Item item : items) {
            answer.add(new HostedRoom(item));
        }
        return answer;
    }

    public void decline(String room, String inviter, String reason) throws SmackException.NotConnectedException {
        Message message = new Message(room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(inviter);
        decline.setReason(reason);
        mucUser.setDecline(decline);
        message.addExtension((PacketExtension)mucUser);
        this.connection().sendPacket((Stanza)message);
    }

    public void addInvitationListener(InvitationListener listener) {
        this.invitationsListeners.add(listener);
    }

    public void removeInvitationListener(InvitationListener listener) {
        this.invitationsListeners.remove(listener);
    }

    void addJoinedRoom(String room) {
        this.joinedRooms.add(room);
    }

    void removeJoinedRoom(String room) {
        this.joinedRooms.remove(room);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature("http://jabber.org/protocol/muc");
                final WeakReference<XMPPConnection> weakRefConnection = new WeakReference<XMPPConnection>(connection);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChatManager.DISCO_NODE, new AbstractNodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        XMPPConnection connection = (XMPPConnection)weakRefConnection.get();
                        if (connection == null) {
                            return Collections.emptyList();
                        }
                        Set<String> joinedRooms = MultiUserChatManager.getInstanceFor(connection).getJoinedRooms();
                        ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                        for (String room : joinedRooms) {
                            answer.add(new DiscoverItems.Item(room));
                        }
                        return answer;
                    }
                });
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, MultiUserChatManager>();
        INVITATION_FILTER = new AndFilter(new PacketFilter[]{PacketTypeFilter.MESSAGE, new PacketExtensionFilter((PacketExtension)new MUCUser()), new NotFilter(MessageTypeFilter.ERROR)});
    }
}

