/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class AddOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(AddOperation.class, Log.class);
    private final long delta;

    public AddOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName, long delta, boolean useConsistentHash) {
        super((short)82, (short)83, codec, channelFactory, topologyId, cfg, counterName, useConsistentHash);
        this.delta = delta;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 8);
        buf.writeLong(this.delta);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        this.complete(buf.readLong());
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.delta > 0L) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

