/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.stream.Collectors;

public final class JVMMemoryInfoInfo {
    private static MemoryMXBean memoryMBean;
    private static List<MemoryPoolMXBean> memoryPoolMBeans;
    private static List<BufferPoolMXBean> bufferPoolsMBeans;
    private static List<GarbageCollectorMXBean> garbageCollectorMXBeans;

    public JVMMemoryInfoInfo() {
        garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        memoryMBean = ManagementFactory.getMemoryMXBean();
        memoryPoolMBeans = ManagementFactory.getMemoryPoolMXBeans();
        bufferPoolsMBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    }

    public List<MemoryManager> getGc() {
        return garbageCollectorMXBeans.stream().map(MemoryManager::new).collect(Collectors.toList());
    }

    public List<MemoryPool> getMemoryPools() {
        return memoryPoolMBeans.stream().map(MemoryPool::new).collect(Collectors.toList());
    }

    public List<BufferPool> getBufferPools() {
        return bufferPoolsMBeans.stream().map(BufferPool::new).collect(Collectors.toList());
    }

    public MemoryUsage getHeap() {
        return memoryMBean.getHeapMemoryUsage();
    }

    public MemoryUsage getNonHeap() {
        return memoryMBean.getNonHeapMemoryUsage();
    }

    private static class MemoryManager {
        private final String name;
        private final String[] memoryPoolNames;
        private final boolean valid;
        private final long collectionCount;
        private final long collectionTime;

        MemoryManager(GarbageCollectorMXBean memoryManagerMXBean) {
            this.name = memoryManagerMXBean.getName();
            this.memoryPoolNames = memoryManagerMXBean.getMemoryPoolNames();
            this.valid = memoryManagerMXBean.isValid();
            this.collectionCount = memoryManagerMXBean.getCollectionCount();
            this.collectionTime = memoryManagerMXBean.getCollectionTime();
        }

        public long getCollectionCount() {
            return this.collectionCount;
        }

        public long getCollectionTime() {
            return this.collectionTime;
        }

        public String getName() {
            return this.name;
        }

        public String[] getMemoryPoolNames() {
            return this.memoryPoolNames;
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    private static class MemoryPool {
        private final String name;
        private final MemoryType type;
        private final MemoryUsage usage;
        private final MemoryUsage peakUsage;

        MemoryPool(MemoryPoolMXBean memoryPoolMXBean) {
            this.name = memoryPoolMXBean.getName();
            this.type = memoryPoolMXBean.getType();
            this.usage = memoryPoolMXBean.getUsage();
            this.peakUsage = memoryPoolMXBean.getPeakUsage();
        }

        public String getName() {
            return this.name;
        }

        public MemoryType getType() {
            return this.type;
        }

        public MemoryUsage getUsage() {
            return this.usage;
        }

        public MemoryUsage getPeakUsage() {
            return this.peakUsage;
        }
    }

    private static class BufferPool {
        private final long memoryUsed;
        private final String name;
        private final long totalCapacity;
        private final long count;

        BufferPool(BufferPoolMXBean bufferPoolMXBean) {
            this.memoryUsed = bufferPoolMXBean.getMemoryUsed();
            this.name = bufferPoolMXBean.getName();
            this.totalCapacity = bufferPoolMXBean.getTotalCapacity();
            this.count = bufferPoolMXBean.getCount();
        }

        public long getMemoryUsed() {
            return this.memoryUsed;
        }

        public String getName() {
            return this.name;
        }

        public long getTotalCapacity() {
            return this.totalCapacity;
        }

        public long getCount() {
            return this.count;
        }
    }
}

