/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACLookupStrategy;
import org.italiangrid.voms.ac.VOMSACValidationStrategy;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.ac.ValidationResultListener;
import org.italiangrid.voms.ac.impl.DefaultVOMSACParser;
import org.italiangrid.voms.ac.impl.DefaultVOMSValidationStrategy;
import org.italiangrid.voms.ac.impl.LeafACLookupStrategy;
import org.italiangrid.voms.asn1.VOMSACUtils;
import org.italiangrid.voms.store.UpdatingVOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStores;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.italiangrid.voms.util.NullListener;

public class DefaultVOMSValidator
extends DefaultVOMSACParser
implements VOMSACValidator {
    public static final String DEFAULT_TRUST_ANCHORS_DIR = "/etc/grid-security/certificates";
    private final VOMSACValidationStrategy validationStrategy;
    private final VOMSTrustStore trustStore;
    private ValidationResultListener validationResultListener;
    private final Object listenerLock = new Object();

    private DefaultVOMSValidator(Builder b) {
        super(b.acLookupStrategy);
        this.validationStrategy = b.validationStrategy;
        this.trustStore = b.trustStore;
        this.validationResultListener = b.validationResultListener;
    }

    @Override
    public List<VOMSValidationResult> validateWithResult(X509Certificate[] validatedChain) {
        return this.internalValidate(validatedChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<VOMSValidationResult> internalValidate(X509Certificate[] validatedChain) {
        List<VOMSAttribute> parsedAttrs = this.parse(validatedChain);
        ArrayList<VOMSValidationResult> results = new ArrayList<VOMSValidationResult>();
        for (VOMSAttribute a : parsedAttrs) {
            VOMSValidationResult result = this.validationStrategy.validateAC(a, validatedChain);
            Object object = this.listenerLock;
            synchronized (object) {
                this.validationResultListener.notifyValidationResult(result);
            }
            results.add(result);
        }
        return results;
    }

    @Override
    public List<VOMSAttribute> validate(X509Certificate[] validatedChain) {
        ArrayList<VOMSAttribute> validAttributes = new ArrayList<VOMSAttribute>();
        for (VOMSValidationResult result : this.internalValidate(validatedChain)) {
            if (!result.isValid()) continue;
            validAttributes.add(result.getAttributes());
        }
        return validAttributes;
    }

    @Override
    public void shutdown() {
        if (this.trustStore instanceof UpdatingVOMSTrustStore) {
            ((UpdatingVOMSTrustStore)this.trustStore).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttributeCertificate> validateACs(List<AttributeCertificate> acs) {
        ArrayList<AttributeCertificate> validatedAcs = new ArrayList<AttributeCertificate>();
        for (AttributeCertificate ac : acs) {
            VOMSAttribute vomsAttrs = VOMSACUtils.deserializeVOMSAttributes(ac);
            VOMSValidationResult result = this.validationStrategy.validateAC(vomsAttrs);
            Object object = this.listenerLock;
            synchronized (object) {
                this.validationResultListener.notifyValidationResult(result);
            }
            if (!result.isValid()) continue;
            validatedAcs.add(ac);
        }
        return validatedAcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValidationResultListener(ValidationResultListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (listener != null) {
                this.validationResultListener = listener;
            }
        }
    }

    public static class Builder {
        private VOMSACValidationStrategy validationStrategy;
        private VOMSTrustStore trustStore;
        private ValidationResultListener validationResultListener;
        private X509CertChainValidatorExt certChainValidator;
        private VOMSACLookupStrategy acLookupStrategy;

        public Builder validationStrategy(VOMSACValidationStrategy s) {
            this.validationStrategy = s;
            return this;
        }

        public Builder trustStore(VOMSTrustStore ts) {
            this.trustStore = ts;
            return this;
        }

        public Builder validationListener(ValidationResultListener l) {
            this.validationResultListener = l;
            return this;
        }

        public Builder certChainValidator(X509CertChainValidatorExt v) {
            this.certChainValidator = v;
            return this;
        }

        public Builder acLookupStrategy(VOMSACLookupStrategy ls) {
            this.acLookupStrategy = ls;
            return this;
        }

        private void sanityChecks() {
            if (this.validationStrategy == null) {
                if (this.trustStore == null) {
                    this.trustStore = VOMSTrustStores.newTrustStore();
                }
                if (this.certChainValidator == null) {
                    this.certChainValidator = new CertificateValidatorBuilder().trustAnchorsDir(DefaultVOMSValidator.DEFAULT_TRUST_ANCHORS_DIR).build();
                }
                this.validationStrategy = new DefaultVOMSValidationStrategy(this.trustStore, this.certChainValidator);
            }
            if (this.validationResultListener == null) {
                this.validationResultListener = NullListener.INSTANCE;
            }
            if (this.acLookupStrategy == null) {
                this.acLookupStrategy = new LeafACLookupStrategy();
            }
        }

        public DefaultVOMSValidator build() {
            this.sanityChecks();
            return new DefaultVOMSValidator(this);
        }
    }
}

