/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.asn1;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.proxy.CertificateExtension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.AttributeCertificateHolder;
import org.bouncycastle.cert.AttributeCertificateIssuer;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509v2AttributeCertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.VOMSGenericAttribute;
import org.italiangrid.voms.asn1.VOMSConstants;

public class VOMSACGenerator
implements VOMSConstants {
    public static final EnumSet<ACGenerationProperties> defaultGenerationProperties = EnumSet.noneOf(ACGenerationProperties.class);
    public static final ASN1ObjectIdentifier FAKE_EXT_OID = new ASN1ObjectIdentifier("1.3.6.1.4.1.8005.100.120.82");
    private X509Credential aaCredential;
    private ContentSigner signer;

    private ContentSigner getSigner(EnumSet<ACGenerationProperties> properties) {
        if (this.signer == null) {
            JcaContentSignerBuilder builder = new JcaContentSignerBuilder(this.aaCredential.getCertificate().getSigAlgName());
            builder.setProvider("BC");
            try {
                this.signer = properties.contains((Object)ACGenerationProperties.FAKE_SIGNATURE_BITS) ? new RandomContentSigner(this.aaCredential.getCertificate().getSigAlgName()) : builder.build(this.aaCredential.getKey());
            }
            catch (OperatorCreationException e) {
                throw new VOMSError(e.getMessage(), e);
            }
        }
        return this.signer;
    }

    public VOMSACGenerator(X509Credential aaCredential) {
        this.aaCredential = aaCredential;
    }

    private String buildVOURI(String voName, String host, int port) {
        return String.format("%s://%s:%d", voName, host, port);
    }

    private ASN1Encodable buildACCertsExtensionContent(EnumSet<ACGenerationProperties> properties) {
        ASN1EncodableVector issuerCertsContainer = new ASN1EncodableVector();
        if (properties.contains((Object)ACGenerationProperties.INCLUDE_EMPTY_AC_CERTS_EXTENSION)) {
            issuerCertsContainer.add((ASN1Encodable)new DERSequence());
        } else {
            issuerCertsContainer.add((ASN1Encodable)new DERSequence(this.getCertAsDEREncodable(this.aaCredential.getCertificate())));
        }
        return new DERSequence(issuerCertsContainer);
    }

    private AuthorityKeyIdentifier buildAuthorityKeyIdentifier() {
        byte[] authKeyId = this.aaCredential.getCertificate().getExtensionValue(Extension.authorityKeyIdentifier.toString());
        if (authKeyId != null) {
            return new AuthorityKeyIdentifier(authKeyId);
        }
        return null;
    }

    private ASN1Encodable buildFQANsAttributeContent(List<String> fqans, GeneralName policyAuthorityInfo) {
        ASN1EncodableVector container = new ASN1EncodableVector();
        ASN1EncodableVector encodedFQANs = new ASN1EncodableVector();
        DERTaggedObject pai = new DERTaggedObject(0, (ASN1Encodable)policyAuthorityInfo);
        container.add((ASN1Encodable)pai);
        for (String s : fqans) {
            encodedFQANs.add((ASN1Encodable)new DEROctetString(s.getBytes()));
        }
        container.add((ASN1Encodable)new DERSequence(encodedFQANs));
        return new DERSequence(container);
    }

    private ASN1Encodable buildGAExtensionContent(EnumSet<ACGenerationProperties> properties, List<VOMSGenericAttribute> gas, GeneralName policyAuthorityInfo) {
        ASN1EncodableVector tagContainer = new ASN1EncodableVector();
        ASN1EncodableVector tagSequences = new ASN1EncodableVector();
        for (VOMSGenericAttribute a : gas) {
            tagSequences.add((ASN1Encodable)this.buildTagSequence(a));
        }
        tagContainer.add((ASN1Encodable)new GeneralNames(policyAuthorityInfo));
        tagContainer.add((ASN1Encodable)new DERSequence(tagSequences));
        DERSequence finalSequence = new DERSequence((ASN1Encodable)new DERSequence((ASN1Encodable)new DERSequence(tagContainer)));
        return finalSequence;
    }

    private AttributeCertificateHolder buildHolder(X509Certificate holderCert) throws CertificateEncodingException {
        JcaX509CertificateHolder holderWrappedCert = new JcaX509CertificateHolder(holderCert);
        AttributeCertificateHolder acHolder = new AttributeCertificateHolder(holderWrappedCert.getSubject(), holderCert.getSerialNumber());
        return acHolder;
    }

    private AttributeCertificateIssuer buildIssuer() throws CertificateEncodingException {
        JcaX509CertificateHolder issuer = new JcaX509CertificateHolder(this.aaCredential.getCertificate());
        return new AttributeCertificateIssuer(issuer.getSubject());
    }

    private GeneralName buildPolicyAuthorityInfo(String voName, String host, int port) {
        return new GeneralName(6, this.buildVOURI(voName, host, port));
    }

    private DERSequence buildTagSequence(VOMSGenericAttribute ga) {
        ASN1EncodableVector tagSequence = new ASN1EncodableVector();
        tagSequence.add((ASN1Encodable)this.getDEROctetString(ga.getName()));
        tagSequence.add((ASN1Encodable)this.getDEROctetString(ga.getValue()));
        tagSequence.add((ASN1Encodable)this.getDEROctetString(ga.getContext()));
        return new DERSequence(tagSequence);
    }

    private ASN1Encodable buildTargetsExtensionContent(EnumSet<ACGenerationProperties> properties, List<String> targets) {
        ASN1EncodableVector targetSeq = new ASN1EncodableVector();
        for (String s : targets) {
            DERTaggedObject encodedTarget = new DERTaggedObject(0, (ASN1Encodable)new GeneralName(6, s));
            targetSeq.add((ASN1Encodable)new DERSequence((ASN1Encodable)encodedTarget));
        }
        DERSequence targetExtensionContent = new DERSequence((ASN1Encodable)new DERSequence(targetSeq));
        return targetExtensionContent;
    }

    public X509AttributeCertificateHolder generateVOMSAttributeCertificate(List<String> fqans, List<VOMSGenericAttribute> gas, List<String> targets, X509Certificate holderCert, BigInteger serialNumber, Date notBefore, Date notAfter, String voName, String host, int port) {
        return this.generateVOMSAttributeCertificate(defaultGenerationProperties, fqans, gas, targets, holderCert, serialNumber, notBefore, notAfter, voName, host, port);
    }

    public X509AttributeCertificateHolder generateVOMSAttributeCertificate(EnumSet<ACGenerationProperties> generationProperties, List<String> fqans, List<VOMSGenericAttribute> gas, List<String> targets, X509Certificate holderCert, BigInteger serialNumber, Date notBefore, Date notAfter, String voName, String host, int port) {
        AttributeCertificateHolder holder = null;
        AttributeCertificateIssuer issuer = null;
        try {
            holder = this.buildHolder(holderCert);
            issuer = this.buildIssuer();
            X509v2AttributeCertificateBuilder builder = new X509v2AttributeCertificateBuilder(holder, issuer, serialNumber, notBefore, notAfter);
            GeneralName policyAuthorityInfo = this.buildPolicyAuthorityInfo(voName, host, port);
            builder.addAttribute(VOMS_FQANS_OID, this.buildFQANsAttributeContent(fqans, policyAuthorityInfo));
            if (gas != null && !gas.isEmpty()) {
                builder.addExtension(VOMS_GENERIC_ATTRS_OID, false, this.buildGAExtensionContent(generationProperties, gas, policyAuthorityInfo));
            }
            if (targets != null && !targets.isEmpty()) {
                builder.addExtension(Extension.targetInformation, true, this.buildTargetsExtensionContent(generationProperties, targets));
            }
            if (!generationProperties.contains((Object)ACGenerationProperties.SKIP_AC_CERTS_EXTENSION)) {
                builder.addExtension(VOMS_CERTS_OID, false, this.buildACCertsExtensionContent(generationProperties));
            }
            if (generationProperties.contains((Object)ACGenerationProperties.INCLUDE_FAKE_CRITICAL_EXTENSION)) {
                builder.addExtension(FAKE_EXT_OID, true, (ASN1Encodable)new DERSequence());
            }
            boolean noRevAvailIsCritical = false;
            boolean akidIsCritical = false;
            if (generationProperties.contains((Object)ACGenerationProperties.INCLUDE_CRITICAL_NO_REV_AVAIL_EXTENSION)) {
                noRevAvailIsCritical = true;
            }
            if (generationProperties.contains((Object)ACGenerationProperties.INCLUDE_CRITICAL_AKID_EXTENSION)) {
                akidIsCritical = true;
            }
            builder.addExtension(Extension.noRevAvail, noRevAvailIsCritical, (ASN1Encodable)DERNull.INSTANCE);
            AuthorityKeyIdentifier akid = this.buildAuthorityKeyIdentifier();
            builder.addExtension(Extension.authorityKeyIdentifier, akidIsCritical, (ASN1Encodable)(akid != null ? akid : DERNull.INSTANCE));
            return builder.build(this.getSigner(generationProperties));
        }
        catch (CertificateEncodingException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        catch (CertIOException e) {
            throw new VOMSError(e.getMessage(), e);
        }
    }

    public CertificateExtension generateVOMSExtension(List<X509AttributeCertificateHolder> acs) {
        ASN1EncodableVector vomsACs = new ASN1EncodableVector();
        for (X509AttributeCertificateHolder ac : acs) {
            vomsACs.add((ASN1Encodable)ac.toASN1Structure());
        }
        DERSequence acSeq = new DERSequence(vomsACs);
        CertificateExtension ext = new CertificateExtension(VOMS_EXTENSION_OID.getId(), (ASN1Object)acSeq.toASN1Primitive(), false);
        return ext;
    }

    private ASN1Encodable getCertAsDEREncodable(X509Certificate cert) {
        try {
            byte[] certBytes = cert.getEncoded();
            ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
            ASN1InputStream is = new ASN1InputStream((InputStream)bais);
            ASN1Primitive derCert = is.readObject();
            is.close();
            return derCert;
        }
        catch (CertificateEncodingException e) {
            throw new VOMSError("Error encoding X509 certificate: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new VOMSError("Error encoding X509 certificate: " + e.getMessage(), e);
        }
    }

    private DEROctetString getDEROctetString(String s) {
        return new DEROctetString(s.getBytes());
    }

    static class RandomContentSigner
    implements ContentSigner {
        public static int SIG_LENGHT = 1024;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        AlgorithmIdentifier sigAlgId;

        public RandomContentSigner(String sigAlgName) {
            this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(sigAlgName);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.sigAlgId;
        }

        public OutputStream getOutputStream() {
            return this.bos;
        }

        public byte[] getSignature() {
            try {
                this.bos.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            Random r = new Random();
            byte[] sigBytes = new byte[SIG_LENGHT];
            r.nextBytes(sigBytes);
            return sigBytes;
        }
    }

    public static enum ACGenerationProperties {
        SKIP_AC_CERTS_EXTENSION,
        FAKE_SIGNATURE_BITS,
        INCLUDE_FAKE_CRITICAL_EXTENSION,
        INCLUDE_CRITICAL_NO_REV_AVAIL_EXTENSION,
        INCLUDE_CRITICAL_AKID_EXTENSION,
        INCLUDE_EMPTY_AC_CERTS_EXTENSION;

    }
}

