/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSProtocol;
import org.italiangrid.voms.request.VOMSProtocolError;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.impl.AbstractVOMSProtocol;
import org.italiangrid.voms.request.impl.LegacyRequestSender;
import org.italiangrid.voms.request.impl.LegacyVOMSResponseParsingStrategy;

public class LegacyProtocol
extends AbstractVOMSProtocol
implements VOMSProtocol,
HostnameMismatchCallback {
    public LegacyProtocol(X509CertChainValidatorExt validator, VOMSProtocolListener listener, int connectTimeout, int readTimeout) {
        super(validator, listener, connectTimeout, readTimeout);
    }

    @Override
    public synchronized VOMSResponse doRequest(VOMSServerInfo endpoint, X509Credential credential, VOMSACRequest request) {
        SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory(credential);
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket)sslSocketFactory.createSocket();
            sslSocket.setSoTimeout(this.readTimeout);
            sslSocket.setEnabledProtocols(VOMS_LEGACY_ENABLED_PROTOCOLS);
            InetSocketAddress sa = new InetSocketAddress(endpoint.getURL().getHost(), endpoint.getURL().getPort());
            sslSocket.connect(sa, this.connectTimeout);
            if (!this.isSkipHostnameChecks()) {
                SocketFactoryCreator.connectWithHostnameChecking((SSLSocket)sslSocket, (HostnameMismatchCallback)this);
            }
        }
        catch (Throwable t) {
            throw new VOMSProtocolError(t.getMessage(), endpoint, request, credential, t);
        }
        LegacyRequestSender protocol = LegacyRequestSender.instance(this.listener);
        VOMSResponse response = null;
        try {
            protocol.sendRequest(request, endpoint, sslSocket.getOutputStream());
            InputStream inputStream = sslSocket.getInputStream();
            response = new LegacyVOMSResponseParsingStrategy().parse(inputStream);
            sslSocket.close();
        }
        catch (IOException e) {
            throw new VOMSProtocolError(e.getMessage(), endpoint, request, credential, e);
        }
        this.listener.notifyReceivedResponse(response);
        return response;
    }

    public void nameMismatch(SSLSocket socket, X509Certificate peerCertificate, String hostName) throws SSLException {
        String peerCertString = CertificateUtils.format((X509Certificate)peerCertificate, (FormatMode)FormatMode.MEDIUM_ONE_LINE);
        String message = String.format("No subject alternative DNS name matching %s found. Peer certificate : %s", hostName, peerCertString);
        throw new SSLException(message);
    }
}

