/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.impl.DefaultVOMSServerInfo;

public class VOMSESLineParser {
    private final ParserState outsideQuotes = new ParserState(){

        @Override
        public void parse(char c) {
            if (c == '\"') {
                VOMSESLineParser.this.tokenStart();
            }
        }
    };
    private final ParserState insideQuotes = new ParserState(){

        @Override
        public void parse(char c) {
            if (c == '\"') {
                VOMSESLineParser.this.tokenEnd();
            } else {
                VOMSESLineParser.this.tokenChar(c);
            }
        }
    };
    static final String[] VOMSES_FIELD_NAMES = new String[]{"vo alias", "voms host", "voms port", "voms server DN", "vo name", "globus version"};
    static final int VO_ALIAS = 0;
    static final int VOMS_HOST = 1;
    static final int VOMS_PORT = 2;
    static final int VOMS_SERVER_DN = 3;
    static final int VO_NAME = 4;
    static final int GLOBUS_VERSION = 5;
    static final int MIN_VOMSES_FIELD_COUNT = 4;
    private String[] tokens = new String[VOMSES_FIELD_NAMES.length];
    private StringBuilder currentToken;
    private int tokenCount;
    private boolean tokenComplete;
    private ParserState currentState;

    private void lineSanityChecks(String line) {
        if (line == null) {
            throw new VOMSError("Cannot parse a null VOMSES line");
        }
    }

    private void init() {
        this.tokenCount = -1;
        this.currentToken = null;
        this.tokenComplete = false;
        this.currentState = this.outsideQuotes;
        for (int i = 0; i < this.tokens.length; ++i) {
            this.tokens[i] = null;
        }
    }

    public VOMSServerInfo parse(String line) {
        this.init();
        this.lineSanityChecks(line);
        if (line.isEmpty()) {
            return null;
        }
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            this.currentState.parse(c);
        }
        if (!this.tokenComplete) {
            String msg = String.format("Invalid VOMSES line: incomplete '%s' field. [line: %s]", VOMSES_FIELD_NAMES[this.tokenCount], line);
            throw new VOMSError(msg);
        }
        if (this.tokenCount < 4) {
            String msg = String.format("Invalid VOMSES line: incomplete information. [line: %s]", line);
            throw new VOMSError(msg);
        }
        DefaultVOMSServerInfo si = new DefaultVOMSServerInfo();
        si.setAlias(this.tokens[0]);
        String url = String.format("voms://%s:%s", this.tokens[1], this.tokens[2]);
        this.validateTokens(line);
        try {
            si.setURL(new URI(url));
            si.setVOMSServerDN(this.tokens[3]);
            si.setVoName(this.tokens[4]);
            return si;
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid VOMSES line: cannot build URL for voms service: %s", e.getMessage());
            throw new VOMSError(msg);
        }
    }

    private void validateTokens(String line) {
        try {
            int portNo = Integer.parseInt(this.tokens[2]);
            if (portNo <= 0 || portNo > 65535) {
                String msg = String.format("Invalid VOMSES line: invalid port number: %d. [line: %s]", portNo, line);
                throw new VOMSError(msg);
            }
        }
        catch (NumberFormatException e) {
            String msg = String.format("Invalid VOMSES line: invalid port number. [line: %s]. Error: %s", line, e.getMessage());
            throw new VOMSError(msg, e);
        }
    }

    public void tokenStart() {
        if (++this.tokenCount == VOMSES_FIELD_NAMES.length) {
            throw new VOMSError("Invalid VOMSES line: too many fields!");
        }
        this.currentToken = new StringBuilder();
        this.currentState = this.insideQuotes;
        this.tokenComplete = false;
    }

    public void tokenEnd() {
        if (this.currentToken.length() == 0) {
            String msg = String.format("Invalid VOMSES line: empty '%s' field.", VOMSES_FIELD_NAMES[this.tokenCount]);
            throw new VOMSError(msg);
        }
        this.tokens[this.tokenCount] = this.currentToken.toString();
        this.currentState = this.outsideQuotes;
        this.tokenComplete = true;
    }

    public void tokenChar(char c) {
        this.currentToken.append(c);
    }

    private static interface ParserState {
        public void parse(char var1);
    }
}

