/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.jasig.schedassist.impl.caldav.CredentialsProviderFactory;
import org.jasig.schedassist.impl.caldav.DefaultCredentialsProviderImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultCredentialsProviderFactoryImpl
implements CredentialsProviderFactory {
    private String caldavAdminUsername;
    private String caldavAdminPassword;
    private AuthScope authScope;

    @Value(value="${caldav.admin.username}")
    public void setCaldavAdminUsername(String caldavAdminUsername) {
        this.caldavAdminUsername = caldavAdminUsername;
    }

    @Value(value="${caldav.admin.password}")
    public void setCaldavAdminPassword(String caldavAdminPassword) {
        this.caldavAdminPassword = caldavAdminPassword;
    }

    protected String getCaldavAdminUsername() {
        return this.caldavAdminUsername;
    }

    protected String getCaldavAdminPassword() {
        return this.caldavAdminPassword;
    }

    public AuthScope getAuthScope() {
        return this.authScope;
    }

    @Autowired
    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    protected Credentials getAdminCredentials() {
        return new UsernamePasswordCredentials(this.getCaldavAdminUsername(), this.getCaldavAdminPassword());
    }

    @Override
    public CredentialsProvider getCredentialsProvider(ICalendarAccount account) {
        DefaultCredentialsProviderImpl provider = new DefaultCredentialsProviderImpl(this.getAdminCredentials(), this.authScope);
        return provider;
    }
}

