/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav.oracle;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.schedassist.impl.caldav.DefaultCredentialsProviderImpl;
import org.jasig.schedassist.model.ICalendarAccount;

public class OracleCommsCredentialsProviderImpl
extends DefaultCredentialsProviderImpl {
    private static final String SEMICOLON = ";";
    private final ICalendarAccount accountToProxy;

    public OracleCommsCredentialsProviderImpl(ICalendarAccount accountToProxy, Credentials adminCredentials, AuthScope targetAuthScope) {
        super(adminCredentials, targetAuthScope);
        this.accountToProxy = accountToProxy;
    }

    @Override
    public Credentials getCredentials(AuthScope authscope) {
        if (!this.getTargetAuthScope().equals((Object)authscope)) {
            return null;
        }
        StringBuilder username = new StringBuilder(this.getAdminCredentials().getUserPrincipal().getName());
        username.append(SEMICOLON);
        username.append(this.accountToProxy.getEmailAddress());
        UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(username.toString(), this.getAdminCredentials().getPassword());
        return proxyCredentials;
    }
}

