/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.caldav.CalendarWithURI;
import org.jasig.schedassist.impl.caldav.xml.XmlParsingException;

public class ReportResponseHandlerImpl {
    protected static final String WEBDAV_NS = "DAV:";
    protected static final String HREF = "href";
    protected static final String ETAG = "getetag";
    protected static final String CALDAV_NS = "urn:ietf:params:xml:ns:caldav";
    protected static final String CALENDAR_DATA = "calendar-data";
    protected final Log log = LogFactory.getLog(this.getClass());

    public List<CalendarWithURI> extractCalendars(InputStream inputStream) {
        ArrayList<CalendarWithURI> results = new ArrayList<CalendarWithURI>();
        ByteArrayOutputStream capturedContent = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            InputStream localReference = inputStream;
            if (this.log.isDebugEnabled()) {
                capturedContent = new ByteArrayOutputStream();
                localReference = new TeeInputStream(inputStream, (OutputStream)capturedContent);
            }
            BufferedInputStream buffered = new BufferedInputStream(localReference);
            buffered.mark(1);
            int firstbyte = buffered.read();
            if (-1 == firstbyte) {
                return results;
            }
            buffered.reset();
            XMLStreamReader parser = factory.createXMLStreamReader(buffered);
            String currentUri = null;
            String currentEtag = null;
            int eventType = parser.next();
            while (eventType != 8) {
                switch (eventType) {
                    case 1: {
                        QName name = parser.getName();
                        if (this.isWebdavHrefElement(name)) {
                            currentUri = parser.getElementText();
                            break;
                        }
                        if (this.isWebdavEtagElement(name)) {
                            currentEtag = parser.getElementText();
                            break;
                        }
                        if (!this.isCalendarDataElement(name)) break;
                        Calendar cal = this.extractCalendar(parser.getElementText());
                        if (cal != null) {
                            CalendarWithURI withUri = new CalendarWithURI(cal, currentUri, currentEtag);
                            results.add(withUri);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug((Object)("extractCalendar returned null for " + currentUri + ", skipping"));
                    }
                }
                eventType = parser.next();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("extracted " + results.size() + " calendar from " + capturedContent.toString()));
            }
        }
        catch (XMLStreamException e) {
            if (capturedContent != null) {
                this.log.error((Object)("caught XMLStreamException in extractCalendars, captured content: " + capturedContent.toString()), (Throwable)e);
            } else {
                this.log.error((Object)"caught XMLStreamException in extractCalendars, no captured content available", (Throwable)e);
            }
            throw new XmlParsingException("caught XMLStreamException in extractCalendars", e);
        }
        catch (IOException e) {
            this.log.error((Object)"caught IOException in extractCalendars", (Throwable)e);
            throw new XmlParsingException("caught IOException in extractCalendars", e);
        }
        return results;
    }

    protected boolean isWebdavEtagElement(QName qname) {
        if (qname == null) {
            return false;
        }
        return WEBDAV_NS.equals(qname.getNamespaceURI()) && ETAG.equals(qname.getLocalPart());
    }

    protected boolean isWebdavHrefElement(QName qname) {
        if (qname == null) {
            return false;
        }
        return WEBDAV_NS.equals(qname.getNamespaceURI()) && HREF.equals(qname.getLocalPart());
    }

    protected boolean isCalendarDataElement(QName qname) {
        if (qname == null) {
            return false;
        }
        return CALDAV_NS.equals(qname.getNamespaceURI()) && CALENDAR_DATA.equals(qname.getLocalPart());
    }

    protected Calendar extractCalendar(String text) {
        CalendarBuilder builder = new CalendarBuilder();
        try {
            Calendar result = builder.build((Reader)new StringReader(text));
            return result;
        }
        catch (IOException e) {
            this.log.warn((Object)"caught IOException", (Throwable)e);
            return null;
        }
        catch (ParserException e) {
            this.log.warn((Object)"caught ParserException", (Throwable)e);
            return null;
        }
    }

    static {
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
    }
}

