/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javasimon.Manager;
import org.javasimon.console.SimonConsoleRequestProcessor;

public class SimonConsoleServlet
extends HttpServlet {
    public static final long serialVersionUID = 1L;
    public static final String URL_PREFIX_INIT_PARAMETER = "url-prefix";
    public static final String PLUGIN_CLASSES_INIT_PARAMETER = "plugin-classes";
    private SimonConsoleRequestProcessor requestProcessor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Manager manager = SimonConsoleServlet.getManager(config.getServletContext());
        String urlPrefix = config.getInitParameter(URL_PREFIX_INIT_PARAMETER);
        String pluginClasses = config.getInitParameter(PLUGIN_CLASSES_INIT_PARAMETER);
        this.requestProcessor = SimonConsoleRequestProcessor.create(urlPrefix, manager, pluginClasses);
    }

    public static Manager getManager(ServletContext servletContext) {
        Object managerObject = servletContext.getAttribute("manager-servlet-ctx-attribute");
        Manager manager = null;
        if (managerObject instanceof Manager) {
            manager = (Manager)managerObject;
        }
        return manager;
    }

    public SimonConsoleRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestProcessor.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestProcessor.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

