/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.console.Action;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonTypeFactory;
import org.javasimon.console.SimonVisitor;
import org.javasimon.console.SimonVisitors;
import org.javasimon.console.TimeFormatType;
import org.javasimon.console.reflect.Getter;
import org.javasimon.console.reflect.GetterFactory;
import org.javasimon.console.text.Stringifier;
import org.javasimon.console.text.StringifierFactory;

public class AbstractTableAction
extends Action {
    protected StringifierFactory stringifierFactory;
    private String pattern;
    private Set<SimonType> types;
    private List<Column> columns = new ArrayList<Column>();
    protected final String contentType;
    protected String numberPattern = "0.000";

    protected AbstractTableAction(ActionContext context, String contentType) {
        super(context);
        this.contentType = contentType;
        this.columns.add(new Column("Name", "name"));
        this.columns.add(new Column<SimonType>("Type", "type"){
            private Stringifier<SimonType> stringifier;

            @Override
            public SimonType getValue(Object object) {
                return SimonTypeFactory.getValueFromInstance((Sample)object);
            }

            @Override
            public String getFormattedValue(Object object) {
                return this.getStringifier(object).toString(this.getValue(object));
            }

            @Override
            public Stringifier<SimonType> getStringifier(Object object) {
                if (this.stringifier == null) {
                    this.stringifier = AbstractTableAction.this.stringifierFactory.getStringifier(SimonType.class);
                }
                return this.stringifier;
            }
        });
        this.columns.add(new Column("Counter", "counter"));
        this.columns.add(new Column("Total", "total"));
        this.columns.add(new Column("Min", "min"));
        this.columns.add(new Column("Mean", "mean"));
        this.columns.add(new Column("Last", "last"));
        this.columns.add(new Column("Max", "max"));
        this.columns.add(new Column("Std Dev", "standardDeviation"));
        this.columns.add(new Column("First Use", "firstUsage"));
        this.columns.add(new Column("Last Use", "lastUsage"));
        this.columns.add(new Column("Note", "note"));
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void readParameters() {
        TimeFormatType timeFormat = this.getContext().getParameterAsEnum("timeFormat", TimeFormatType.class, TimeFormatType.MILLISECOND);
        this.stringifierFactory.init(timeFormat, "yyyy-MM-dd HH:mm:ss", this.numberPattern);
        this.pattern = this.getContext().getParameterAsString("pattern", null);
        this.types = this.getContext().getParametersAsEnums("type", SimonType.class, null);
    }

    protected void printTable(PrintWriter writer) throws IOException {
        this.printHeaderRow(writer);
        this.printBody(writer);
    }

    protected void printHeaderRow(PrintWriter writer) throws IOException {
        for (Column column : this.columns) {
            this.printHeaderCell(column, writer);
        }
    }

    protected void printHeaderCell(Column c, PrintWriter writer) throws IOException {
        this.printCell(c, c.getTitle(), writer);
    }

    protected void printBody(PrintWriter writer) throws IOException {
        SimonVisitors.visitList(this.getContext().getManager(), this.pattern, this.types, new SimonVisitorImpl(writer));
    }

    protected void printBodyRow(Simon simon, PrintWriter writer) throws IOException {
        this.printBodyRow(simon.sample(), writer);
    }

    protected void printBodyRow(Sample sample, PrintWriter writer) throws IOException {
        for (Column column : this.columns) {
            this.printBodyCell(column, sample, writer);
        }
    }

    protected void printBodyCell(Column c, Sample sample, PrintWriter writer) throws IOException {
        this.printCell(c, c.getFormattedValue(sample), writer);
    }

    protected void printCell(Column c, String s, PrintWriter writer) throws IOException {
        if (s != null) {
            writer.write(s);
        }
    }

    @Override
    public void execute() throws ServletException, IOException, ActionException {
        this.dontCache();
        PrintWriter writer = null;
        try {
            this.getContext().setContentType(this.contentType);
            writer = this.getContext().getWriter();
            this.printTable(writer);
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    protected class Column<T> {
        private final String title;
        private final String name;

        public Column(String title, String name) {
            this.title = title;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        private Getter<T> getGetter(Object object) {
            return GetterFactory.getGetter(object.getClass(), this.name);
        }

        public T getValue(Object object) {
            Getter<T> getter = this.getGetter(object);
            return getter == null ? null : (T)getter.get(object);
        }

        public Stringifier<T> getStringifier(Object object) {
            Getter<T> getter = this.getGetter(object);
            if (getter == null) {
                return AbstractTableAction.this.stringifierFactory.getNullStringifier();
            }
            return AbstractTableAction.this.stringifierFactory.getStringifier(getter.getType(), getter.getSubType());
        }

        public String getFormattedValue(Object object) {
            Getter<T> getter = this.getGetter(object);
            if (getter == null) {
                return AbstractTableAction.this.stringifierFactory.toString(null);
            }
            return AbstractTableAction.this.stringifierFactory.toString(getter.get(object), getter.getSubType());
        }
    }

    private class SimonVisitorImpl
    implements SimonVisitor {
        private final PrintWriter writer;

        public SimonVisitorImpl(PrintWriter writer) {
            this.writer = writer;
        }

        @Override
        public void visit(Simon simon) throws IOException {
            AbstractTableAction.this.printBodyRow(simon, this.writer);
        }
    }
}

