/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.console.Action;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonTypeFactory;
import org.javasimon.console.TimeFormatType;
import org.javasimon.console.reflect.Getter;
import org.javasimon.console.reflect.GetterFactory;
import org.javasimon.console.text.Stringifier;
import org.javasimon.console.text.StringifierFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXmlAction
extends Action {
    protected final StringifierFactory stringifierFactory = new StringifierFactory();

    protected AbstractXmlAction(ActionContext context) {
        super(context);
    }

    @Override
    public void readParameters() {
        TimeFormatType timeFormat = this.getContext().getParameterAsEnum("timeFormat", TimeFormatType.class, TimeFormatType.MILLISECOND);
        this.stringifierFactory.init(timeFormat, "yyyy-MM-dd'T'HH:mm:ss", "0.000");
    }

    protected Element createElement(Document document, Simon simon) {
        Sample sample = simon.sample();
        SimonType lType = SimonTypeFactory.getValueFromInstance(sample);
        Element element = document.createElement(lType.name().toLowerCase());
        element.setAttribute("name", sample.getName());
        for (Getter getter : GetterFactory.getGetters(sample.getClass())) {
            Stringifier propertyStringifier;
            Object propertyValue = getter.get(sample);
            if (propertyValue == null || (propertyStringifier = this.stringifierFactory.getStringifier(getter.getType(), getter.getSubType())) == null) continue;
            element.setAttribute(getter.getName(), propertyStringifier.toString(propertyValue));
        }
        Iterator attributeNameIter = simon.getAttributeNames();
        while (attributeNameIter.hasNext()) {
            Stringifier<?> attributeStringifier;
            String attributeName = (String)attributeNameIter.next();
            Object attributeValue = simon.getAttribute(attributeName);
            if (attributeValue == null || (attributeStringifier = this.stringifierFactory.getStringifier(attributeValue.getClass())) == null) continue;
            Element attributeElt = document.createElement("attribute");
            attributeElt.setAttribute("name", attributeName);
            attributeElt.setAttribute("value", attributeStringifier.toString(attributeValue));
            element.appendChild(attributeElt);
        }
        return element;
    }

    @Override
    public void execute() throws ServletException, IOException, ActionException {
        this.dontCache();
        this.getContext().setContentType("text/xml");
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this.fillDocument(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(this.getContext().getOutputStream()));
        }
        catch (ParserConfigurationException | TransformerException parserConfigurationException) {
            throw new ActionException("XML Parser error", parserConfigurationException);
        }
        finally {
            this.getContext().getOutputStream().flush();
        }
    }

    protected abstract void fillDocument(Document var1);
}

