/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import org.javasimon.Simon;
import org.javasimon.console.ActionContext;
import org.javasimon.console.action.AbstractJsonAction;
import org.javasimon.console.json.ArrayJS;
import org.javasimon.console.json.ObjectJS;

public class TreeJsonAction
extends AbstractJsonAction {
    public static final String PATH = "/data/tree.json";
    private String name;

    public TreeJsonAction(ActionContext context) {
        super(context);
    }

    @Override
    public void readParameters() {
        super.readParameters();
        this.name = this.getContext().getParameterAsString("name", null);
    }

    @Override
    protected ObjectJS createObjectJS(Simon simon) {
        ObjectJS simonJS = super.createObjectJS(simon);
        ArrayJS childrenJS = new ArrayJS();
        for (Simon child : simon.getChildren()) {
            ObjectJS childJS = this.createObjectJS(child);
            childrenJS.addElement(childJS);
        }
        simonJS.setAttribute("children", childrenJS);
        return simonJS;
    }

    @Override
    public void execute() throws IOException {
        this.getContext().setContentType("application/json");
        Simon simon = this.name == null ? this.getContext().getManager().getRootSimon() : this.findSimonByName(this.name);
        ObjectJS simonRootJS = this.createObjectJS(simon);
        simonRootJS.write(this.getContext().getWriter());
    }
}

