/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.json;

import org.javasimon.console.text.BaseStringifier;
import org.javasimon.console.text.Stringifier;
import org.javasimon.console.text.StringifierFactory;

public class JsonStringifierFactory
extends StringifierFactory {
    @Override
    protected Stringifier registerNullStringifier() {
        return this.registerNullStringifier("\"\"");
    }

    @Override
    protected Stringifier<String> registerStringStringifier(Stringifier nullStringifier) {
        BaseStringifier<String> stringStringifier = new BaseStringifier<String>(nullStringifier){

            @Override
            protected String doToString(String string) {
                if (string.isEmpty()) {
                    return "\"\"";
                }
                int len = string.length();
                StringBuilder sb = new StringBuilder(len + 6).append('\"');
                block9: for (int i = 0; i < len; ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            sb.append('\\');
                            sb.append(c);
                            continue block9;
                        }
                        case '/': {
                            sb.append("\\/");
                            continue block9;
                        }
                        case '\b': {
                            sb.append("\\b");
                            continue block9;
                        }
                        case '\t': {
                            sb.append("\\t");
                            continue block9;
                        }
                        case '\n': {
                            sb.append("\\n");
                            continue block9;
                        }
                        case '\f': {
                            sb.append("\\f");
                            continue block9;
                        }
                        case '\r': {
                            sb.append("\\r");
                            continue block9;
                        }
                        default: {
                            if (c < ' ') {
                                sb.append("\\u");
                                String hexString = Integer.toHexString(c);
                                for (int j = hexString.length(); j < 4; ++j) {
                                    sb.append('0');
                                }
                                sb.append(hexString);
                                continue block9;
                            }
                            sb.append(c);
                        }
                    }
                }
                return sb.append('\"').toString();
            }
        };
        this.compositeStringifier.add(String.class, stringStringifier);
        return stringStringifier;
    }
}

