/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.text;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.javasimon.SimonState;
import org.javasimon.console.SimonType;
import org.javasimon.console.TimeFormatType;
import org.javasimon.console.html.HtmlResourceType;
import org.javasimon.console.text.BaseStringifier;
import org.javasimon.console.text.CompositeStringifier;
import org.javasimon.console.text.NoneStringifier;
import org.javasimon.console.text.Stringifier;
import org.javasimon.utils.SimonUtils;

public class StringifierFactory {
    public static final String DATE_SUBTYPE = "Date";
    public static final String TIME_SUBTYPE = "Time";
    public static final String NONE_SUBTYPE = "None";
    public static final String INTEGER_NUMBER_PATTERN = "0";
    public static final String READABLE_NUMBER_PATTERN = "0.000";
    public static final String READABLE_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    protected final CompositeStringifier compositeStringifier = new CompositeStringifier();

    protected Stringifier registerNullStringifier() {
        return this.registerNullStringifier("");
    }

    protected final Stringifier registerNullStringifier(final String nullValue) {
        Stringifier nullStringifier = new Stringifier(){

            public String toString(Object object) {
                return nullValue;
            }
        };
        this.compositeStringifier.setNullStringifier(nullStringifier);
        return nullStringifier;
    }

    protected Stringifier<String> registerStringStringifier(Stringifier nullStringifier) {
        BaseStringifier<String> stringStringifier = new BaseStringifier<String>(nullStringifier){

            @Override
            protected String doToString(String s) {
                return s;
            }
        };
        this.compositeStringifier.add(String.class, stringStringifier);
        return stringStringifier;
    }

    protected final Stringifier<Long> registerLongStringifier(String name, Stringifier<Long> longStringifier) {
        this.compositeStringifier.add(Long.class, name, longStringifier);
        this.compositeStringifier.add(Long.TYPE, name, longStringifier);
        return longStringifier;
    }

    protected final Stringifier<Double> registerDoubleStringifier(String name, Stringifier<Double> doubleStringifier) {
        this.compositeStringifier.add(Double.class, name, doubleStringifier);
        this.compositeStringifier.add(Double.TYPE, name, doubleStringifier);
        return doubleStringifier;
    }

    public void init(TimeFormatType timeFormat, String datePattern, String numberPattern) {
        Stringifier nullStringifier = this.registerNullStringifier();
        this.compositeStringifier.setDefaultStringifier(new BaseStringifier(nullStringifier));
        final Stringifier<String> stringStringifier = this.registerStringStringifier(nullStringifier);
        this.compositeStringifier.add(String.class, NONE_SUBTYPE, NoneStringifier.getInstance());
        BaseStringifier<Integer> integerStringifier = new BaseStringifier<Integer>(nullStringifier){

            @Override
            protected boolean isValid(Integer l) {
                return super.isValid(l) && l != Integer.MIN_VALUE && l != Integer.MAX_VALUE;
            }
        };
        this.compositeStringifier.add(Integer.class, integerStringifier);
        this.compositeStringifier.add(Integer.TYPE, integerStringifier);
        BaseStringifier<Long> longStringifier = new BaseStringifier<Long>(nullStringifier){

            @Override
            protected boolean isValid(Long l) {
                return super.isValid(l) && l != Long.MIN_VALUE && l != Long.MAX_VALUE;
            }
        };
        this.registerLongStringifier(null, (Stringifier<Long>)longStringifier);
        NumberStringifier<Float> floatStringifier = new NumberStringifier<Float>(nullStringifier, numberPattern){

            @Override
            protected boolean isValid(Float f) {
                return super.isValid(f) && f.floatValue() != Float.MIN_VALUE && f.floatValue() != Float.MAX_VALUE && !f.isInfinite() && !f.isNaN();
            }
        };
        this.compositeStringifier.add(Float.class, floatStringifier);
        this.compositeStringifier.add(Float.TYPE, floatStringifier);
        NumberStringifier<Double> doubleStringifier = new NumberStringifier<Double>(nullStringifier, numberPattern){

            @Override
            protected boolean isValid(Double d) {
                return super.isValid(d) && d != Double.MIN_VALUE && d != Double.MAX_VALUE && !d.isInfinite() && !d.isNaN();
            }
        };
        this.registerDoubleStringifier(null, (Stringifier<Double>)doubleStringifier);
        BaseStringifier<Enum> enumStringifier = new BaseStringifier<Enum>(nullStringifier){

            @Override
            protected String doToString(Enum e) {
                return stringStringifier.toString(e.name());
            }
        };
        this.compositeStringifier.add(Enum.class, enumStringifier);
        this.compositeStringifier.add(SimonType.class, enumStringifier);
        this.compositeStringifier.add(SimonState.class, enumStringifier);
        this.compositeStringifier.add(HtmlResourceType.class, enumStringifier);
        DateStringifier dateStringifier = new DateStringifier(nullStringifier, stringStringifier, datePattern);
        this.compositeStringifier.add(Date.class, dateStringifier);
        LongDateStringifier longDateStringifier = new LongDateStringifier(nullStringifier, dateStringifier);
        this.registerLongStringifier(DATE_SUBTYPE, longDateStringifier);
        LongTimeStringifier longTimeStringifier = new LongTimeStringifier(nullStringifier, (Stringifier<Long>)longStringifier, stringStringifier, timeFormat);
        this.registerLongStringifier(TIME_SUBTYPE, longTimeStringifier);
        DoubleTimeStringifier doubleTimeStringifier = new DoubleTimeStringifier(nullStringifier, (Stringifier<Double>)doubleStringifier, stringStringifier, timeFormat);
        this.registerDoubleStringifier(TIME_SUBTYPE, doubleTimeStringifier);
        BaseStringifier<Boolean> booleanStringifier = new BaseStringifier<Boolean>(nullStringifier){

            @Override
            protected String doToString(Boolean b) {
                return stringStringifier.toString(b.toString());
            }
        };
        this.compositeStringifier.add(Boolean.class, booleanStringifier);
        this.compositeStringifier.add(Boolean.TYPE, booleanStringifier);
    }

    public <T> Stringifier<T> getNullStringifier() {
        return this.compositeStringifier.getNullStringifier();
    }

    public <T> Stringifier<T> getStringifier(Class<? extends T> type) {
        return this.compositeStringifier.getForType(type);
    }

    public <T> Stringifier<T> getStringifier(Class<? extends T> type, String subType) {
        return this.compositeStringifier.getForType(type, subType);
    }

    public <T> String toString(T value) {
        return this.compositeStringifier.toString((Object)value);
    }

    public <T> String toString(T value, String subType) {
        return this.compositeStringifier.toString(value, subType);
    }

    protected static class DoubleTimeStringifier
    extends BaseStringifier<Double> {
        private final TimeFormatType timeFormatType;
        private final Stringifier<Double> doubleStringifier;
        private final Stringifier<String> stringStringifier;

        public DoubleTimeStringifier(Stringifier nullStringifier, Stringifier<Double> doubleStringifier, Stringifier<String> stringStringifier, TimeFormatType timeFormatType) {
            super(nullStringifier);
            this.timeFormatType = timeFormatType;
            this.doubleStringifier = doubleStringifier;
            this.stringStringifier = stringStringifier;
        }

        @Override
        protected boolean isValid(Double object) {
            return super.isValid(object) && object >= 0.0 && object < Double.MAX_VALUE && object != Double.NaN;
        }

        @Override
        protected String doToString(Double d) {
            if (this.timeFormatType == TimeFormatType.AUTO) {
                return this.stringStringifier.toString(SimonUtils.presentNanoTime((double)d));
            }
            Double d2 = this.timeFormatType.convert(d);
            return this.doubleStringifier.toString(d2);
        }
    }

    protected static class LongTimeStringifier
    extends BaseStringifier<Long> {
        private final TimeFormatType timeFormatType;
        private final Stringifier<Long> longStringifier;
        private final Stringifier<String> stringStringifier;

        public LongTimeStringifier(Stringifier nullStringifier, Stringifier<Long> longStringifier, Stringifier<String> stringStringifier, TimeFormatType timeFormatType) {
            super(nullStringifier);
            this.timeFormatType = timeFormatType;
            this.longStringifier = longStringifier;
            this.stringStringifier = stringStringifier;
        }

        @Override
        protected boolean isValid(Long object) {
            return super.isValid(object) && object >= 0L && object < Long.MAX_VALUE;
        }

        @Override
        protected String doToString(Long l) {
            if (this.timeFormatType == TimeFormatType.AUTO) {
                return this.stringStringifier.toString(SimonUtils.presentNanoTime((long)l));
            }
            long l2 = this.timeFormatType.convert(l);
            return this.longStringifier.toString(l2);
        }
    }

    protected static class LongDateStringifier
    extends BaseStringifier<Long> {
        private final Stringifier<Date> dateStringifier;

        public LongDateStringifier(Stringifier nullStringifier, Stringifier<Date> dateStringifier) {
            super(nullStringifier);
            this.dateStringifier = dateStringifier;
        }

        @Override
        protected boolean isValid(Long object) {
            return super.isValid(object) && object > 0L && object < Long.MAX_VALUE;
        }

        @Override
        protected String doToString(Long object) {
            return this.dateStringifier.toString(new Date(object));
        }
    }

    protected static class NumberStringifier<T extends Number>
    extends BaseStringifier<T> {
        private final NumberFormat numberFormat;

        public NumberStringifier(Stringifier nullStringifier, String numberPattern) {
            super(nullStringifier);
            DecimalFormat decimalFormat = new DecimalFormat(numberPattern);
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            this.numberFormat = decimalFormat;
        }

        @Override
        protected String doToString(T n) {
            return this.numberFormat.format(((Number)n).doubleValue());
        }
    }

    protected static class DateStringifier
    extends BaseStringifier<Date> {
        private final DateFormat dateFormat;
        private final Stringifier<String> stringStringifier;

        public DateStringifier(Stringifier nullStringifier, Stringifier<String> stringStringifier, String datePattern) {
            super(nullStringifier);
            this.dateFormat = new SimpleDateFormat(datePattern);
            this.stringStringifier = stringStringifier;
        }

        @Override
        protected String doToString(Date d) {
            return this.stringStringifier.toString(this.dateFormat.format(d));
        }
    }
}

