/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx4;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.javasimon.jdbc4.SimonConnection;
import org.javasimon.jdbc4.WrapperSupport;
import org.javasimon.jdbcx4.AbstractSimonDataSource;

public final class SimonDataSource
extends AbstractSimonDataSource
implements DataSource {
    private DataSource ds;
    private WrapperSupport<DataSource> wrapperSupport;

    DataSource datasource() throws SQLException {
        if (this.ds == null) {
            this.ds = this.createDataSource(DataSource.class);
            this.ds.setLogWriter(this.logWriter);
            this.wrapperSupport = new WrapperSupport<DataSource>(this.ds, DataSource.class);
        }
        return this.ds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new SimonConnection(this.datasource().getConnection(), this.getPrefix(), this.sqlNormalizerFactory);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return new SimonConnection(this.datasource().getConnection(user, password), this.getPrefix(), this.sqlNormalizerFactory);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrapperSupport.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapperSupport.isWrapperFor(iface);
    }

    @Override
    protected String doGetRealDataSourceClassName() {
        return this.configuration.getRealDataSourceName();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.ds.getParentLogger();
    }
}

