/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx4;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.javasimon.jdbc4.RegexBasedNormalizerFactory;
import org.javasimon.jdbc4.SimonConnection;
import org.javasimon.jdbc4.SqlNormalizerFactory;

public class SimonPooledConnection
implements PooledConnection {
    private final PooledConnection pooledConn;
    private final String prefix;
    private Map<ConnectionEventListener, SimonConnectionEventListener> connListeners = new HashMap<ConnectionEventListener, SimonConnectionEventListener>();
    private Map<StatementEventListener, SimonStatementEventListener> stmtListeners = new HashMap<StatementEventListener, SimonStatementEventListener>();
    private SqlNormalizerFactory sqlNormalizerFactory = new RegexBasedNormalizerFactory();

    public SimonPooledConnection(PooledConnection connection, String prefix) {
        this.pooledConn = connection;
        this.prefix = prefix;
    }

    public SimonPooledConnection withSqlNormalizerFactory(SqlNormalizerFactory sqlNormalizerFactory) {
        this.sqlNormalizerFactory = sqlNormalizerFactory;
        return this;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return new SimonConnection(this.pooledConn.getConnection(), this.prefix, this.sqlNormalizerFactory);
    }

    @Override
    public final void close() throws SQLException {
        this.pooledConn.close();
    }

    @Override
    public final void addConnectionEventListener(ConnectionEventListener listener) {
        this.connListeners.put(listener, new SimonConnectionEventListener(listener));
        this.pooledConn.addConnectionEventListener(this.connListeners.get(listener));
    }

    @Override
    public final void removeConnectionEventListener(ConnectionEventListener listener) {
        this.pooledConn.removeConnectionEventListener(this.connListeners.get(listener));
        this.connListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.stmtListeners.put(listener, new SimonStatementEventListener(listener));
        this.pooledConn.addStatementEventListener(this.stmtListeners.get(listener));
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.pooledConn.removeStatementEventListener(this.stmtListeners.get(listener));
        this.stmtListeners.remove(listener);
    }

    private class SimonStatementEventListener
    implements StatementEventListener {
        private final StatementEventListener originalListener;

        SimonStatementEventListener(StatementEventListener originalListener) {
            this.originalListener = originalListener;
        }

        @Override
        public void statementClosed(StatementEvent event) {
            this.originalListener.statementClosed(new StatementEvent(SimonPooledConnection.this, event.getStatement()));
        }

        @Override
        public void statementErrorOccurred(StatementEvent event) {
            this.originalListener.statementErrorOccurred(new StatementEvent(SimonPooledConnection.this, event.getStatement(), event.getSQLException()));
        }
    }

    private class SimonConnectionEventListener
    implements ConnectionEventListener {
        private final ConnectionEventListener originalListener;

        SimonConnectionEventListener(ConnectionEventListener originalListener) {
            this.originalListener = originalListener;
        }

        @Override
        public void connectionClosed(ConnectionEvent event) {
            this.originalListener.connectionClosed(new ConnectionEvent(SimonPooledConnection.this, event.getSQLException()));
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            this.originalListener.connectionErrorOccurred(new ConnectionEvent(SimonPooledConnection.this, event.getSQLException()));
        }
    }
}

