/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.scala;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScalaContext {
    private final ClassLoader classLoader;
    private final List<String> classNames;
    private List<Object> instances;

    public ScalaContext(String ... classNames) {
        this(ScalaContext.class.getClassLoader(), classNames);
    }

    public ScalaContext(ClassLoader classLoader, String ... classNames) {
        this.classLoader = classLoader;
        this.classNames = Arrays.asList(classNames);
        this.instances = this.createInstances();
    }

    public List<Object> getInstances() {
        return this.instances;
    }

    public <T> T getInstanceOfType(Class<T> type) {
        for (Object instance : this.instances) {
            if (!type.isAssignableFrom(instance.getClass())) continue;
            return (T)instance;
        }
        throw new ScalaInstanceNotFound(type);
    }

    public Object newInstance(String className) {
        try {
            return this.classLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new ScalaInstanceNotFound(className);
        }
    }

    private List<Object> createInstances() {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (String className : this.classNames) {
            instances.add(this.newInstance(className));
        }
        return instances;
    }

    public static final class ScalaInstanceNotFound
    extends RuntimeException {
        public ScalaInstanceNotFound(Class<?> type) {
            super(type.toString());
        }

        public ScalaInstanceNotFound(String className) {
            super(className);
        }
    }
}

