/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.weld;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbehave.core.annotations.weld.UsingWeld;
import org.jbehave.core.annotations.weld.WeldConfiguration;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.weld.WeldAnnotationBuilder;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.weld.WeldStepsFactory;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.resources.spi.ResourceLoader;

@ApplicationScoped
public class WeldBootstrap
extends Weld {
    private WeldContainer weld;

    protected Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        Deployment deployment = super.createDeployment(resourceLoader, bootstrap);
        return deployment;
    }

    public WeldContainer initialize() {
        this.weld = super.initialize();
        return this.weld;
    }

    public WeldAnnotationBuilder findAnnotationBuilder(Class<?> annotatedClass) {
        return ((InstanceManager)this.weld.instance().select(InstanceManager.class, new Annotation[0]).get()).findBuilder(annotatedClass);
    }

    @ApplicationScoped
    public static class InstanceManager {
        @Inject
        @Any
        @UsingWeld
        private Instance<Object> instances;
        @Inject
        @WeldConfiguration
        private Configuration configuration;
        @Inject
        private WeldStepsFactory stepsFactory;
        private Map<Class<?>, WeldAnnotationBuilder> builders = null;

        public void build() {
            this.builders = new HashMap();
            for (Object o : this.instances) {
                Class<?> instanceClass = o.getClass();
                WeldAnnotationBuilder builder = new WeldAnnotationBuilder(instanceClass, this.configuration, (InjectableStepsFactory)this.stepsFactory);
                this.builders.put(instanceClass, builder);
            }
        }

        public WeldAnnotationBuilder findBuilder(Class<?> annotatedClass) {
            if (this.builders == null) {
                this.build();
            }
            if (this.builders.containsKey(annotatedClass)) {
                return this.builders.get(annotatedClass);
            }
            return new WeldAnnotationBuilder(annotatedClass, this.configuration, (InjectableStepsFactory)this.stepsFactory);
        }
    }
}

