/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls.managed.rest;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.wls.CommonManagedWebLogicConfiguration;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;
import org.jboss.arquillian.container.wls.WebLogicManagedContainer;
import org.jboss.arquillian.container.wls.WebLogicServerControl;
import org.jboss.arquillian.container.wls.managed.rest.WebLogicManagedConfiguration;
import org.jboss.arquillian.container.wls.rest.RESTUtils;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedContainer
implements WebLogicManagedContainer {
    private static final Logger LOGGER = Logger.getLogger(ManagedContainer.class.getName());
    private WebLogicManagedConfiguration config;
    private WebLogicServerControl serverControl;

    public ManagedContainer(WebLogicManagedConfiguration configuration) {
        this.config = configuration;
    }

    public void start() throws LifecycleException {
        this.serverControl = new WebLogicServerControl((CommonManagedWebLogicConfiguration)this.config);
        this.serverControl.startServer();
    }

    public void stop() throws LifecycleException {
        this.serverControl.stopServer();
    }

    private void stopUsingREST() {
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        return RESTUtils.deploy((CommonWebLogicConfiguration)this.config, (Logger)LOGGER, archive);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        RESTUtils.undeploy((CommonWebLogicConfiguration)this.config, (Logger)LOGGER, archive);
    }

    static {
        LOGGER.setLevel(Level.ALL);
    }
}

