/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.server;

import java.lang.management.ManagementFactory;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.arquillian.container.se.api.LaunchServices;
import org.jboss.arquillian.container.se.server.SecurityActions;
import org.jboss.arquillian.container.se.server.TestClassLoader;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;

public class Main {
    public static final String SYSTEM_PROPERTY_TEST_SUBPROCESS_TIMEOUT = "testSubprocessTimeout";
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final long DEFAULT_TIMEOUT = 60000L;

    public static void main(String[] args) {
        LaunchServices launchServices = Main.getLaunchServices();
        launchServices.initialize();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(launchServices));
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ClassLoader classLoader = launchServices.getClassLoader();
            if (classLoader == null) {
                classLoader = Main.getDefaultClassLoader();
            }
            JMXTestRunner testRunner = new JMXTestRunner((JMXTestRunner.TestClassLoader)new TestClassLoader(classLoader));
            testRunner.registerMBean(mbs);
            LOGGER.info("JMXTestRunner initialized using [" + classLoader + "]");
        }
        catch (JMException e) {
            throw new RuntimeException("Unable to register JMXTestRunner", e);
        }
        Long timeout = Long.getLong(SYSTEM_PROPERTY_TEST_SUBPROCESS_TIMEOUT, 60000L);
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for undeploy signal", e);
        }
        LOGGER.warning("Test subprocess timeout - VM not terminated within " + timeout + " ms");
    }

    private static LaunchServices getLaunchServices() {
        DefaultLaunchServices launchServices;
        String launchServicesClass = System.getProperty(LaunchServices.SYSTEM_PROPERTY_LAUNCH_SERVICES_CLASS);
        if (launchServicesClass != null) {
            try {
                launchServices = (LaunchServices)SecurityActions.newInstance(SecurityActions.getClassLoader(Main.class).loadClass(launchServicesClass));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        } else {
            launchServices = new DefaultLaunchServices();
        }
        return launchServices;
    }

    private static ClassLoader getDefaultClassLoader() {
        return SecurityActions.getClassLoader(Main.class);
    }

    private static class ShutdownHook
    extends Thread {
        private final LaunchServices launchServices;

        ShutdownHook(LaunchServices launchServices) {
            this.launchServices = launchServices;
        }

        @Override
        public void run() {
            this.launchServices.shutdown();
        }
    }

    private static class DefaultLaunchServices
    extends LaunchServices {
        private DefaultLaunchServices() {
        }

        public ClassLoader getClassLoader() {
            return Main.getDefaultClassLoader();
        }
    }
}

