package com.arjuna.ats.internal.jta.utils;

import java.util.Locale;
import com.arjuna.ats.arjuna.state.InputObjectState;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import com.arjuna.ats.internal.jta.transaction.jts.AtomicTransaction;
import java.lang.Throwable;
import java.lang.Class;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.lang.ClassNotFoundException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class jtaxI18NLogger_$logger implements jtaxI18NLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = jtaxI18NLogger_$logger.class.getName();
    public jtaxI18NLogger_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void info_jtax_recovery_jts_orbspecific_commit(final String arg0) {
        log.logv(FQCN, INFO, null, info_jtax_recovery_jts_orbspecific_commit$str(), arg0);
    }
    protected String info_jtax_recovery_jts_orbspecific_commit$str() {
        return "ARJUNA024001: XA recovery committing {0}";
    }
    @Override
    public final void info_jtax_recovery_jts_orbspecific_rollback(final String arg0) {
        log.logv(FQCN, INFO, null, info_jtax_recovery_jts_orbspecific_rollback$str(), arg0);
    }
    protected String info_jtax_recovery_jts_orbspecific_rollback$str() {
        return "ARJUNA024002: XA recovery rolling back {0}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_coperror(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_resources_jts_orbspecific_coperror$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_coperror$str() {
        return "ARJUNA024004: Caught the following error while trying to single phase complete resource";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_createstate() {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_createstate$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_createstate$str() {
        return "ARJUNA024005: Committing of resource state failed.";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_generror(final String arg0, final String arg1, final String arg2, final Throwable arg3) {
        log.logv(FQCN, WARN, arg3, warn_jtax_resources_jts_orbspecific_generror$str(), arg0, arg1, arg2);
    }
    protected String warn_jtax_resources_jts_orbspecific_generror$str() {
        return "ARJUNA024006: {0} caused an error from resource {1} in transaction {2}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_lastResource_disableWarning() {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_lastResource_disableWarning$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_lastResource_disableWarning$str() {
        return "ARJUNA024007: You have chosen to disable the Multiple Last Resources warning. You will see it only once.";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_lastResource_disallow(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_lastResource_disallow$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_lastResource_disallow$str() {
        return "ARJUNA024008: Adding multiple last resources is disallowed. Current resource is {0}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_lastResource_multipleWarning(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_lastResource_multipleWarning$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_lastResource_multipleWarning$str() {
        return "ARJUNA024009: Multiple last resources have been added to the current transaction. This is transactionally unsafe and should not be relied upon. Current resource is {0}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_lastResource_startupWarning() {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_lastResource_startupWarning$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_lastResource_startupWarning$str() {
        return "ARJUNA024010: You have chosen to enable multiple last resources in the transaction manager. This is transactionally unsafe and should not be relied upon.";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_loadstateread(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_resources_jts_orbspecific_loadstateread$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_loadstateread$str() {
        return "ARJUNA024011: Reading state caught exception";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_norecoveryxa(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_norecoveryxa$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_norecoveryxa$str() {
        return "ARJUNA024012: Could not find new XAResource to use for recovering non-serializable XAResource {0}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_notprepared(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_notprepared$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_notprepared$str() {
        return "ARJUNA024013: {0} caught NotPrepared exception during recovery phase!";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_nulltransaction(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_nulltransaction$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_nulltransaction$str() {
        return "ARJUNA024014: {0} - null or invalid transaction!";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_preparefailed(final String arg0, final String arg1, final String arg2, final Throwable arg3) {
        log.logv(FQCN, WARN, arg3, warn_jtax_resources_jts_orbspecific_preparefailed$str(), arg0, arg1, arg2);
    }
    protected String warn_jtax_resources_jts_orbspecific_preparefailed$str() {
        return "ARJUNA024015: XAResource prepare failed on resource {0} for transaction {1} with: {2}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_recfailed(final String arg0, final Throwable arg1) {
        log.logv(FQCN, WARN, arg1, warn_jtax_resources_jts_orbspecific_recfailed$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_recfailed$str() {
        return "ARJUNA024016: Recovery of resource failed when trying to call {0} got exception";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_remconn(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_resources_jts_orbspecific_remconn$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_remconn$str() {
        return "ARJUNA024017: Attempted shutdown of resource failed with exception";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_restoreerror1(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_resources_jts_orbspecific_restoreerror1$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_restoreerror1$str() {
        return "ARJUNA024018: Exception on attempting to resource XAResource";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_restoreerror2(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_resources_jts_orbspecific_restoreerror2$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_restoreerror2$str() {
        return "ARJUNA024019: Unexpected exception on attempting to resource XAResource";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_saveState() {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_saveState$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_saveState$str() {
        return "ARJUNA024020: Could not serialize a serializable XAResource!";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_unexpected(final String arg0, final Throwable arg1) {
        log.logv(FQCN, WARN, arg1, warn_jtax_resources_jts_orbspecific_unexpected$str(), arg0);
    }
    protected String warn_jtax_resources_jts_orbspecific_unexpected$str() {
        return "ARJUNA024021: {0} caught unexpected exception during recovery phase!";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_updatestate() {
        log.logv(FQCN, WARN, null, warn_jtax_resources_jts_orbspecific_updatestate$str());
    }
    protected String warn_jtax_resources_jts_orbspecific_updatestate$str() {
        return "ARJUNA024022: Updating of resource state failed.";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_xaerror(final String arg0, final String arg1, final String arg2, final String arg3, final Throwable arg4) {
        log.logv(FQCN, WARN, arg4, warn_jtax_resources_jts_orbspecific_xaerror$str(), arg0, arg1, arg2, arg3);
    }
    protected String warn_jtax_resources_jts_orbspecific_xaerror$str() {
        return "ARJUNA024023: {0} caused an XA error: {1} from resource {2} in transaction {3}";
    }
    protected String get_jtax_transaction_jts_alreadyassociated$str() {
        return "ARJUNA024024: thread is already associated with a transaction and subtransaction support is not enabled!";
    }
    @Override
    public final String get_jtax_transaction_jts_alreadyassociated() {
        return get_jtax_transaction_jts_alreadyassociated$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_delistfailed(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_transaction_jts_delistfailed$str());
    }
    protected String warn_jtax_transaction_jts_delistfailed$str() {
        return "ARJUNA024025: Delist of resource failed with exception";
    }
    @Override
    public final void warn_jtax_transaction_jts_endsuspendfailed1() {
        log.logv(FQCN, WARN, null, warn_jtax_transaction_jts_endsuspendfailed1$str());
    }
    protected String warn_jtax_transaction_jts_endsuspendfailed1$str() {
        return "ARJUNA024026: Ending suspended RMs failed when rolling back the transaction!";
    }
    protected String get_jtax_transaction_jts_endsuspendfailed2$str() {
        return "ARJUNA024027: Ending suspended RMs failed when rolling back the transaction, but transaction rolled back.";
    }
    @Override
    public final String get_jtax_transaction_jts_endsuspendfailed2() {
        return get_jtax_transaction_jts_endsuspendfailed2$str();
    }
    protected String get_jtax_transaction_jts_illegalstate$str() {
        return "ARJUNA024028: illegal resource state:";
    }
    @Override
    public final String get_jtax_transaction_jts_illegalstate() {
        return get_jtax_transaction_jts_illegalstate$str();
    }
    protected String get_jtax_transaction_jts_inactivetx$str() {
        return "ARJUNA024029: Transaction is not active.";
    }
    @Override
    public final String get_jtax_transaction_jts_inactivetx() {
        return get_jtax_transaction_jts_inactivetx$str();
    }
    protected String get_jtax_transaction_jts_invalidtx2$str() {
        return "ARJUNA024031: Invalid transaction.";
    }
    @Override
    public final String get_jtax_transaction_jts_invalidtx2() {
        return get_jtax_transaction_jts_invalidtx2$str();
    }
    protected String get_jtax_transaction_jts_jca_busy$str() {
        return "ARJUNA024032: Work already active!";
    }
    @Override
    public final String get_jtax_transaction_jts_jca_busy() {
        return get_jtax_transaction_jts_jca_busy$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_lastResourceOptimisationInterface(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_transaction_jts_lastResourceOptimisationInterface$str(), arg0);
    }
    protected String warn_jtax_transaction_jts_lastResourceOptimisationInterface$str() {
        return "ARJUNA024033: failed to load Last Resource Optimisation Interface {0}";
    }
    protected String get_jtax_transaction_jts_markedrollback$str() {
        return "ARJUNA024034: Could not enlist resource because the transaction is marked for rollback.";
    }
    @Override
    public final String get_jtax_transaction_jts_markedrollback() {
        return get_jtax_transaction_jts_markedrollback$str();
    }
    protected String get_jtax_transaction_jts_nosuchtx$str() {
        return "ARJUNA024035: No such transaction!";
    }
    @Override
    public final String get_jtax_transaction_jts_nosuchtx() {
        return get_jtax_transaction_jts_nosuchtx$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_nottximple() {
        log.logv(FQCN, WARN, null, warn_jtax_transaction_jts_nottximple$str());
    }
    protected String warn_jtax_transaction_jts_nottximple$str() {
        return "ARJUNA024036: Current transaction is not a TransactionImple";
    }
    protected String get_jtax_transaction_jts_notx$str() {
        return "ARJUNA024037: no transaction!";
    }
    @Override
    public final String get_jtax_transaction_jts_notx() {
        return get_jtax_transaction_jts_notx$str();
    }
    protected String get_jtax_transaction_jts_notxe$str() {
        return "ARJUNA024038: no transaction! Caught:";
    }
    @Override
    public final String get_jtax_transaction_jts_notxe() {
        return get_jtax_transaction_jts_notxe$str();
    }
    protected String get_jtax_transaction_jts_nullparam$str() {
        return "ARJUNA024040: paramater is null!";
    }
    @Override
    public final String get_jtax_transaction_jts_nullparam() {
        return get_jtax_transaction_jts_nullparam$str();
    }
    protected String get_jtax_transaction_jts_ressusp$str() {
        return "ARJUNA024042: is already suspended!";
    }
    @Override
    public final String get_jtax_transaction_jts_ressusp() {
        return get_jtax_transaction_jts_ressusp$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_rmerror(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_transaction_jts_rmerror$str());
    }
    protected String warn_jtax_transaction_jts_rmerror$str() {
        return "ARJUNA024043: An error occurred while checking if this is a new resource manager:";
    }
    @Override
    public final void warn_jtax_transaction_jts_rollbackerror(final String arg0, final Throwable arg1) {
        log.logv(FQCN, WARN, arg1, warn_jtax_transaction_jts_rollbackerror$str(), arg0);
    }
    protected String warn_jtax_transaction_jts_rollbackerror$str() {
        return "ARJUNA024044: {0} could not mark the transaction as rollback only";
    }
    @Override
    public final void warn_jtax_transaction_jts_starterror(final String arg0, final String arg1, final String arg2, final Throwable arg3) {
        log.logv(FQCN, WARN, arg3, warn_jtax_transaction_jts_starterror$str(), arg0, arg1, arg2);
    }
    protected String warn_jtax_transaction_jts_starterror$str() {
        return "ARJUNA024046: {0} returned XA error {1} for transaction {2}";
    }
    protected String get_jtax_transaction_jts_syncerror$str() {
        return "ARJUNA024048: Synchronizations are not allowed!";
    }
    @Override
    public final String get_jtax_transaction_jts_syncerror() {
        return get_jtax_transaction_jts_syncerror$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_syncproblem(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_transaction_jts_syncproblem$str());
    }
    protected String warn_jtax_transaction_jts_syncproblem$str() {
        return "ARJUNA024049: cleanup synchronization failed to register:";
    }
    protected String get_jtax_transaction_jts_syncrollbackexception$str() {
        return "ARJUNA024050: The transaction implementation threw a RollbackException";
    }
    @Override
    public final String get_jtax_transaction_jts_syncrollbackexception() {
        return get_jtax_transaction_jts_syncrollbackexception$str();
    }
    protected String get_jtax_transaction_jts_systemexception$str() {
        return "ARJUNA024051: The transaction implementation threw a SystemException";
    }
    @Override
    public final String get_jtax_transaction_jts_systemexception() {
        return get_jtax_transaction_jts_systemexception$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_threaderror(final Throwable arg0) {
        log.logv(FQCN, WARN, arg0, warn_jtax_transaction_jts_threaderror$str());
    }
    protected String warn_jtax_transaction_jts_threaderror$str() {
        return "ARJUNA024052: Active thread error:";
    }
    @Override
    public final void warn_jtax_transaction_jts_unknownres(final String arg0) {
        log.logv(FQCN, WARN, null, warn_jtax_transaction_jts_unknownres$str(), arg0);
    }
    protected String warn_jtax_transaction_jts_unknownres$str() {
        return "ARJUNA024053: {0} attempt to delist unknown resource!";
    }
    protected String get_jtax_transaction_jts_wrongstatetx$str() {
        return "ARJUNA024054: The current transaction does not match this transaction!";
    }
    @Override
    public final String get_jtax_transaction_jts_wrongstatetx() {
        return get_jtax_transaction_jts_wrongstatetx$str();
    }
    @Override
    public final void warn_jtax_transaction_jts_xaenderror() {
        log.logv(FQCN, WARN, null, warn_jtax_transaction_jts_xaenderror$str());
    }
    protected String warn_jtax_transaction_jts_xaenderror$str() {
        return "ARJUNA024055: Could not call end on a suspended resource!";
    }
    @Override
    public final void warn_jtax_transaction_jts_xaerror(final String arg0, final String arg1, final Throwable arg2) {
        log.logv(FQCN, WARN, arg2, warn_jtax_transaction_jts_xaerror$str(), arg0, arg1);
    }
    protected String warn_jtax_transaction_jts_xaerror$str() {
        return "ARJUNA024056: {0} caught XA exception: {1}";
    }
    @Override
    public final void warn_jtax_transaction_jts_timeouterror(final String arg0, final String arg1, final String arg2, final Throwable arg3) {
        log.logv(FQCN, WARN, arg3, warn_jtax_transaction_jts_timeouterror$str(), arg0, arg1, arg2);
    }
    protected String warn_jtax_transaction_jts_timeouterror$str() {
        return "ARJUNA024057: {0} setTransactionTimeout on XAResource {2} threw: {1}";
    }
    @Override
    public final void warn_could_not_load_class_will_wait_for_bottom_up(final ClassNotFoundException cnfe) {
        log.logv(FQCN, WARN, cnfe, warn_could_not_load_class_will_wait_for_bottom_up$str());
    }
    protected String warn_could_not_load_class_will_wait_for_bottom_up$str() {
        return "ARJUNA024058: Could not deserialize class. Will wait for bottom up recovery";
    }
    protected String get_not_supported$str() {
        return "ARJUNA024059: Inflow recovery is not supported for JTS mode";
    }
    @Override
    public final String get_not_supported() {
        return get_not_supported$str();
    }
    @Override
    public final void warn_could_not_end_xar(final XAResource xar, final XAException e1) {
        log.logv(FQCN, WARN, e1, warn_could_not_end_xar$str(), xar);
    }
    protected String warn_could_not_end_xar$str() {
        return "ARJUNA024060: Could not end XA resource {0}";
    }
    @Override
    public final void warn_could_not_enlist_xar(final XAResource xar, final Object[] params, final Exception e1) {
        log.logv(FQCN, WARN, e1, warn_could_not_enlist_xar$str(), xar, java.util.Arrays.toString(params));
    }
    protected String warn_could_not_enlist_xar$str() {
        return "ARJUNA024061: Could not enlist XA resource {0} with params {1}";
    }
    @Override
    public final void warn_jtax_resources_jts_orbspecific_cant_commit_onephase(final Xid xid, final Class<? extends Throwable> corbaException, final Throwable e) {
        log.logv(FQCN, WARN, e, warn_jtax_resources_jts_orbspecific_cant_commit_onephase$str(), xid, corbaException);
    }
    protected String warn_jtax_resources_jts_orbspecific_cant_commit_onephase$str() {
        return "ARJUNA024062: ORB ''{0}'' occured on one phase commit for xid {1}";
    }
    @Override
    public final void warn_jtax_resources_jts_cant_save_state(final Xid xid, final Throwable e) {
        log.logv(FQCN, WARN, e, warn_jtax_resources_jts_cant_save_state$str(), xid);
    }
    protected String warn_jtax_resources_jts_cant_save_state$str() {
        return "ARJUNA024063: Cannot save state of xid {0}";
    }
    protected String warn_get_jtax_transaction_jts_wrongstatetx$str() {
        return "ARJUNA024064: The current transaction {0} does not match this transaction";
    }
    @Override
    public final String warn_get_jtax_transaction_jts_wrongstatetx(final AtomicTransaction txn, final Exception e) {
        return _formatMessage(warn_get_jtax_transaction_jts_wrongstatetx$str(), txn);
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    @Override
    public final void warn_cant_save_state(final OutputObjectState os, final int ot, final IOException e) {
        log.logv(FQCN, WARN, e, warn_cant_save_state$str(), os, ot);
    }
    protected String warn_cant_save_state$str() {
        return "ARJUNA024065: Cannot save state of output object state {0} of object type {1}";
    }
    @Override
    public final void warn_cant_restore_state(final InputObjectState os, final int ot, final IOException ex) {
        log.logv(FQCN, WARN, ex, warn_cant_restore_state$str(), os, ot);
    }
    protected String warn_cant_restore_state$str() {
        return "ARJUNA024066: Cannot restore state of input object state {0} of object type {1}";
    }
    @Override
    public final void warn_jtax_transaction_jts_ex(final Exception e) {
        log.logv(FQCN, WARN, e, warn_jtax_transaction_jts_ex$str());
    }
    protected String warn_jtax_transaction_jts_ex$str() {
        return "ARJUNA024068: Caught exception:";
    }
}
