/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeHeaderDelegate
implements RuntimeDelegate.HeaderDelegate {
    public Object fromString(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("MediaType value is null");
        }
        return MediaTypeHeaderDelegate.parse(type);
    }

    private static int getEndName(String params, int start) {
        int equals = params.indexOf(61, start);
        int semicolon = params.indexOf(59, start);
        if (equals == -1 && semicolon == -1) {
            return params.length();
        }
        if (equals == -1) {
            return semicolon;
        }
        if (semicolon == -1) {
            return equals;
        }
        int end = equals < semicolon ? equals : semicolon;
        return end;
    }

    public static int setParam(HashMap<String, String> typeParams, String params, int start) {
        int i;
        boolean quote = false;
        boolean backslash = false;
        int end = MediaTypeHeaderDelegate.getEndName(params, start);
        String name = params.substring(start, end).trim();
        if (end < params.length() && params.charAt(end) == '=') {
            ++end;
        }
        StringBuffer buffer = new StringBuffer();
        block5: for (i = end; i < params.length(); ++i) {
            char c = params.charAt(i);
            switch (c) {
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        buffer.append(c);
                        continue block5;
                    }
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (!backslash) continue block5;
                    backslash = false;
                    buffer.append(c);
                    continue block5;
                }
                case ';': {
                    if (!quote) {
                        String value = buffer.toString().trim();
                        typeParams.put(name, value);
                        return i + 1;
                    }
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String value = buffer.toString().trim();
        typeParams.put(name, value);
        return i;
    }

    public static MediaType parse(String type) {
        String params = null;
        int idx = type.indexOf(";");
        if (idx > -1) {
            params = type.substring(idx + 1).trim();
            type = type.substring(0, idx);
        }
        String major = null;
        String subtype = null;
        String[] paths = type.split("/");
        if (paths.length < 2 && type.equals("*")) {
            major = "*";
            subtype = "*";
        } else {
            if (paths.length != 2) {
                throw new IllegalArgumentException("Failure parsing MediaType string: " + type);
            }
            if (paths.length == 2) {
                major = paths[0];
                subtype = paths[1];
            }
        }
        if (params != null && !params.equals("")) {
            HashMap<String, String> typeParams = new HashMap<String, String>();
            int start = 0;
            while (start < params.length()) {
                start = MediaTypeHeaderDelegate.setParam(typeParams, params, start);
            }
            return new MediaType(major, subtype, typeParams);
        }
        return new MediaType(major, subtype);
    }

    public String toString(Object o) {
        MediaType type = (MediaType)o;
        String rtn = type.getType().toLowerCase() + "/" + type.getSubtype().toLowerCase();
        if (type.getParameters() == null || type.getParameters().size() == 0) {
            return rtn;
        }
        for (String name : type.getParameters().keySet()) {
            String val = (String)type.getParameters().get(name);
            rtn = rtn + ";" + name + "=\"" + val + "\"";
        }
        return rtn;
    }
}

