/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.scannotation.AnnotationDB;
import org.scannotation.WarUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyBootstrap
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ResteasyBootstrap.class);
    protected ResteasyDeployment deployment = new ResteasyDeployment();

    public void contextInitialized(ServletContextEvent event) {
        String append;
        String after;
        String before;
        String languageExtensions;
        String mimeExtentions;
        String resources;
        String jndiResources;
        String sResources;
        String scanAll;
        String builtin;
        String resourceMethodInterceptors;
        String applicationConfig;
        String deploymentSensitive = event.getServletContext().getInitParameter("resteasy.use.deployment.sensitive.factory");
        if (deploymentSensitive != null) {
            this.deployment.setDeploymentSensitiveFactoryEnabled(Boolean.valueOf(deploymentSensitive.trim()));
        } else {
            this.deployment.setDeploymentSensitiveFactoryEnabled(true);
        }
        String async = event.getServletContext().getInitParameter("resteasy.async.job.service.enabled");
        if (async != null) {
            this.deployment.setAsyncJobServiceEnabled(Boolean.valueOf(async.trim()));
        }
        if (this.deployment.isAsyncJobServiceEnabled()) {
            String basePath;
            String threadPool;
            String maxWaitStr;
            String maxJobResults = event.getServletContext().getInitParameter("resteasy.async.job.service.max.job.results");
            if (maxJobResults != null) {
                int maxJobs = Integer.valueOf(maxJobResults);
                this.deployment.setAsyncJobServiceMaxJobResults(maxJobs);
            }
            if ((maxWaitStr = event.getServletContext().getInitParameter("resteasy.async.job.service.max.wait")) != null) {
                long maxWait = Long.valueOf(maxWaitStr);
                this.deployment.setAsyncJobServiceMaxWait(maxWait);
            }
            if ((threadPool = event.getServletContext().getInitParameter("resteasy.async.job.service.thread.pool.size")) != null) {
                int threadPoolSize = Integer.valueOf(threadPool);
                this.deployment.setAsyncJobServiceThreadPoolSize(threadPoolSize);
            }
            if ((basePath = event.getServletContext().getInitParameter("resteasy.async.job.service.base.path")) != null) {
                this.deployment.setAsyncJobServiceBasePath(basePath);
            }
        }
        if ((applicationConfig = event.getServletContext().getInitParameter(Application.class.getName())) == null) {
            applicationConfig = event.getServletContext().getInitParameter("javax.ws.rs.Application");
        } else {
            logger.warn("The use of " + Application.class.getName() + " is deprecated, please use javax.ws.rs.Application as a context-param instead");
        }
        String providers = event.getServletContext().getInitParameter("resteasy.providers");
        if (providers != null) {
            String[] p;
            for (String pr : p = providers.split(",")) {
                this.deployment.getProviderClasses().add(pr.trim());
            }
        }
        if ((resourceMethodInterceptors = event.getServletContext().getInitParameter("resteasy.resource.method.interceptors")) != null) {
            throw new RuntimeException("resteasy.resource.method.interceptors is no longer a supported context param.  See documentation for more details");
        }
        String resteasySecurity = event.getServletContext().getInitParameter("resteasy.role.based.security");
        if (resteasySecurity != null) {
            this.deployment.setSecurityEnabled(Boolean.valueOf(resteasySecurity.trim()));
        }
        if ((builtin = event.getServletContext().getInitParameter("resteasy.use.builtin.providers")) != null) {
            this.deployment.setRegisterBuiltin(Boolean.valueOf(builtin.trim()));
        }
        boolean scanProviders = false;
        boolean scanResources = false;
        String sProviders = event.getServletContext().getInitParameter("resteasy.scan.providers");
        if (sProviders != null) {
            scanProviders = Boolean.valueOf(sProviders.trim());
        }
        if ((scanAll = event.getServletContext().getInitParameter("resteasy.scan")) != null) {
            boolean tmp = Boolean.valueOf(scanAll.trim());
            scanProviders = tmp || scanProviders;
            boolean bl = scanResources = tmp || scanResources;
        }
        if ((sResources = event.getServletContext().getInitParameter("resteasy.scan.resources")) != null) {
            scanResources = Boolean.valueOf(sResources.trim());
        }
        if (scanProviders || scanResources) {
            if (applicationConfig != null) {
                throw new RuntimeException("You cannot deploy a javax.ws.rs.core.Application and have scanning on as this may create errors");
            }
            URL[] urls = WarUrlFinder.findWebInfLibClasspaths((ServletContextEvent)event);
            URL url = WarUrlFinder.findWebInfClassesPath((ServletContextEvent)event);
            AnnotationDB db = new AnnotationDB();
            String[] ignoredPackages = new String[]{"org.jboss.resteasy.plugins", "org.jboss.resteasy.annotations", "org.jboss.resteasy.client", "org.jboss.resteasy.specimpl", "org.jboss.resteasy.core", "org.jboss.resteasy.spi", "org.jboss.resteasy.util", "org.jboss.resteasy.mock", "javax.ws.rs"};
            db.setIgnoredPackages(ignoredPackages);
            try {
                if (url != null) {
                    db.scanArchives(new URL[]{url});
                }
                db.scanArchives(urls);
                try {
                    db.crossReferenceImplementedInterfaces();
                    db.crossReferenceMetaAnnotations();
                }
                catch (AnnotationDB.CrossReferenceException ignored) {}
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to scan WEB-INF for JAX-RS annotations, you must manually register your classes/resources", e);
            }
            if (scanProviders) {
                this.processProviders(db);
            }
            if (scanResources) {
                this.processResources(db);
            }
        }
        if ((jndiResources = event.getServletContext().getInitParameter("resteasy.jndi.resources")) != null) {
            this.processJndiResources(jndiResources);
        }
        if ((resources = event.getServletContext().getInitParameter("resteasy.resources")) != null) {
            this.processResources(resources);
        }
        if ((mimeExtentions = event.getServletContext().getInitParameter("resteasy.media.type.mappings")) != null) {
            Map<String, String> map = this.parseMap(mimeExtentions);
            this.deployment.setMediaTypeMappings(map);
        }
        if ((languageExtensions = event.getServletContext().getInitParameter("resteasy.language.mappings")) != null) {
            Map<String, String> map = this.parseMap(languageExtensions);
            this.deployment.setLanguageExtensions(map);
        }
        if ((before = event.getServletContext().getInitParameter("resteasy.interceptor.before.precedence")) != null) {
            Map<String, String> map = this.parseMap(before);
            this.deployment.setInterceptorBeforePrecedences(map);
        }
        if ((after = event.getServletContext().getInitParameter("resteasy.interceptor.after.precedence")) != null) {
            Map<String, String> map = this.parseMap(after);
            this.deployment.setInterceptorAfterPrecedences(map);
        }
        if ((append = event.getServletContext().getInitParameter("resteasy.append.interceptor.precedence")) != null) {
            String[] precedences;
            for (String precedence : precedences = append.split(",")) {
                this.deployment.getInterceptorPrecedences().add(precedence.trim());
            }
        }
        if (applicationConfig != null) {
            this.deployment.setApplicationClass(applicationConfig);
        }
        this.deployment.start();
        event.getServletContext().setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.deployment.getProviderFactory());
        event.getServletContext().setAttribute(Dispatcher.class.getName(), (Object)this.deployment.getDispatcher());
        event.getServletContext().setAttribute(Registry.class.getName(), (Object)this.deployment.getRegistry());
    }

    public static void processApplication(Application config, Registry registry, ResteasyProviderFactory factory) {
        logger.info("Deploying " + Application.class.getName() + ": " + config.getClass());
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (clazz.isAnnotationPresent(Path.class)) {
                    logger.info("Adding class resource " + clazz.getName() + " from Application " + Application.class.getName());
                    registry.addPerRequestResource(clazz);
                    continue;
                }
                logger.info("Adding class @Provider " + clazz.getName() + " from Application " + Application.class.getName());
                factory.registerProvider(clazz);
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (obj.getClass().isAnnotationPresent(Path.class)) {
                    logger.info("Adding singleton resource " + obj.getClass().getName() + " from Application " + Application.class.getName());
                    registry.addSingletonResource(obj);
                    continue;
                }
                logger.info("Adding singleton @Provider " + obj.getClass().getName() + " from Application " + Application.class.getName());
                factory.registerProviderInstance(obj);
            }
        }
    }

    protected Map<String, String> parseMap(String map) {
        String[] entries;
        HashMap<String, String> parsed = new HashMap<String, String>();
        for (String entry : entries = map.trim().split(",")) {
            String[] split = entry.trim().split(":");
            parsed.put(split[0].trim(), split[1].trim());
        }
        return parsed;
    }

    protected void processJndiResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            this.deployment.getJndiResources().add(resource);
        }
    }

    protected void processResources(String list) {
        String[] resources;
        for (String resource : resources = list.trim().split(",")) {
            this.deployment.getResourceClasses().add(resource);
        }
    }

    protected void processProviders(AnnotationDB db) {
        Set classes = (Set)db.getAnnotationIndex().get(Provider.class.getName());
        if (classes == null) {
            return;
        }
        for (String clazz : classes) {
            logger.info("Adding scanned @Provider: " + clazz);
            this.deployment.getProviderClasses().add(clazz);
        }
    }

    protected void processResources(AnnotationDB db) {
        HashSet classes = new HashSet();
        Set paths = (Set)db.getAnnotationIndex().get(Path.class.getName());
        if (paths != null) {
            classes.addAll(paths);
        }
        for (String clazz : classes) {
            logger.info("Adding scanned resource: " + clazz);
            this.deployment.getResourceClasses().add(clazz);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.deployment.stop();
    }
}

